<?php
/* ENTER MACHINE IP AND PORT IN PROVIDED FORMAT BELOW ('m3' => ['name' => '', 'ip' => '', 'port' => ''])*/
const MACHINES = [



    'm1' => ['name' => 'KHI 1', 'ip' => '110.93.225.217', 'port' => 4370],

    'm2' => ['name' => 'KHI 2', 'ip' => '110.93.225.217', 'port' => 5371],



];





















/* NO GO AREA */

























ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set('Asia/Karachi');

$machine = null;
if(isset($_GET['machine'])) {
    $machine = MACHINES['m' . $_GET['machine']] ?? null;
} else {?>
<h2>SELECT A MACHINE:</h2>
<?php foreach(MACHINES as $key => $m): ?>
<a href="/device?machine=<?= str_replace('m', '', $key) ?>"><?= $m['name'] ?></a><br><br>
<?php endforeach;exit;}
if(!$machine) {
    exit('Invalid machine selection');
}
if(!@$_POST['commkey']) {
    ?>
    <form method="post">
        <h2>Enter Machine Comm Key</h2>
        <input type="password" name="commkey">
        <input type="submit" value="Submit">
    </form>
    <?php
    exit;
}
require_once __DIR__ . '/lib/ZKLibrary.php';
$zk = new ZKLibrary($machine['ip'], $machine['port'], $_POST['commkey']);
$res = $zk->connect();
if(!$res) {
    throw new Exception('Unable to connect to device');
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>ZK Test</title>
</head>

<body>
    <?php
    $enableGetDeviceInfo = true;
    $enableGetUsers      = true;
    $enableGetData       = true;

    if ($res) {
        $zk->disableDevice();
        ?>
        <?php if ($enableGetDeviceInfo === true) { ?>
            <table border="1" cellpadding="5" cellspacing="2">
                <tr>
                    <td><b>Status</b></td>
                    <td>Connected</td>
                    <td><b>Version</b></td>
                    <td><?php echo($zk->getVersion()); ?></td>
                    <td><b>OS Version</b></td>
                    <td><?php echo($zk->getOSVersion()); ?></td>
                    <td><b>Platform</b></td>
                    <td><?php echo($zk->getPlatform()); ?></td>
                </tr>
                <tr>
                    <td><b>Firmware Version</b></td>
                    <td><?php echo($zk->getFirmwareVersion()); ?></td>
                    <td><b>WorkCode</b></td>
                    <td><?php echo($zk->getWorkCode()); ?></td>
                    <td><b>SSR</b></td>
                    <td><?php echo($zk->getSSR()); ?></td>
                    <td><b>Pin Width</b></td>
                    <td><?php echo($zk->getPinWidth()); ?></td>
                </tr>
                <tr>
                    <td><b>Face Function On</b></td>
                    <td><?php echo($zk->getFaceFunctionOn()); ?></td>
                    <td><b>Serial Number</b></td>
                    <td><?php echo($zk->getSerialNumber()); ?></td>
                    <td><b>Device Name</b></td>
                    <td><?php echo($zk->getDeviceName()); ?></td>
                    <td><b>Get Time</b></td>
                    <td><?php echo($zk->getTime()); ?></td>
                </tr>
            </table>
        <?php } ?>
        <hr/>
        <?php if ($enableGetUsers === true) { ?>
            <table border="1" cellpadding="5" cellspacing="2" style="float: left; margin-right: 10px;">
                <tr>
                    <th colspan="6">Data User</th>
                </tr>
                <tr>
                    <th>UID</th>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Card #</th>
                    <th>Role</th>
                    <th>Password</th>
                </tr>
                <?php
                try {
                    $users = $zk->getUser();
                    sleep(1);
                    foreach ($users as $uItem) {
                        ?>
                        <tr>
                            <td><?= $uItem[0] ?></td>
                            <td><?= $uItem[1] ?></td>
                            <td><?= $uItem[2] ?></td>
                            <td><?= $uItem[5] ?></td>
                            <td><?php echo($zk->getUserRole($uItem[3])); ?></td>
                            <td><?= $uItem[4] ?></td>
                        </tr>
                        <?php
                    }
                } catch (Exception $e) {
                    header("HTTP/1.0 404 Not Found");
                    header('HTTP', true, 500); // 500 internal server error
                }
                ?>
            </table>
        <?php } ?>
        <?php if ($enableGetData === true) { ?>
            <table border="1" cellpadding="5" cellspacing="2">
                <tr>
                    <th colspan="7">Data Attendance</th>
                </tr>
                <tr>
                    <th>UID</th>
                    <th>ID</th>
                    <th>Name</th>
                    <th>State</th>
                    <th>Date</th>
                    <th>Time</th>
                    <th>Type</th>
                </tr>
                <?php
                $attendance = $zk->getAttendance();
                if (count($attendance) > 0) {
                    $attendance = array_reverse($attendance, true);
                    sleep(1);
                    foreach ($attendance as $attItem) {
                        ?>
                        <tr>
                            <td><?= $attItem[0] ?></td>
                            <td><?= $attItem[1] ?></td>
                            <td><?= isset($users[$attItem[1]]) ? $users[$attItem[1]][2] : $attItem[1] ?></td>
                            <td><?= $zk->getAttState($attItem[2]) ?></td>
                            <td><?= date("d-m-Y", strtotime($attItem[3])) ?></td>
                            <td><?= date("H:i:s", strtotime($attItem[3])) ?></td>
                            <td><?= $zk->getAttType($attItem[4]) ?></td>
                        </tr>
                        <?php
                    }
                }
                ?>
            </table>
        <?php } ?>
        <?php
        $zk->enableDevice();
        $zk->disconnect();
    }
    ?>
</body>
</html>
