<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= (!empty($setting->title)?$setting->title:null) ?> :: <?= (!empty($title)?$title:null) ?>
    </title>
    <link rel="shortcut icon"
        href="<?= base_url((!empty($setting->favicon)?$setting->favicon:'assets/img/icons/favicon.png')) ?>"
        type="image/x-icon">
    <link href="<?= base_url('assets/css/bootstrap.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?= base_url('assets/css/pe-icon-7-stroke.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?= base_url('assets/css/custom.min.css') ?>" rel="stylesheet" type="text/css" />
</head>

<body>
    <div class="row central_container">
        <div class="col-sm-12">
            <div class="d_flex_sm align-items-center justify-content-center align-content-center height100vh_sm">
                <div class="d_flex_sm">
                    <div class="forgot-form">
                        <div class="panel panel-bd">
                            <h3 class="panel-label"><?= display(['reset', 'password']) ?></h3>
                            <div class="panel-body">
                                <form action="" method="POST">
                                    <div class="form-group">
                                        <label class="control-label" for="password"><?= display('password') ?></label>
                                        <input type="password"
                                            placeholder="<?= display(['enter', 'new', 'password'], true) ?>"
                                            name="password" id="password" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label"
                                            for="conf_password"><?= display(['confirm', 'password']) ?></label>
                                        <input type="password"
                                            placeholder="<?= display(['confirm', 'new', 'password'], true) ?>"
                                            name="conf_password" id="conf_password" class="form-control">
                                    </div>
                                    <div class="text-center">
                                        <button type="reset" class="btn btn-re"><?= display('reset') ?></button>
                                        <button type="submit" class="btn btn-log"><?= display('Submit') ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="<?= base_url('assets/js/jquery-1.12.4.min.js') ?>" type="text/javascript"></script>
    <script src="<?= base_url('assets/js/bootstrap.min.js') ?>" type="text/javascript"></script>
    <script src="<?= base_url('assets/plugins/inputmask/jquery.inputmask.min.js') ?>" type="text/javascript"></script>
    <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/sweetalert2/sweetalert2.min.css">
    <script src="<?= base_url('assets/plugins/sweetalert2/sweetalert2.min.js') ?>" type="text/javascript"></script>
    <script>
    $('form').on('submit', function(e) {
        e.preventDefault();
        let $form = $(this)
        $.ajax({
            type: "POST",
            data: $form.serialize(),
            beforeSend: function() {
                $form.find('div.error').remove()
                window.loadSwal = Swal.fire({
                    title: 'Please Wait!',
                    html: 'We are changing your password',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading()
                    },
                })
            },
            success: function(res) {
                window.loadSwal.close()
                if (res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    ).then(() => {
                        if (res.redirect) {
                            location.href = res.redirect
                        }
                    })
                } else if (res.errors) {
                    res.errors.forEach(err => {
                        $form.find(`[name=${err[0]}]`).closest('div').append(
                            `<div class="error">${err[1]}</div>`)
                    });
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error ??
                        "<?= display(['Invalid', 'response', 'from', 'server'], true) ?>",
                        'error'
                    )
                }
            }
        });
    });
    </script>
</body>

</html>