<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="google-site-verification" content="I3qAq57UDTfebw8Nds8qWJz7RYyo963UL9OB7V8XNrA" />
    <meta name="google-site-verification" content="0NOPjvgIewus_MlcLWHpXHOVMCs9sGZ3y9tf2pbaXwo" />
    <title><?php echo (!empty($setting->title)?$setting->title:null) ?> :: <?php echo (!empty($title)?$title:null) ?>
    </title>
    <link rel="shortcut icon"
        href="<?php echo base_url((!empty($setting->favicon)?$setting->favicon:'assets/img/icons/favicon.png')) ?>"
        type="image/x-icon">
    <link href="<?php echo base_url('assets/css/bootstrap.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo base_url('assets/css/pe-icon-7-stroke.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo base_url('assets/css/custom.min.css') ?>" rel="stylesheet" type="text/css" />
</head>

<body>
    <div class="row central_container">
        <div class="col-sm-12">
            <div class="d_flex_sm align-items-center justify-content-center align-content-center height100vh_sm">
                <div class="d_flex_sm">
                    <div class="login-left-bg">
                        <img src="<?= base_url() ?>assets/img/new-ui/new-logo.png" alt="hrm logo" class="hrm-logo">
                        <div class="hr-line"></div>
                        <h4 class="lg-h4">LOGIN PANEL</h4>
                        <h5 class="lg-h5">WELCOME TO HRM PORTAL</h5>
                    </div>
                    <div class="login-right-form">
                        <div class="">
                            <div class="view-header ">
                                <?php if(!isset($captcha_image)): ?>
                                <div class="header-icon">
                                    <img src="<?= base_url() ?>assets/img/icons/padlock.png" alt="appedology HRM"
                                        class="hrm-lock">
                                </div>
                                <?php endif?>
                                <div class="" style="position: absolute;width: 100%;top: -60px;">
                                    <div class="">
                                        <!-- alert message -->
                                        <?php if ($this->session->flashdata('message') != null) { ?>
                                        <div class="alert alert-info alert-dismissable">
                                            <button type="button" class="close" data-dismiss="alert"
                                                aria-hidden="true">&times;</button>
                                            <?php echo $this->session->flashdata('message'); ?>
                                        </div>
                                        <?php } ?>
                                        
                                        <?php if (!empty($error)) { ?>
                                            <div class="alert alert-danger alert-dismissable">
                                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                                <?php echo $error; ?>
                                            </div>
                                        <?php } ?>                                        
                                        
                                    </div>
                                </div>
                            </div>
                            <div class="panel panel-bd">
                                <div class="panel-body"
                                    <?= isset($captcha_image) ? 'style="padding-top:0px"' : null  ?>>
                                    <?php echo form_open('login','id="loginForm" novalidate'); ?>
                                    <div class="form-group">
                                        <label class="control-label" for="email"><?php echo display('email') ?></label>
                                        <input type="text" placeholder="apd1486@appedology.com" name="email"
                                            id="email" class="form-control" value="<?=set_value('email')?>">
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label"
                                            for="password"><?php echo display('password') ?></label>
                                        <input type="password" placeholder="<?php echo display('password') ?>"
                                            name="password" id="password" class="form-control">
                                    </div>
                                    <?php if(isset($captcha_image)): ?>
                                    <div class="form-group">
                                        <label class="control-label" for="captcha"><?php echo $captcha_image ?></label>
                                        <input type="text" placeholder="Enter captcha here" name="captcha" id="captcha"
                                            class="form-control" required="required">
                                    </div>
                                    <?php endif ?>
                                    <div>
                                        <button type="reset" class="btn btn-re"><?php echo display('reset') ?></button>
                                        <button type="submit"
                                            class="btn btn-log"><?php echo display('login') ?></button>
                                    </div>
                                    <small><a href="<?= base_url() ?>forgot-password" style="color: unset" role="button"><?= display(['forgot', 'your', 'password']) ?>?</a></small>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php if($jobs_available > 0){?>
                        <div class="jobs-div">
                            <a href="<?php echo base_url('careers') ?>" class="jobs">Current Vacancies</a>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Content Wrapper -->
    <!-- /.content-wrapper -->
    <!-- jQuery -->
    <script src="<?php echo base_url('assets/js/jquery-1.12.4.min.js') ?>" type="text/javascript"></script>
    <!-- Bootstrap -->
    <script src="<?php echo base_url('assets/js/bootstrap.min.js') ?>" type="text/javascript"></script>
</body>

</html>