<?php 
function _generate_sidebar($module, $item, &$ci = null, $level = 1, $item_label = '')
{
    if(in_array($module['module'], ['developer']) && $ci->session->userdata('isAdmin')) {
        return;
    }
    if($item['permission'] == 'all') {
    } elseif($level == 1 && $module['module'] == 'dashboard' && (
        $ci->permission->module('user')->access() ||
        $ci->permission->module('role_permission')->access() ||
        $ci->permission->module('application_setting')->access() ||
        $ci->permission->module('email_settings')->access() ||
        $ci->permission->module('language')->access() ||
        $ci->permission->module('document_templates_head')->access()
    )) {
    } elseif (!$ci->permission->module($level == 1 ? $module['module'] : $item_label)->access()) {
        return;
    }
    if($item['controller']) {
        $_match = [];
        $_uri = $module['module'] . '/';
        if(strtolower($module['module']) != strtolower($item['controller'])) {
            $_uri .= $item['controller'] . '/';
        }
        if($item['method']) {
            $_uri .= $item['method'];
        } else {
            $_match[] = strtolower($_uri) . '/' . 'index';
        }
        $_match[] = strtolower($_uri);
        echo '<li class="treeview' . (in_array(strtolower(uri_string()), $_match) ? ' active' : null) . '">
                <a href="' . base_url($_uri) . '">' .
                    ($level == 1 ? $module['icon'] : null) .
                    '<span>' . display($level == 1 ? $module['label'] : $item_label) . '</span>
                </a>
            </li>';
    } else {
        echo '<li class="treeview';
        if($level == 1) {
            echo ' sdbr-' . $module['module'];
        }
        if($ci->uri->total_segments() == 3) {
            if(
                $ci->uri->segment(1) == $module['module']
                && $ci->uri->segment(2)
                && ($ci->uri->segment(3)
                && in_array($ci->uri->segment(2), array_column(flatten_sidebar($item), 'controller')))
                && in_array($ci->uri->segment(3), array_column(flatten_sidebar($item), 'method'))
            ) {
                echo ' active';
            }
        } else {
            if(
                $ci->uri->segment(1) == $module['module']
                && $ci->uri->segment(2)
                && in_array($ci->uri->segment(2), array_column(flatten_sidebar($item), 'method'))
            ) {
                echo ' active';
            }
        }
        echo '">
        <a href="javascript:void(0)">' .
            ($level == 1 ? $module['icon'] : null) .
            '<span>' . display($level == 1 ? $module['label'] : $item_label) . '</span>
            <span class="pull-right-container">
                <i class="fa fa-angle-left pull-right"></i>
            </span>
        </a> 
        <ul class="treeview-menu">';
        foreach ($item as $item_label => $itm) {
            _generate_sidebar($module, $itm, $ci, ++$level, $item_label);
        }
        echo '</ul>';
    }
}
?>
<style>
    .user-panel .info p {
        white-space: break-spaces;
    }
    .user-panel .info small {
        color: #888;
        white-space: break-spaces;
    }

    .main-sidebar .user-panel {
        z-index: 9999;
        overflow: unset;
    }
    .padding-top-10 {
        padding-top: 10px !important;
    }
    
    .sidebar .dropdown-break  {
        display: flex;
    }
    .sidebar .dropdown-break ul {
        float: none;
        margin: 0 auto;
    }
    .sidebar .dropdown-break.navbar-custom-menu > .navbar-nav > li {
        position: unset;    
    }
    .sidebar .dropdown-break.navbar-custom-menu > .navbar-nav > li a,
    .sidebar .dropdown-break.navbar-custom-menu > .navbar-nav > li i {
        font-size: 15px;
        height: auto;
        background: transparent;
        border: none;
        width: auto;
        margin-top: 0;
        padding-top: 4px;
        padding-bottom: 4px;
    }
    
    .sidebar .dropdown-break.navbar-custom-menu > .navbar-nav > li ul.dropdown-menu {
        left: unset;
        right: unset;
        max-width: 50%;
        /* min-width: 140px; */
        margin-top: -30px;
        padding: 10px 0;
        background-color: #05253a;
        background-color: #ffffff;
        border: none;
        border-radius: 4px;
    }

    .sidebar .dropdown-break.navbar-custom-menu > .navbar-nav > li ul.dropdown-menu li {
        padding-top: 5px;
    }
    .sidebar .dropdown-break.navbar-custom-menu > .navbar-nav > li ul.dropdown-menu li:hover {
        background-color: #05253a;
    }
    .sidebar .dropdown-break.navbar-custom-menu > .navbar-nav > li ul.dropdown-menu li:hover button {
        color: #fff !important;
        opacity: 1;
    }

    .sidebar .btn-break {
        background: transparent !important;
    }

    .user-panel .image img {
        width: 100%;
        max-width: 90px;
        min-height: 90px;
    }

    .btn-size {
        background-color: transparent !important;
        width: 80%;
        margin-bottom: 5px;
        font-size: 16px;
        padding: 3px 0px;
        color: #05253a !important;
        text-align: left;
        margin-left: 15px;
    }
    .icon-warning::before {
        color: yellow !important;
    }
    .not-available-color::before {
        color: red !important;
    }

</style>
<div class="sidebar">
    <div class="user-panel text-center" >
        <div class="image">
            <?php $image = $this->session->userdata('image') ?>
            <img src="<?= base_url((!empty($image)?$image:'assets/img/icons/default.jpg')) ?>?id=<?= $this->session->userdata('id') ?>" class="img-circle"
                alt="User Image">
        </div>
        <div class="info">
            <p><?= $this->session->userdata('fullname') ?></p>
            <div><small><?= $this->session->userdata('designation') ?></small></div>
            <div class="navbar-custom-menu dropdown-break">
                <ul class="nav navbar-nav ">
                    <!-- settings -->
                    <li class="dropdown dropdown-user available">
                        <a href="#" class="dropdown-toggle btn-break" data-toggle="dropdown" aria-expanded="true">
                            <i class="fa fa-circle"></i> 
                            <?php  /*#= $this->session->userdata('user_level')*/ ?>
                            <span class="text-capitalize text-white">Available</span>
                        </a>
                        <input type="hidden" id="start_time">
                        <input type="hidden" id="status">
                        <input type="hidden" id="date">
                        <input type="hidden" id="break_time_id">
                        <?php if($this->session->userdata('employee_id')): ?>
                            <ul class="dropdown-menu">
                                    <li style="padding-top: 5px;"><button type="submit" onclick="dropStstus('Meal')" data-type="meal" data-status="start" class="btn btn-size btn-lg btn-success punch_break_time disable-stop">Meal Break</button></li>
                                    <li><button type="submit" onclick="dropStstus('Tea')" data-type="tea" data-status="start" class="btn btn-size btn-lg btn-success punch_break_time disable-stop">Tea Break</button></li>
                                    <li><button type="submit" onclick="dropStstus('Pray')" data-type="pray" data-status="start" class="btn btn-size btn-lg btn-success punch_break_time disable-stop">Pray Break</button></li>
                                    <li><button type="submit" onclick="dropStstus('Play')" data-type="play" data-status="start" class="btn btn-size btn-lg btn-success punch_break_time disable-stop">Play Break</button></li>
                                    <li><button type="submit" onclick="dropStstus('Washroom')" data-type="washroom" data-status="start" class="btn btn-size btn-lg btn-success punch_break_time disable-stop">Washroom Break</button></li>
                                    <li><button type="submit" onclick="dropStstus('Smoking')" data-type="smoking" data-status="start" class="btn btn-size btn-lg btn-success punch_break_time disable-stop">Smoking Break</button></li>
                                    <li><button id="stop-btn" type="submit" data-status="end" onclick="dropStstus('Available')"  class="btn btn-size btn-success punch_break_time">Available</button> </li>
                            </ul>
                        <?php endif?>
                    </li>
                    <li class="dropdown dropdown-user not-available">
                        <i class="fa fa-circle not-available-color"></i> 
                        <span class="text-capitalize text-white">Not Available</span>
                    </li>
                    <?php if($this->session->userdata('employee_id')):?>
                            <input type="hidden" name="employee_id" id="break_employee_id" class="form-control break_employee_id"
                                value="<?php echo $this->session->userdata('employee_id');?>">
                            <input type="hidden" name="is_admin" id="is_admin" class="form-control is_admin_for_break"
                                value="">
                    <?php endif?>
                </ul>
            </div>
        </div>
    </div>
    <!-- sidebar menu -->
    <ul class="sidebar-menu">
        <?php foreach ($this->_side__bar as $module) {
            _generate_sidebar(
                ['label' => $module['label'] ?? $module['module'], 'module' => $module['module'], 'icon' => $module['icon']],
                $module['items'],
                get_instance()
            );
        }?>
        <li>
            <div id="big_notif_panel">
                <?php if($this->permission->method('noticeboard', 'read')->access()): ?>
                <div class="">
                    <button class="btn btn-noti"><a href="<?= base_url() ?>noticeboard/Notice_controller/create_notice"
                            class="notif-txt">Notice Board <span class="count">0</span></a></button>
                </div>
                <?php endif?>
                <?php if($this->permission->method('notification', 'read')->access()) :?>
                <div class="">
                    <button class="btn btn-notificat"><a href="<?= base_url() ?>notification/Notification/index"
                            class="notificat-txt">Notification <span class="count">0</span></a></button>
                </div>
                <?php endif?>
            </div>
        </li>
        <li>
            <div id="small_notif_panel" style="display:none">
                <?php if($this->permission->method('noticeboard', 'read')->access()): ?>
                <div class="">
                    <button class="btn btn-noti"><a href="<?= base_url() ?>noticeboard/Notice_controller/create_notice"
                            class="notif-txt"><i class="fa fa-clipboard" aria-hidden="true"></i> <span
                                class="count">0</span></a></button>
                </div>
                <?php endif?>
                <?php if($this->permission->method('notification', 'read')->access()) :?>
                <div class="">
                    <button class="btn btn-notificat"><a href="<?= base_url() ?>notification/Notification/index"
                            class="notificat-txt"><i class="fa fa-bell-o notified" aria-hidden="true"></i> <span
                                class="count">0</span></a></button>
                </div>
                <?php endif?>
            </div>
        </li>
    </ul>
</div> <!-- /.sidebar -->
<script type="text/javascript">

    function dropStstus(x){
        if (x != 'Available') {
            $('.btn-break i').addClass('icon-warning');
        }
        else {
            $('.btn-break i').removeClass('icon-warning');
        }
        $(".btn-break span").text(x + ' Break');
    }
var toastrOpts = {
    "closeButton": false,
    "debug": false,
    "newestOnTop": true,
    "progressBar": true,
    "positionClass": "toast-top-center",
    "preventDuplicates": false,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "5000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
}
$('.btn-noti, .btn-noti>a').on('click', function(e) {
    e.preventDefault()
    location.href = '<?= base_url() ?>noticeboard/Notice_controller/create_notice'
})
$('.btn-notificat, .btn-notificat>a').on('click', function(e) {
    e.preventDefault()
    location.href = '<?= base_url() ?>notification/Notification/index'
})
$(document).ready(function() {
    $.ajax({
        type: "POST",
        url: "<?= base_url();?>notification/Notification/countNotification",
        beforeSend: () => {},
        success: function(data) {
            <?php if($this->session->flashdata('show_notifications_toaster')): ?>
            if (data > 0) {
                toastr.info(`You have ${data} new notification${data > 1 ? 's' : ''}!`, null, $
                    .extend({}, toastrOpts, {
                        onclick: () => {
                            location.href =
                                '<?= base_url('notification/Notification/index') ?>'
                        }
                    }))
            }
            <?php endif ?>
            $('.btn-notificat .count').text(data)
        }
    });
    $.ajax({
        type: "POST",
        url: "<?= base_url();?>noticeboard/Notice_controller/unread_count",
        beforeSend: () => {},
        success: function(data) {
            if (data.count) {
                <?php if($this->session->flashdata('show_notifications_toaster')): ?>
                if (data.count > 0) {
                    toastr.warning(`You have ${data.count} new notice${data.count > 1 ? 's' : ''}!`,
                        null, $.extend({}, toastrOpts, {
                            timeOut: 7000,
                            onclick: () => {
                                location.href =
                                    '<?= base_url('noticeboard/Notice_controller/create_notice') ?>'
                            }
                        }))
                }
                <?php endif ?>
                $('.btn-noti .count').text(data.count)
            }
        }
    });

    //Check Today Attendance 
    $('.not-available').hide();
    $('.available').hide();

    $.ajax({
        type: "get",
        url: '<?= base_url('dashboard/home/check_current_attendance') ?>',
        success: function(res) {
            if (res.status == 'not-available') {
                $('.not-available').show();
            }
            else {
                $('.available').show();
            }
            
        }
    });
});
    $('.punch_break_time').on('click',function(e) {
        e.preventDefault();

        var type = $(this).attr('data-type');
        var employee_id = $('#break_employee_id').val();

        var checkAction = $(this).attr('data-status');

        var data = {
            id: $('#break_time_id').val(),
            type: type,
            employee_id: employee_id,
            date: $('#date').val(),
            start_time: $('#start_time').val(),
            status: checkAction == 'end' ? 'end' : $('#status').val(),
            checkAction: checkAction
        }
        $.ajax({
            type: "POST",
            url: '<?= base_url('dashboard/home/punch_break_time') ?>',
            // url: "/dashboard/home/punch_break_time",
            data: data,
            success: function (res) {
                if(res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                    punch_break_time();
                    // window.break_time_table.fnDraw();
                } else if(res.info) {
                    Swal.fire(
                        '<?= display('Info') ?>!',
                        res.info,
                        'info'
                    )
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                }
            }
        });
    })
    var timer = null;
    function punch_break_time() {
        var count = 0;
        var time = '';
        $.ajax({
            type: "get",
            url: '<?= base_url('dashboard/home/punch_break_time') ?>',
            data: {employee_id: $('#break_employee_id').val()},
            // url: "/dashboard/home/punch_break_time",
            success: function (res) {
                if (res.data != null) {
                    
                    $('#break_time_id').val(res.data.id);
                    $('#date').val(res.data.date);
                    $('#start_time').val(res.data.start_time);
                    $('#status').val(res.data.status == 'start' ? 'end' : '');
                    if (res.data.break_type != 'Available') {
                        $('.btn-break i').addClass('icon-warning');
                    }
                    else {
                        $('.btn-break i').removeClass('icon-warning');
                    }
                    // $('#type-display').text(res.data.break_type+ ' Time');

                    if (res.data.status == 'start') {
                        clearInterval(timer);
                        $('#timer').show();
                        timer = setInterval(function() {
                        count = (new Date() - new Date(res.data.start_time)) / 1000;
                        var minutes = Math.floor(count / 60);
                        var hours = Math.floor(minutes / 60);

                        if (minutes >= 60) {
                            time = (hours < 10 ? "0" + hours : hours) + ":" +
                                        (minutes % 60 < 10 ? "0" + (minutes % 60) : minutes % 60) + ":" +
                                        ((count % 60).toFixed(0) < 10 ? "0" + (count % 60).toFixed(0) : (count % 60).toFixed(0));
                        }
                        else {
                            time = (minutes < 10 ? "0" + (minutes) : minutes) + ":" +
                                    ((count % 60).toFixed(0) < 10 ? "0" + (count % 60).toFixed(0) : (count % 60).toFixed(0));
                        }

                        // $('#timer').text(time);
                        $(".btn-break span").text(res.data.break_type + ' Break ('+time+')')

                        }, 1000); // 1000 milliseconds = 1 second

                        
                        $('#stop-btn').show();
                        $('.disable-stop').attr("disabled", true);
                    }            
                }
                else {
                    clearInterval(timer);
                    $('#timer').text('00:00:00');
                    $('#stop-btn').hide();
                    $('#type-display').text('');
                    $('#break_time_id').val('');
                    $('#date').val('');
                    $('#start_time').val('');
                    $('#status').val('');
                    $('.disable-stop').attr("disabled", $('#break_employee_id').val() == 0 ? true : false);
                    $('#stop-btn').hide();
                    $('.btn-break i').removeClass('icon-warning');
                    $(".btn-break span").text('Available')

                }
            }
        });
    }

    $(function() {
        var role = <?= $this->session->userdata('isAdmin') == 1 ? 1 : 0 ?>;
        if (role == 0) {
            punch_break_time();
        }

        $('.navbar-custom-menu .select2-selection__rendered').hover(function () {
            $(this).removeAttr('title');
        });
    });
</script>