<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Template extends MY_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model(array(
			'template_model',
		));
	}
 
	public function layout($data)
	{  
		$id = $this->session->userdata('id');
		$data['notifications'] = [];
		$data['quick_messages'] = [];
		$data['setting'] = $this->template_model->setting();
		$this->load->view('layout', $data);
	}
 
	public function login($data)
	{ 
		$this->load->model('recruitment/job_model');
		$data['setting'] = $this->template_model->setting();
		$data['jobs_available'] = $this->job_model->count_open_listings();
		$this->load->view('login', $data);
	}
	public function login_verify($data)
	{ 
		$data['setting'] = $this->template_model->setting();
		$this->load->view('login_verify', $data);
	}
	public function forgot_password($data)
	{ 
		$data['setting'] = $this->template_model->setting();
		$data['current_domain'] = $this->template_model->get_domain();
		$this->load->view('forgot_password', $data);
	}
	public function reset_password($data)
	{ 
		$data['setting'] = $this->template_model->setting();
		$data['current_domain'] = $this->template_model->get_domain();
		$this->load->view('reset_password', $data);
	}
	public function invalid_reset_url($data)
	{ 
		$data['setting'] = $this->template_model->setting();
		$this->load->view('invalid_reset_url', $data);
	}
	public function game_night($data)
	{ 
		$data['setting'] = $this->template_model->setting();
		$this->load->view('game-night', $data);
	}
 
}
