<div class="container-fluid">
    <div class="row">
        <form action="<?=base_url('reports/leave/attendance_report');?>" method="POST">
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-6">
                <div class="form-group">
                  <label for="">Month</label>
                  </select>
                  <input type="month" required name="month" id="month" class="form-control" value="<?=isset($month)?$month:date('m,Y',date('Y-m-d'));?>">
                </div>
            </div>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-6">
                <div class="form-group">
                  <label for="">Department</label>
                  <select class="form-control" name="department_id" id="selDepartments" required>
                    <option value="">---Select Department---</option>
                    <?php foreach ($dropdowns['department_ids'] as $department) :?>
                        <option value="<?=$department->id.'|'.$department->label?>" <?=isset($department_id) && $department_id==$department->id?'selected':'';?>><?= $department->label ?></option>
                    <?php endforeach?>
                  </select>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <button type="submit" class="btn btn-primary pull-right">Filter</button>
            </div>
        </form>
    </div>
    <br>
    <table class="table table-hover">
        <thead>
            <tr>
                <th>Employee ID</th>
                <th>Employee Name</th>
                <th>Department</th>
                <th>Shift</th>
                <th>Employee Status</th>
                <th>Date of Joining</th>
                <th>Date of Seperation</th>
                <th>Attendance Date</th>
                <th>Actual Punch In</th>
                <th>Punch In Via</th>
                <th>Actual Punch Out</th>
                <th>Punch Out Via</th>
                <th>Adjusted Punch In</th>
                <th>Adjusted Punch Out</th>
                <th>Attendance Adjusted by</th>
                <th>Attendance Status</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($employees_attendance as $attendance): 
                foreach($attendance as $emp_att): ?>
            <tr>
               <td><?=$emp_att['hrm_id'];?></td> 
               <td><?=$emp_att['name'];?></td> 
               <td><?=$department_name;?></td> 
               <td><?=$emp_att['shift'];?></td>
               <td><?=$emp_att['employee_status'];?></td>
               <td><?=date('m/d/Y',strtotime($emp_att['doj']));?></td>
               <td><?=$emp_att['dos'];?></td>
               <td><?=date('m/d/Y',strtotime($emp_att['attendance_date']));?></td>
               <td><?=date('h:i:s A',strtotime($emp_att['punchin_time']));;?></td>
               <td><?=$emp_att['punchin_via'];?></td>
               <td><?=date('h:i:s A',strtotime($emp_att['punchout_time']));?></td>
               <td><?=$emp_att['punchout_via'];?></td>
               <td><?=$emp_att['punchin_time_adjusted'];?></td>
               <td><?=$emp_att['punchout_time_adjusted'];?></td>
               <td><?=$emp_att['attendance_adjusted_by'];?></td>
               <td><?=$emp_att['attendance_status'];?></td>
            </tr>
            <?php endforeach; endforeach ?>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
         window.dtable = $('table.table').DataTable($.extend({}, window.default_datatable_opts, {
            responsive: false,
            scrollX:        true,
            scrollCollapse: true,
            fixedColumns:   {
                left: 4,
            }
        }))
         <?php if($this->input->method(TRUE)!=='POST'):?>
         const currentDate = new Date();
        // Get the year and month in yyyy-MM format
        const currentYear = currentDate.getFullYear();
        const currentMonth = (currentDate.getMonth() + 1).toString().padStart(2, '0'); // Adding 1 because months are zero-indexed
        // Set the value attribute of the input element
        const monthInput = document.getElementById('month');
        monthInput.value = `${currentYear}-${currentMonth}`;
        <?php endif;?>
    });
</script>