<style>
.nav-tabs li>a {
    pointer-events: auto !important;
}
</style>
<div class="container-fluid">
    <div class="row">
        <form>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="selYear">Year</label>
                    <select class="form-control" name="year" id="selYear" required>
                        <?php foreach ($years as $lp_year) :?>
                        <option value="<?= $lp_year ?>" <?= $year == $lp_year  ? 'selected' : null ?>><?= $lp_year ?>
                        </option>
                        <?php endforeach?>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="selMonth">Month</label>
                    <select class="form-control" name="month" id="selMonth" required>
                        <option value="ALL" <?= $month == "ALL"  ? 'selected' : null ?>>ALL</option>
                        <?php foreach ($months as $key => $lp_month) :?>
                        <option value="<?= $key ?>" <?= $month == $key  ? 'selected' : null ?>><?= $lp_month ?></option>
                        <?php endforeach?>
                    </select>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-right">
                <button type="submit" name="action" value="submit" class="btn btn-primary"><?= display('view') ?></button>
                <button type="submit" name="action" value="download" class="btn btn-primary"><?= display('download') ?></button>
            </div>
        </form>
    </div>
    <div role="tabpanel">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li role="summary" class="active">
                <a href="#summary" aria-controls="summary" role="tab" data-toggle="tab"><?= display('summary') ?></a>
            </li>
            <li role="details">
                <a href="#details" aria-controls="details" role="tab" data-toggle="tab"><?= display('details') ?></a>
            </li>
        </ul>

        <!-- Tab panes -->
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="summary">
                <table class="table datatable table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?= display('department') ?></th>
                            <th><?= display('active') ?></th>
                            <th><?= display('separated') ?></th>
                            <th><?= display('attrition_rate') ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($summary as $key => $data) :?>
                        <tr>
                            <td><?= $key + 1 ?></td>
                            <td><?= $data->department_name ?></td>
                            <td><?= $data->active ?? 0?></td>
                            <td><?= $data->separated ?? 0?></td>
                            <td><?= sprintf('%g', $data->rate) ?? 0?>%</td>
                        </tr>
                        <?php endforeach?>
                    </tbody>
                </table>
            </div>
            <div role="tabpanel" class="tab-pane" id="details">
            <table class="table table-bordered table-hover" style="width: 100%;">
                    <thead>
                        <tr>
                            <th><?= display('hrm_id') ?></th>
                            <th><?= display('employee_name') ?></th>
                            <th><?= display('manager_name') ?></th>
                            <th><?= display('division') ?></th>
                            <th><?= display('department') ?></th>
                            <th><?= display('designation') ?></th>
                            <th><?= display('status') ?></th>
                            <th><?= display('hire_date') ?></th>
                            <th><?= display('termination_date') ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($details as $employee) :?>
                        <tr>
                            <td><?= $employee->hrm_id ?></td>
                            <td><?= $employee->full_name ?></td>
                            <td><?= $employee->direct_manager_name ?></td>
                            <td><?= $employee->division ?></td>
                            <td><?= $employee->department ?></td>
                            <td><?= $employee->position ?></td>
                            <td><?= slug_to_readable($employee->status) ?></td>
                            <td><?= formatted_date($employee->hire_date) ?></td>
                            <td><?= formatted_date($employee->termination_date) ?></td>
                        </tr>
                        <?php endforeach?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        window.datatable_details = $('#details table').DataTable($.extend({}, {
            columnDefs: [ {
                "targets": [7, 8],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }
            
            } ],
            order: [[ 8, "asc" ]]
        }, window.default_datatable_opts))
    });
</script>