<?php
class Documents_model extends CI_Model
{
    public function divisions()
    {
        return $this->db->select('id, name as title')->order_by('name')->get('divisions')->result();
    }
    public function departments()
    {
        return $this->db->select('dept_id as id, department_name as title')->order_by('department_name')->get('department')->result();
    }
    private function query($post = [])
    {
        if (@$post['status']) {
            $this->db->where_in('employee_details.status', $post['status']);
        }
        if (@$post['division']) {
            $this->db->where('employee_details.division_id', $post['division']);
        }
        if (@$post['department']) {
            $this->db->where_in('employee_details.dept_id', $post['department']);
        }
        return $this->db->select('hrm_id, full_name, division, department, direct_manager_name, upload_documents_type.title')
            ->from('employee_details, upload_documents_type')
            ->join('upload_documents', 'upload_documents_type.id = upload_documents.document_type AND upload_documents.employee_id = employee_details.employee_id')
            ->where([
                'upload_documents_type.is_required' => 1,
                'IFNULL(upload_documents.documents, \'\') =' => '',
            ]);
    }
    public function countAllRows()
    {
        return $this->query()->count_all_results();
    }
    public function countDatatable($post, $orWhere = [])
    {
        $query = $this->query($post);
        if ($orWhere) {
            $query->group_start();
            foreach ($orWhere as $key => $value) {
                $query->or_like($key, $value);
            }
            $query->group_end();
        }
        return $query->count_all_results();
    }
    public function getDatatable($post, $orWhere = [])
    {
        $query = $this->query($post);
        if ($orWhere) {
            $query->group_start();
            foreach ($orWhere as $key => $value) {
                $query->or_like($key, $value);
            }
            $query->group_end();
        }
        $query->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $query->get()->result_array();
    }
    public function types($id = null)
    {
        if (!is_null($id)) {
            $this->db->where('upload_documents_type.id', $id);
        }
        $query = $this->db->select('id, title')->get('upload_documents_type');
        return is_null($id) ? $query->result() : $query->row();
    }
    public function getDocumentTypeReport($type, $status, $division, $department,$is_confidential)
    {
        if (!is_array($type)) {
            $type = [$type];
        }
        $status = array_filter($status);
        $division = array_filter($division);
        $department = array_filter($department);
        $this->db->select([
            'employee_history.hrm_id',
            'upload_documents.documents',
            'drive_ids.drive_id',
        ])->from('upload_documents')
            ->join('employee_history', 'upload_documents.employee_id=employee_history.employee_id', 'left')
            ->join('drive_ids', 'upload_documents.id = drive_ids.row_id AND drive_ids.table = \'upload_documents\'', 'left')
            ->where_in('upload_documents.status', ['profile-upload', 'approved'])
            ->where_in('upload_documents.document_type', $type)
            ->where_in('upload_documents.is_confidential', $is_confidential)
            ->where_in('employee_history.status', $status);
        if ($division) {
            $this->db->where_in('employee_history.division_id', $division);
        }
        if ($department) {
            $this->db->where_in('employee_history.dept_id', $department);
        }
        return $this->db->get()->result();
    }
}
