<?php
require_once APPPATH . 'libraries/Mysql_type.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Credentials_model extends CI_Model
{
    public function download($employees)
    {
        $writer = new Xlsx($this->_create_spreadsheet($employees));
        header('Content-Description: File Transfer');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="Credentials Report.xlsx"');
        header('Content-Transfer-Encoding: binary');

        $writer->save('php://output');exit;
    }
    private function _create_spreadsheet($employees)
    {
        $spreadsheet = new Spreadsheet();
        $properties = $spreadsheet->getProperties();

        $properties->setCreator('HRM Reporting System');
        $properties->setLastModifiedBy('HRM Reporting System');
        $properties->setTitle('Credentials Report');
        $properties->setSubject('Credentials Report');

        $summary_sheet = $spreadsheet->getActiveSheet();
        $summary_sheet->getSheetView()->setZoomScale(90);
        $summary_sheet->setShowGridlines(false);
        $summary_sheet->setTitle('Credentials');

        //Set Header
        $last_column = null;
        $header = $this->_headers('summary');
        foreach ($header as $column => $value) {
            $column += 1;
            $cell = $summary_sheet->getCellByColumnAndRow($column, 1);
            $cell->setValueExplicit(
                is_string($value) ? $value : $value[0],
                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
            );
            $summary_sheet->getColumnDimension($cell->getColumn())->setWidth(is_string($value) ? 20 : $value[1]);
            $last_column = $cell->getColumn();
        }
        $summary_sheet->freezePane('A2');

        if ($last_column) {
            $summary_sheet->getStyle("A1:{$last_column}1")->applyFromArray([
                'fill' => [
                    'color' => [
                        'rgb' => 'C5BE97',
                    ],
                    'fillType' => Fill::FILL_SOLID,
                ],
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => [
                            'rgb' => '000000',
                        ],
                    ],
                ],
                'font' => [
                    'bold' => 1,
                ],
                'alignment' => [
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'vertical' => Alignment::VERTICAL_CENTER,
                    'wrapText' => 1,
                ],
            ]);
        }
        //Set Data
        $row = 1;
        $meta = $this->_meta('summary');
        $this->load->model('recruitment/hired_model');
        $employees_data = [];
        foreach ($employees as $key => $employee) {
            $rec = $this->db->select('hrm_id, city, full_name, hire_date, department, business_email, position, pseudo')->where('employee_id', $employee)->get('employee_details')->row();
            $cred_rec = $this->hired_model->get_credentials($employee);
            $employees_data[] = [
                'no' => $key + 1,
                'hrm_id' => $rec->hrm_id,
                'center' => ucfirst($rec->city),
                'name' => $rec->full_name,
                'doj' => $rec->hire_date,
                'department' => $rec->department,
                'gmail' => $rec->business_email,
                'extension' => '-',
                'designation' => $rec->position,
                'pseudo' => $rec->pseudo,
                'hrm' => @$cred_rec->credentials['HRM ID']['username'],
                'hrm_pass' => @$cred_rec->credentials['HRM ID']['password'],
                'medfowpi' => @$cred_rec->credentials['Medflow PI Portal']['username'],
                'medfowpi_pass' => @$cred_rec->credentials['Medflow PI Portal']['password'],
                'medfowkhi' => @$cred_rec->credentials['Medflow KHI Portal']['username'],
                'medfowkhi_pass' => @$cred_rec->credentials['Medflow KHI Portal']['password'],
                'medfowiwp' => @$cred_rec->credentials['Medflow IWP Portal']['username'],
                'medfowiwp_pass' => @$cred_rec->credentials['Medflow IWP Portal']['password'],
                'domain' => @$cred_rec->credentials['Domain ID']['username'],
                'domain_pass' => @$cred_rec->credentials['Domain ID']['password'],
                'sp' => @$cred_rec->credentials['Medflow Settlment Portal']['username'],
                'sp_pass' => @$cred_rec->credentials['Medflow Settlment Portal']['password'],
            ];
        }
        foreach ($employees_data as $columns) {
            $row++;
            $columns = array_values((array) $columns);
            foreach ($columns as $column => $value) {
                $cell = $summary_sheet->getCellByColumnAndRow($column + 1, $row);

                if (empty($meta)) {
                    $cell->setValue($value);
                } else {
                    $mysql_types = new Mysql_type();
                    $mysql_type = $meta[$column];
                    switch ($mysql_types->check_type($mysql_type)) {
                        case $mysql_types::IS_INT: {
                            $cell->setValueExplicit(
                                floatval($value),
                                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_NUMERIC
                            );
                            $cell->getStyle()->getNumberFormat()->setFormatCode('#,##0');
                            break;
                        }
                        case $mysql_types::IS_DATE: {
                            $timestamp = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($value);
                            if (!$timestamp) {
                                $cell->setValueExplicit(
                                    $value,
                                    \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                                );
                            } else {
                                $cell->setValue($timestamp);
                                $cell->getStyle()->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_XLSX14);
                            }
                            break;
                        }
                        case $mysql_types::IS_DATETIME: {
                            $timestamp = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($value);
                            if (!$timestamp) {
                                $cell->setValueExplicit(
                                    $value,
                                    \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                                );
                            } else {
                                $cell->setValue($timestamp);
                                $cell->getStyle()->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_DATETIME);
                            }
                            break;
                        }
                        default:{
                            $cell->setValueExplicit(
                                $value,
                                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                            );
                            break;
                        }
                    }
                }
            }
        }
        if ($last_column) {
            $summary_sheet->getStyle("A1:{$last_column}{$row}")->applyFromArray([
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => [
                            'rgb' => '000000',
                        ],
                    ],
                ],
            ]);
        }

        return $spreadsheet;
    }
    private function _headers($type = null)
    {
        $headers = [
            'summary' => [
                ['No', 5],
                ['Employee ID', 15],
                ['Center', 15],
                ['Name', 25],
                ['DOJ', 10],
                ['Department', 35],
                ['Gmail', 40],
                ['Extension', 8],
                ['Designation', 35],
                'Confirmed Pseudos',
                ['HRM ID', 40],
                'Password',
                'Medflow (PI) ID',
                'Password',
                'Medflow (KHI) ID',
                'Password',
                'Medflow (IWP) ID',
                'Password',
                'Domain',
                'Password',
                ['Settlement Portal', 35],
                'Password',
            ],
        ];
        return $headers[$type];
    }
    private function _meta($type = null)
    {
        $mysql_types = new Mysql_type();
        $headers = [
            'summary' => [
                $mysql_types::TYPE_INT24,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_DATE,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
            ],
        ];
        return $headers[$type];
    }
}
