<?php
class Leave extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['leaves_model' => 'leaves']);
    }
    public function report()
    {
        $this->permission->method('leave_report', 'read')->redirect();
        $data['title'] = display('leave_report') . ' - ' . preg_replace('#[^\d]#is', '', $this->input->get('year'));
        $data['module'] = 'reports';
        $data['page'] = "leave_reports/leaves";
        $data['dropdowns'] = $this->leaves->dropdowns();

        if ($this->input->get('year') ||
            $this->input->get('employee') ||
            $this->input->get('leave_type') ||
            $this->input->get('department_id') ||
            $this->input->get('supervisor_id')) {
            $data['rows'] = $this->leaves->leave_report(
                $this->input->get('year'),
                $this->input->get('employee'),
                $this->input->get('leave_type'),
                $this->input->get('department_id'),
                $this->input->get('supervisor_id'),
            );
        }
        echo Modules::run('template/layout', $data);
    }

    public function generateAttendanceRow($attendance,$employees){
        $singleAttendance = [];

        $group_count = count($attendance);

        foreach($attendance as $key=>$att){

            if($group_count==1){
               // $data['flag'] = $att['flag'];

                $singleAttendance = [
                    'hrm_id'=>$att['hrm_id'],
                   // 'department'=>$department,
                    'shift'=>$att['name'],
                    'name'=>$att['first_name']. ' '.$att['last_name'],
                    'shift'=>$att['name'],
                    'employee_status'=>$att['employee_status'],
                    'doj'=>$att['hire_date'],
                    'dos'=>$att['termination_date'],
                    'attendance_date'=>$att['day'],
                    'punchin_time'=>$att['punchin_time'],
                    //'punchin_via'=>$punch_author->first_name.' '.$punch_author->last_name,
                    'punchin_via'=>$att['state_type'],
                    'punchout_time'=>'',
                    'punchout_via'=>'',
                    'punchin_time_adjusted'=>'N/A',
                    'punchout_time_adjusted'=>'N/A',
                    'attendance_adjusted_by'=>'N/A',
                    'attendance_status'=>$att['flag']

                ];
            } else if($group_count==2){
                $punch_ins_outs = group_array_index_map($attendance,'status');

                $data = [
                    'hrm_id'=>$att['hrm_id'],
                   // 'department'=>$department,
                    'shift'=>$att['name'],
                    'name'=>$att['first_name']. ' '.$att['last_name'],
                    'shift'=>$att['name'],
                    'employee_status'=>$att['employee_status'],
                    'doj'=>$att['hire_date'],
                    'dos'=>$att['termination_date'],
                    'attendance_date'=>$att['day'],

                ];

            $punch_in = $punch_ins_outs['in'][0];
            $punch_out = $punch_ins_outs['out'][0];

                   $subdata = [

                    'punchin_time'=>$punch_in['punchin_time'],
                    //'punchin_via'=>$punch_author->first_name.' '.$punch_author->last_name,
                    'punchin_via'=>$punch_in['state_type'],
                    'punchout_time'=>$punch_out['punchout_time'],
                    'punchout_via'=>$punch_out['state_type'],
                    'punchin_time_adjusted'=>'N/A',
                    'punchout_time_adjusted'=>'N/A',
                    'attendance_adjusted_by'=>'N/A',
                    'attendance_status'=>$punch_out['flag']

                ];

                $singleAttendance = array_merge($data,$subdata);
                break;

            } else {

                 $data = [
                    'hrm_id'=>$att['hrm_id'],
                   // 'department'=>$department,
                    'shift'=>$att['name'],
                    'name'=>$att['first_name']. ' '.$att['last_name'],
                    'shift'=>$att['name'],
                    'employee_status'=>$att['employee_status'],
                    'doj'=>$att['hire_date'],
                    'dos'=>$att['termination_date'],
                    'attendance_date'=>$att['day'],
                    'punchin_time_adjusted'=>'N/A',
                    'punchout_time_adjusted'=>'N/A',
                    'attendance_adjusted_by'=>'N/A'

                ];

                $punch_ins_outs = group_array_index_map($attendance,'status');

                    $subdata = [
                    'punchin_time'=>$punch_ins_outs['in'][0]['punchin_time'],
                    'punchin_via'=>$punch_ins_outs['in'][0]['state_type'],
                    'punchout_time'=>$punch_ins_outs['out'][0]['punchout_time'],
                    'punchout_via'=>$punch_ins_outs['out'][0]['state_type']
                    ];

                $in_count = count($punch_ins_outs['in']);
                $out_count = count($punch_ins_outs['out']);

                if($in_count > 1){
                    $subdata['punchin_time_adjusted'] = $punch_ins_outs['in'][$in_count - 1]['punchin_time'];
                }

        //         if($attendance[0]['group_no']==326567){
        //     dd($attendance);
        // }
                if($out_count > 1){
                    $employee = $employees->{$punch_ins_outs['out'][$out_count-1]['punch_author']};
                    $subdata['punchout_time_adjusted'] = $punch_ins_outs['out'][$out_count - 1]['punchout_time'];
                    $subdata['attendance_adjusted_by'] = $employee->first_name.' '.$employee->last_name;
                    $subdata['attendance_status'] = $punch_ins_outs['out'][$out_count - 1]['flag'];
                }

                $singleAttendance  = array_merge($data,$subdata);

                break;
            }
        }

        return $singleAttendance;
    }

    public function attendance_report()
    {
        if($this->input->method(TRUE)=='POST'){

            $month = $this->input->post('month');
            $department = explode('|',$this->input->post('department_id'));
            $department_id = $department[0];
            $this->load->model('report_model');
            $data = $this->report_model->attendance_report($month,$department_id);
            $employees = $this->report_model->department_employees($department_id);
            $employee_mapped = object_index_map($employees,'employee_id');
            $groups = group_array_index_map($data,'group_no');
            $attendance = [];
            foreach($groups as $group){

                $attendance[] = $this->generateAttendanceRow($group,$employee_mapped);
            }
            $data['department_name'] = $department[1];
            $data['department_id'] = $department_id;
            $data['month'] = $month;
            $data['employees_attendance'] = group_array_index_map($attendance,'hrm_id');
        }
        $data['title'] = display('attendance_report') . ' - ' . preg_replace('#[^\d]#is', '', $this->input->get('year'));
        $data['module'] = 'reports';
        $data['page'] = "leave_reports/attendance_report";
        $data['dropdowns'] = $this->leaves->dropdowns();
        echo Modules::run('template/layout', $data);
    }
}
