<?php
class Employee extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'employees_model' => 'employee',
            'attrition_model',
            'credentials_model',
        ]);
    }
    public function report()
    {
        $this->permission->method('employee_report', 'read')->redirect();
        $data['title'] = display('employee_report');
        $data['module'] = 'reports';
        $data['page'] = "employee_report/employee";
        $data['dropdowns'] = $this->employee->dropdowns();

        if ($this->input->get('column') ||
            $this->input->get('employee') ||
            $this->input->get('department_id') ||
            $this->input->get('supervisor_id')) {
            $data['rows'] = $this->leaves->leave_report(
                $this->input->get('column'),
                $this->input->get('employee'),
                $this->input->get('department_id'),
                $this->input->get('supervisor_id'),
            );
        }
        echo Modules::run('template/layout', $data);
    }
    public function create_thumbnail_employees(){
        die('generate blulk employee thumbnails...');
        $employees  = $this->db->select('employee_id,picture,hrm_id')->get('employee_history')->result();
        
        foreach ($employees as $employee) {
        $image_path =  $employee->picture;
        if(file_exists($image_path)) {
        $image_split = explode('/',$image_path);
        $image = array_pop($image_split);

        $file_info = pathinfo($image);
        //$thumbnail_path = $
        $thumbnail_path = implode('/',$image_split).'/thumb_'.$file_info['filename'].'.'.$file_info['extension'];
        $data = ['source_path'=>$image_path,'destination_path'=>$thumbnail_path,'width'=>50,'height'=>50];

        if(create_thumbnail($data)){
        echo '<p style="color:orange;">Thumbnail created for file:"'.$image_path.'". For employee:'.$employee->hrm_id.'</p>';
        $this->db->set('picture_thumbnail',$thumbnail_path)->where('employee_id',$employee->employee_id)->update(TBL_EMPLOYEE);
        echo '<p style="color:green;">Thumbnail updated for file:"'.$image_path.'". For employee:'.$employee->hrm_id.'</p>';
        } else {
            echo '<p style="color:red;">Thumbnail could not be generated for file:"'.$image_path.'". For employee:'.$employee->hrm_id.'</p>';
        }

        } else {
            echo '<p style="color:red;">File does not exist:"'.$image_path.'". For employee:'.$employee->hrm_id.'</p>';
        }
        }
    }

    public function attrition($year = null, $month = null)
    {
        $this->permission->method('attrition_report', 'read')->redirect();
        if ($_GET['year'] && $_GET['month']) {
            if ($_GET['action'] == 'download') {
                $this->attrition_model->download($_GET['year'], $_GET['month']);
            }
            redirect(sprintf('reports/employee/attrition/%s/%s', $_GET['year'], $_GET['month']));
        }
        if (!is_numeric($year) || !is_numeric($month)) {
            $year = null;
            // $month = null;
        }
        if (!$year) {
            $year = date('Y');
        }
        if(!$month=='ALL'){
        if (!$month) $month = date('m');
        }
        $data['title'] = display('attrition_report') . ' - ' . preg_replace('#[^\d]#is', '', $year);

        $data['year'] = $year;
        $data['month'] = $month;
        $data['years'] = range(date('Y'), $this->attrition_model->minimum_hire_year());
        $data['months'] = month_labels();

        $data['summary'] = $this->attrition_model->get_summary($year, $month);
        $data['details'] = $this->attrition_model->get_details($year, $month);

        $data['module'] = 'reports';
        $data['page'] = 'employee_report/attrition';
        echo Modules::run('template/layout', $data);
    }
    public function credentials()
    {
        $this->permission->method('credentials_report', 'read')->redirect();
        if ($this->input->post()) {
            $this->credentials_model->download($this->input->post('employees'));return;
        }
        $this->load->model('attendance/csv_model');
        $data['employees'] = $this->csv_model->Employeename();
        $data['title'] = display('credentials_report');
        $data['module'] = 'reports';
        $data['page'] = 'employee_report/credentials';
        echo Modules::run('template/layout', $data);
    }
}
