<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Documents extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('documents_model');
    }
    public function missing()
    {
        $this->permission->method('missing_documents', 'read')->redirect();
        if ($this->input->post()) {
            $this->getdatatable();
            return;
        }
        $data['title'] = display('missing_documents');
        $data['statuses'] = get_enum_values('employee_history', 'status');
        $data['divisions'] = $this->documents_model->divisions();
        $data['departments'] = $this->documents_model->departments();
        $data['module'] = "reports";
        $data['page'] = "employee_report/missing_documents";
        echo Modules::run('template/layout', $data);
    }
    private function getdatatable()
    {
        $search_arr = [];
        $search_columns = [
            'hrm_id',
            'full_name',
            'division',
            'department',
            'position',
            'title',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = $searchVal;
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = [];
        $out_arr["recordsTotal"] = $this->documents_model->countAllRows();
        $out_arr["recordsFiltered"] = $this->documents_model->countDatatable($this->input->post(), $search_arr);
        $rows = $this->documents_model->getDatatable($this->input->post(), $search_arr);

        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function broken()
    {
        $this->permission->method('broken_documents', 'read')->redirect();
        if (is_numeric($this->input->get('doc_type'))) {
            $type_rec = $this->documents_model->types($this->input->get('doc_type'));
            if (preg_match('#^picture.*#i', $type_rec->title) || preg_match('#^photo.*#i', $type_rec->title)) {
                $this->db->select('employee_history.picture');
            }
            if (!$this->permission->module('show_inactive_employees')->access() || $this->input->get('status') != 'all') {
                $this->db->where('employee_history.status', 'active');
            }
            $rows = $this->db->select([
                'employee_history.employee_id',
                'employee_history.hrm_id',
                'employee_history.first_name',
                'employee_history.last_name',
                'upload_documents_type.title as type',
                'upload_documents.id as document_id',
                'upload_documents.documents as file',
                'upload_documents.status as doc_status',
                'drive_ids.drive_id',
            ])
                ->where(['upload_documents_type.id' => $this->input->get('doc_type')])
                ->join('upload_documents', 'upload_documents_type.id = upload_documents.document_type AND employee_history.employee_id = upload_documents.employee_id', 'left')
                ->join('drive_ids', 'upload_documents.id = drive_ids.row_id AND drive_ids.table = \'upload_documents\'', 'left')
                ->get('employee_history, upload_documents_type')->result();
            $data = [];
            $pic_done = [];
            foreach ($rows as $row) {
                $emp_data = [
                    'id' => $row->document_id,
                    'hrm_id' => $row->hrm_id,
                    'name' => sprintf('%s %s', $row->first_name, $row->last_name),
                ];
                $dt = [];
                if (trim($row->picture) && !$pic_done[$row->employee_id]) {
                    $pic_done[$row->employee_id] = true;
                    $row->picture = ltrim($row->picture, './');
                    if (empty(trim($row->picture))) {
                        $dt = array_merge($emp_data, ['status' => display('missing')]);
                    } elseif (!file_exists(FCPATH . $row->picture)) {
                        $dt = array_merge($emp_data, ['status' => display('broken'), 'file' => base_url($row->picture)]);
                    }
                    $data[] = array_values($dt);
                }
                if ($row->doc_status && !in_array($row->doc_status, ['profile-upload', 'uploaded', 'approved'])) {
                    continue;
                }
                if (empty(trim($row->file))) {
                    if ($pic_done[$row->employee_id]) {
                        continue;
                    }
                    $dt = array_merge($emp_data, ['status' => display('missing')]);
                } elseif ($row->drive_id) {
                    $this->load->model('dashboard/setting_model');
                    $HRM_Drive = $this->setting_model->driveInstance;
                    if (!$HRM_Drive->get($row->drive_id)) {
                        $dt = array_merge($emp_data, ['status' => display('broken'), 'file' => base_url('employee/document/emp/' . $row->file)]);
                    }
                } elseif (!file_exists(FCPATH . 'assets/employee_documents/' . $row->file)) {
                    $dt = array_merge($emp_data, ['status' => display('broken'), 'file' => base_url('employee/document/emp/' . $row->file)]);
                }
                $data[] = array_values($dt);
            }
            $data = array_filter($data);
            $this->load->library('better_excel');
            return $this->better_excel->download(
                [
                    [display('id'), 8],
                    [display('hrm_id'), 10],
                    [display(['employee', 'name']), 30],
                    [display('status'), 9],
                    [display('link'), 120],
                ],
                $data,
                [],
                [],
                [],
                preg_replace('#\W+#', '-', $type_rec->title) . ' ' . display(['missing', 'report']) . ' ' . date('d-m-Y-H-i-s')
            );
        }
        $data['title'] = display('broken_documents');
        $data['module'] = "reports";
        $data['types'] = $this->documents_model->types();
        $data['status'] = [
            'active' => display(['Active', 'Only']),
            'all' => display(['all', 'employees']),
        ];
        $data['page'] = "employee_report/broken_documents";
        echo Modules::run('template/layout', $data);
    }
    public function type()
    {
        $this->permission->method('document_by_type', 'read')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'type[]',
                    'label' => 'Document Type',
                    'rules' => 'required',
                ),
                array(
                    'field' => 'status[]',
                    'label' => 'Employee Status',
                    'rules' => 'required',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                $zip = new ZipArchive();
                if ($zip->open($file = tempnam('tmp', 'zip'), ZIPARCHIVE::CREATE) != true) {
                    die("Could not open archive");
                }
                $types = $this->input->post('type');
                $is_confidential = [0];

                $roles_allowed = [ROLE_PAYROLL_SPECIALIST,ROLE_ADMIN_ACCESS_USER_ACCOUNT,ROLE_CFO];
                if(count(array_intersect($roles_allowed, $this->session->roles)) || $this->session->isAdmin){
                    $is_confidential[] = 1;
                }
                foreach ($types as $type) {
                    $type_rec = $this->documents_model->types($type);

                    $documents = $this->documents_model->getDocumentTypeReport(
                        $type,
                        $this->input->post('status'),
                        $this->input->post('division'),
                        $this->input->post('department'),
                        $is_confidential
                    );

                    foreach ($documents as $document) {
                        $file_name = "{$document->hrm_id} - $type_rec->title";
                        $file_ext = '.' . pathinfo($document->documents, PATHINFO_EXTENSION);
                        if ($zip->locateName($type_rec->title . '/' . $file_name . $file_ext)) {
                            $file_name .= ' - ' . str_replace('.', '', microtime(true) . '');
                        }
                        if ($document->drive_id) {
                            $this->load->model('dashboard/setting_model');
                            $HRM_Drive = $this->setting_model->driveInstance;
                            if ($file_body = $HRM_Drive->getBinary($document->drive_id)) {
                                $zip->addFromString(
                                    $type_rec->title . '/' . $file_name . $file_ext,
                                    $file_body
                                );
                            }
                        } else {
                            $zip->addFile(
                                FCPATH . 'assets/employee_documents/' . $document->documents,
                                $type_rec->title . '/' . $file_name . $file_ext
                            );
                        }
                    }
                }
                $zip->close();
                header('Content-Type: application/zip');
                header('Content-Length: ' . filesize($file));
                header('Content-Disposition: attachment; filename="document-bulk-download-' . formatted_date_now() . '.zip"');
                readfile($file);
                @unlink($file);exit;
            }
        }
        $data['title'] = display('document_by_type');
        $data['statuses'] = get_enum_values('employee_history', 'status');
        $data['types'] = $this->documents_model->types();
        $data['divisions'] = $this->documents_model->divisions();
        $data['departments'] = $this->documents_model->departments();
        $data['module'] = "reports";
        $data['page'] = "documents/type";
        echo Modules::run('template/layout', $data);
    }
}
