<div class="container-fluid">
    <div class="row">
        <!--  table area -->
        <div class="col-sm-12">
            <div class="panel panel-default thumbnail">
                <div class="panel-body">
                    <table width="100%" class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th><?= display('can_id') ?></th>
                                <th>Category</th>
                                <th><?= display('name') ?></th>
                                <th><?= display('email') ?></th>
                                <th><?= display('phone') ?></th>
                                <th class="hideexport"><?= display('action') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($rows as $que) : ?>
                            <tr>
                                <td><?= $que->can_id; ?></td>
                                <td><?= $que->position; ?></td>
                                <td><?= $que->first_name.' '.$que->last_name; ?></td>
                                <td><?= $que->email; ?></td>
                                <td><?= $que->phone; ?></td>
                                <td class="center">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Action <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li><a href="#" class="btn-view-profile" data-id="<?=$que->can_id?>">View Profile</a></li>
                                            <li><a href="<?=base_url('recruitment/candidate/documents/' . $que->can_id . '/resume')?>" download>Download Resume</a></li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function () {
        $('table.table').dataTable($.extend({}, window.default_datatable_opts, {
            "order": [[ 0, "desc" ]]
        }))
        $('table.table').on('click', '.btn-view-profile', function(e){
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/job_posting/get_profile",
                data: {
                    'can_id': $(this).data('id')
                },
                success: function (res) {
                    if(res.success){
                        $('#model-profile').find('.modal-body').html(res.success)
                        $('#model-profile').modal('show')
                    }else{
                        alert(res.error)
                    }
                }
            });
        });
        
        $('table.table').on('click', '.btn-interview-history', function (e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/candidate_select/interview_history",
                data: {
                    'can_id': $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        $('#model-interview-history').find('.modal-body').html(res.success)
                        $('#model-interview-history').modal('show')
                    } else {
                        alert(res.error)
                    }
                }
            });
        });
    });
</script>
<div class="modal fade" id="model-profile" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Candidate Information</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="model-interview-history" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Interview History</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>