<html lang="en">
<head>
    <link href="<?php echo base_url('assets/css/bootstrap.min.css') ?>" rel="stylesheet" type="text/css"/>
    <style>
        table, tr, td, th {
            border: none !important;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!--  table area -->
            <div class="col-sm-12">
                <div class="panel panel-default thumbnail">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h2><?=$job->position;?></h2>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <?=implode(', ', $job->cities)?>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <h3>Job Description</h3>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12" style="margin-left: 15px;">
                                <p><?=$job->jp_title_description;?></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <h3>Job Skill</h3>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <?php foreach ($job->skills as $location) {?>
                                    <span
                                        style='margin-bottom: 10px;background: #<?= $location['jps_must_or_nice'] == 'must' ? 'ff6c6c' : 'eeeeee' ?>;padding: 6px 12px;border-radius: 0px;color: #424242;font-weight: 400;'><?=$location['jps_name'];?></span>
                                    <?php }?>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <h3>Work From Home</h3>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <?php foreach ($job->job_wfh as $location) {?>
                                    <span
                                        style='margin-bottom: 10px;background: #<?= $location['jpw_must_or_nice'] == 'must' ? 'ff6c6c' : 'eeeeee' ?>;padding: 6px 12px;border-radius: 0px;color: #424242;font-weight: 400;'><?=$location['jpw_name'];?></span>
                                    <?php }?>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <h3>Job Details</h3>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <table class="table table-bordered table-hover">
                                    <tbody>
                                        <tr>
                                            <th>Total Positions:</th>
                                            <td><?=$job->jp_career_position;?></td>
                                        </tr>
                                        <tr>
                                            <th>Job Type:</th>
                                            <td><?=$job->jp_employment_type;?></td>
                                        </tr>
                                        <tr>
                                            <th>Gender:</th>
                                            <td><?=$job->jp_preference;?></td>
                                        </tr>
                                        <tr>
                                            <th>Minimum Education:</th>
                                            <td><?=$job->jp_qualification_level;?>&nbsp;<?=$job->jp_qualification_must != 'exactly' ?$job->jp_qualification_must:null?></td>
                                        </tr>
                                        <tr>
                                            <th>Career Level:</th>
                                            <td><?=$job->jp_career_level;?></td>
                                        </tr>
                                        <tr>
                                            <th>Experience:</th>
                                            <td><?=$job->jp_experience_min;?> - <?=$job->jp_experience_max;?></td>
                                        </tr>
                                        <tr>
                                            <th>Salary:</th>
                                            <td><?=$job->jp_salary_min;?> - <?=$job->jp_salary_max;?></td>
                                        </tr>
                                        <tr>
                                            <th>Benefit:</th>
                                            <td><?=str_replace(',', ', ', $job->jp_benefits)?></td>
                                        </tr>
                                        <tr>
                                            <th>Posting Date:</th>
                                            <td><?=formatted_date($job->jp_posted_on)?></td>
                                        </tr>
                                        <tr>
                                            <th>Due Date:</th>
                                            <td><?=formatted_date($job->jp_due_date)?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>