<style>
    .sortable {
        list-style-type: none;
        margin: 0;
        padding: 0;
    }

    .sortable li {
        margin: 0 5px 5px 5px;
        padding: 5px;
        font-size: 1.2em;
        height: 1.5em;
    }

    html>body .sortable li {
        height: 2em;
        line-height: 1.2em;
    }

    .ui-state-highlight {
        height: 1.5em;
        line-height: 1.2em;
    }
</style>
<div class="form-group text-right">
    <?php if ($this->permission->method('requisition_options', 'create')->access()): ?>
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#model-opt-add">
    <i class="fa fa-plus-circle" aria-hidden="true"></i> Add Option
</button>
    <?php endif;?>
</div>
<div class="container-fluid">
    <div class="row">
        <ul class="nav nav-tabs">
            <?php $first_opt = reset($options);foreach ($options as $key => $value): ?>
            <li data-toggle="tab" data-target="#<?=$key?>" class="<?=$first_opt == $value ? 'active' : null?>"><a
                    href="#"><?=ucwords(str_replace(['_', '-'], ' ', $key))?></a></li>
            <?php endforeach?>
        </ul>

        <div class="tab-content">
            <?php $first_opt = reset($options);foreach ($options as $key => $value): ?>
            <div class="tab-pane fade <?=$first_opt == $value ? 'in active' : null?>" id="<?=$key?>">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <div class="text-right">
                        <?php if ($this->permission->method('requisition_options', 'update')->access()): ?>
                            <a class="btn btn-primary" data-toggle="modal" href='#modal-sort-<?=$key?>'><i class="fa fa-sort-alpha-asc" aria-hidden="true"></i> Sort Values</a>
                        <?php endif?>
                        </div>
                        <br>
                        <table class="datatable table table-hover">
                            <thead>
                                <tr>
                                    <th>Order</th>
                                    <th>Option</th>
                                    <?php if ($this->permission->method('requisition_options', 'update')->access() || $this->permission->method('requisition_options', 'delete')->access()): ?>
                                        <th class="hideexport">Action</th>
                                    <?php endif;?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($value as $row): ?>
                                <tr>
                                    <td><?=$row['sort_order']?></td>
                                    <td><?=$row['value']?></td>
                                    <?php if ($this->permission->method('requisition_options', 'update')->access() || $this->permission->method('requisition_options', 'delete')->access()): ?>
                                    <td>
                                        <?php if ($this->permission->method('requisition_options', 'update')->access()): ?>
                                        <a class="btn btn-primary btn-sm btn-edit" data-id="<?=$row['id']?>" href="#" role="button"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                        <?php endif ?>
                                        <?php if ($this->permission->method('requisition_options', 'delete')->access()): ?>
                                        <a class="btn btn-danger btn-sm btn-delete" href="#" data-id="<?= $row['id'] ?>" role="button"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        <?php endif?>
                                    </td>
                                    <?php endif?>
                                </tr>
                                <?php endforeach;?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php endforeach?>
        </div>
    </div>
</div>
<script>
  $( function() {
    $("select.dont-select-me").selectize({
        plugins: ["remove_button"]
    });
    $( ".sortable" ).sortable({
      placeholder: "ui-state-highlight"
    });
    $( ".sortable" ).disableSelection();
    $('table.table').on('click', '.btn-delete', function(e) {
        e.preventDefault();
        $btn = $(this)
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $('.se-pre-con').show()
                location.href = "<?= base_url("recruitment/Requisition/delete_option/") ?>" + $btn.data('id')
            }
        })
    })
    $('.modal').on('click', '.btn-save-order', function(){
        var $sortable = $(this).closest('.modal').find('ul.sortable');
        $.ajax({
            type: "POST",
            url: "<?= base_url('recruitment/Requisition/sort') ?>",
            data: {
                'order': $sortable.sortable( "toArray", {attribute: 'data-id'})
            },
            success: function (res) {
                if(res.success){
                    location.reload()
                }else{
                    alert(res.error);
                }
            }
        });
    })
    $('.tab-content').on('click', '.btn-edit', function (e) {
        e.preventDefault();
        $.ajax({
            type: "POST",
            url: "<?= base_url('recruitment/Requisition/get_option') ?>",
            data: {
                id: $(this).data('id')
            },
            success: function (res) {
                if(res.success){
                    var $modal = $('#model-opt-update');
                    $modal.find('[name=id]').val(res.success.id)
                    $modal.find('[name=type]')[0].selectize.setValue(res.success.type)
                    $modal.find('[name=value]').val(res.success.value)
                    $modal.find('[name=sort_order]').val(res.success.sort_order)
                    $modal.modal('show');
                }else{
                    alert(res.error)
                }
            }
        });
    });
  });
</script>
<div class="modal fade" id="model-opt-add" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="<?= base_url('recruitment/Requisition/save_option') ?>" method="post">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Option</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                      <label for="opttype">Type</label>
                      <select class="form-control dont-select-me" name="type" id="opttype" style="width: 100%;" required>
                        <option value="">Select Type</option>
                        <?php $first_opt = reset($options);foreach ($options as $key => $value): ?>
                            <option value="<?= $key ?>"><?= ucwords(str_replace(['_', '-'], ' ', $key)) ?></option>
                        <?php endforeach?>
                      </select>
                    </div>
                    <div class="form-group">
                      <label for="optval">Option Value</label>
                      <input type="text" class="form-control" name="value" id="optval" placeholder="Enter option value" required>
                    </div>
                    <div class="form-group">
                      <label for="optsort">Order</label>
                      <input type="number" class="form-control" name="sort_order" min="0" value="0" id="optsort" placeholder="Optional sort order">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="model-opt-update" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" data-backdrop="static" data-keyboard="false" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="<?= base_url('recruitment/Requisition/save_option') ?>" method="post">
                <input type="hidden" name="id" value="">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Option</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                      <label for="opttype">Type</label>
                      <select class="form-control dont-select-me" name="type" id="opttype" style="width: 100%;" required>
                        <option value="">Select Type</option>
                        <?php $first_opt = reset($options);foreach ($options as $key => $value): ?>
                            <option value="<?= $key ?>"><?= ucwords(str_replace(['_', '-'], ' ', $key)) ?></option>
                        <?php endforeach?>
                      </select>
                    </div>
                    <div class="form-group">
                      <label for="optval">Option Value</label>
                      <input type="text" class="form-control" name="value" id="optval" placeholder="Enter option value" required>
                    </div>
                    <div class="form-group">
                      <label for="optsort">Order</label>
                      <input type="number" class="form-control" name="sort_order" min="0" value="0" id="optsort" placeholder="Optional sort order">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php foreach ($options as $key => $value): ?>
<div class="modal fade" id="modal-sort-<?=$key?>" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">Sort <?=ucwords(str_replace(['_', '-'], ' ', $key))?></h4>
            </div>
            <div class="modal-body text-center">
                <ul class="sortable">
                    <?php foreach ($value as $row): ?>
                        <li class="ui-state-default" data-id="<?= $row['id'] ?>"><?= $row['value'] ?></li>
                    <?php endforeach?>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary btn-save-order">Save changes</button>
            </div>
        </div>
    </div>
</div>
<?php endforeach?>