<style>
    .table .dropdown-menu {
        left: -110px
    }
</style>
<div class="container-fluid">
    <div class="row">
        <!--  table area -->
        <div class="col-sm-12">
            <div class="panel panel-default thumbnail">
                <div class="panel-body">
                    <table width="100%" class="table table-striped table-bordered table-hover table-main-applications">
                        <thead>
                            <tr>
                                <th><?= display('hrm_id') ?></th>
                                <th><?= display('name') ?></th>
                                <th><?= display('date_of_joining') ?></th>
                                <th><?= display('job_title') ?></th>
                                <th><?= display('orientation') ?></th>
                                <th><?= display('updated_at') ?></th>
                                <th class="hideexport"><?= display('action') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function () {
        window.dtable = $('table.table-main-applications').DataTable($.extend({}, window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                beforeSend: function(){}
            },
            columns: [
                {
                    'data': 'hrm_id',
                },
                {
                    'data': 'full_name',
                },
                {
                    'data': 'hire_date',
                }, 
                {
                    'data': 'position_name',
                },
                {
                    'data': 'orientation',
                },
                {
                    'data': 'updated_at',
                },
                {
                    'data': 'action',
                    'sortable': false
                },
            ],
            "columnDefs": [ {
                "targets": [5],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        console.log(moment(data, 'DD-MM-YYYY hh:mm:ss A'));
                        return moment(data, 'DD-MM-YYYY hh:mm:ss A')
                    }
                    return data;
                }
            },
            {
                "targets": [3],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }
            }],
            "order": [[ 5, "desc" ]]
        }))
    });
    $(function () {
        $('table.table-main-applications').on('click', '.btn-view-profile', function (e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/job_posting/get_profile",
                data: {
                    'can_id': $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        $('#model-profile').find('.modal-body').html(res.success)
                        $('#model-profile').modal('show')
                    } else {
                        alert(res.error)
                    }
                }
            });
        });
        $('table.table-main-applications').on('click', '.btn-interview-history', function (e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/candidate_select/interview_history",
                data: {
                    'can_id': $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        $('#model-interview-history').find('.modal-body').html(res.success)
                        $('#model-interview-history').modal('show')
                    } else {
                        alert(res.error)
                    }
                }
            });
        });
        $('table.table-main-applications').on('click', '.btn-orientation-done', function (e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/hired/orientation_done",
                data: {
                    'id': $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        $('#model-orientation').find('#html-body').html(res.success)
                        $('#model-orientation').modal('show')
                        $('#model-orientation select').selectize({
                            plugins: ["remove_button"]
                        })
                    } else {
                        alert(res.error)
                    }
                }
            });
        });
        $('table.table-main-applications').on('click', '.btn-get-credentials', function (e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/hired/get_credentials",
                data: {
                    'employee_id': $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        $('#model-credentials').find('.modal-body').html(res.success)
                        $('#model-credentials').modal('show')
                    } else {
                        alert(res.error)
                    }
                }
            });
        });
        $('table.table-main-applications').on('click', '.btn-print-credentials', function (e) {
            e.preventDefault();
            $('body').append(`<iframe src="<?= base_url('recruitment/hired/print_credentials/') ?>${$(this).data('id')}" frameborder="0" style="display:none"></iframe>`)
        });
        $('#model-orientation form').on('submit', function(e) {
            e.preventDefault();
            $form = $(this)
            $modal = $('#model-orientation')
            myajax({
                url: '<?= base_url('recruitment/hired/hire') ?>',
                type: 'POST',
                data: $(this).serialize(),
                beforeSend: function() {
                    $form.find('div.error').remove()
                    $form.find('.has_error').removeClass('has_error')
                },
                success: function(res){
                    if(res.success) {
                        $modal.modal('hide')
                        alert(res.success)
                        window.dtable.ajax.reload()
                    }else if(res.errors) {
                        res.errors.forEach(err => {
                            let el = $form.find(`[name=${err[0]}]`)
                            el.closest('div.form-group').addClass('has_error')
                            el.closest('div.form-group').append(`<div class="error">${err[1]}</div>`)
                        });
                    } else if (res.error) {
                        alert(res.error)
                    } else {
                        alert('Unknown server response, contact administrator')
                        console.log(res);
                    }
                }
            })
        })
    });
</script>
<div class="modal fade" id="model-profile" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Candidate Information</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="model-interview-history" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Interview History</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="model-orientation" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Orientation Completed</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="container-fluid">
                    <form class="form-horizontal">
                        <div id="html-body"></div>
                        <hr>
                        <div class="form-group">
                            <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-success pull-right">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="model-credentials" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Candidate Credentials</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>