<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Job_model extends CI_Model
{
    public function setting()
    {
        return get_settings();
    }
    public function viewShortlist()
    {
        return $this->db->select('count(DISTINCT(stl.can_short_id)) as can_short_id,stl.*,bi.can_id,bi.first_name,bi.last_name,po.position_name')
            ->from('candidate_shortlist stl')
            ->join('candidate_basic_info bi', 'stl.can_id = bi.can_id', 'left')
            ->join('position po', 'stl.job_adv_id = po.pos_id', 'left')
            ->group_by('stl.can_short_id')
            ->order_by('stl.can_short_id', 'desc')
            ->get()
            ->result();
    }
    public function shortlist_create($data = array())
    {
        $this->db->trans_start();
        $this->db->insert('candidate_shortlist', $data);
        $this->db->where('can_id', $data['can_id'])->update('candidate_basic_info', [
            'status' => 'shortlisted',
            'updated_at' => current_date(true)
        ]);
        $this->db->trans_complete();
        if($this->db->trans_status()){
            $this->activity->set_job($data['job_adv_id'])->set_candidate($data['can_id'])->log('candidate_shortlisted');
        }
        return $this->db->trans_status();
    }
    public function rejection_create($data = array())
    {
        $this->db->trans_start();
        $this->db->insert('candidate_rejection', $data);
        $this->db->where('can_id', $data['can_id'])->update('candidate_basic_info', [
            'status' => 'rejected',
            'updated_at' => current_date(true)
        ]);
        $this->db->trans_complete();
        if($this->db->trans_status()){
            $this->template_mail->send($data['job_id'], 'candidate_rejection', null, [], [], $data['can_id'], null, [
                'rejection' => [
                    'reason' => $data['remarks']
                ]
            ]);
            $this->activity->set_job($data['job_id'])->set_candidate($data['can_id'])->log('candidate_rejected');
        }
        return $this->db->trans_status();
    }
    public function update_shortlist($data = array())
    {
        return $this->db->where('can_short_id', $data["can_short_id"])
            ->update("candidate_shortlist", $data);
    }
    public function shortlist_updateForm($id)
    {
        $this->db->where('can_short_id', $id);
        $query = $this->db->get('candidate_shortlist');
        return $query->row();
    }
    public function delete_shorlist($id = null)
    {
        $this->db->trans_start();
        $rec = $this->db->where('can_short_id', $id)->get('candidate_shortlist')->row();
        $this->db->where('can_short_id', $id)->delete('candidate_shortlist');
        $this->db->where('can_id', $rec->can_id)->update('candidate_basic_info', [
            'status' => null,
            'updated_at' => current_date(true)
        ]);
        $this->db->trans_complete();
        if($this->db->trans_status()){
            $this->activity->set_job($rec->job_adv_id)->set_candidate($rec->can_id)->log('candidate_unshortlisted');
        }
        return $this->db->trans_status();
    }
    public function delete_rejectlist($id = null)
    {
        $this->db->trans_start();
        $rec = $this->db->where('id', $id)->get('candidate_rejection')->row();
        $this->db->where('id', $id)->delete('candidate_rejection');
        $this->db->where('can_id', $rec->can_id)->update('candidate_basic_info', [
            'status' => null,
            'updated_at' => current_date(true)
        ]);
        $this->db->trans_complete();
        if($this->db->trans_status()){
            $this->activity->set_job($rec->job_id)->set_candidate($rec->can_id)->log('candidate_unrejected');
        }
        return $this->db->trans_status();
    }
    public function dropdownPosition()
    {
        $this->db->select('*');
        $this->db->from('candidate_shortlist');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->job_adv_id] = $value->job_adv_id;
            }
        }
        return $list;
    }
    public function dropdown()
    {
        $this->db->select('*');
        $this->db->from('position');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->pos_id] = $value->position_name;
            }
        }
        return $list;
    }
    public function dropdowncanid()
    {
        $this->db->select('*');
        $this->db->from('candidate_basic_info');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->can_id] = $value->first_name . "(" . $value->can_id . ")";
            }
        }
        return $list;
    }
/*##########################JobPosting Part ################*/
    public function viewJobPosting()
    {
        $mrArray = $this->db->select('sel.*,bi.position_name')
            ->from('job_posting sel')
            ->join('position bi', 'sel.pos_id = bi.pos_id')
            ->get()
            ->result();
        foreach ($mrArray as &$mr) {
            $mr->locations = $this->db->select('bi.*')
                ->from('job_posting_locations sel')
                ->join('city bi', 'sel.jpl_city_id = bi.ID')
                ->where('sel.jp_id', $mr->jp_id)
                ->get()
                ->result();
        }
        return $mrArray;
    }
    public function countAllRows()
    {
        $this->db->select('sel.*,bi.position_name')
        ->from('job_posting sel')
        ->join('position bi', 'sel.pos_id = bi.pos_id');
        return $this->db->count_all_results();

    }
    public function countDatatable($orWhere = [])
    {
        $this->db->select('sel.*,bi.position_name')
        ->from('job_posting sel')
        ->join('position bi', 'sel.pos_id = bi.pos_id')
        ->join('job_posting_locations jpl', 'sel.jp_id = jpl.jp_id')
        ->join('city','jpl.jpl_city_id=city.id');
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                 $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        return $this->db->count_all_results();
    }
    public function getDatatable($post = [], $orWhere = null)
    {
        $this->db->select('sel.*,bi.position_name,city.name locations')
            ->from('job_posting sel')
            ->join('position bi', 'sel.pos_id = bi.pos_id')
            ->join('job_posting_locations jpl', 'sel.jp_id = jpl.jp_id')
            ->join('city','jpl.jpl_city_id=city.id');
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                 $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        
        
        $mrArray = $this->db->get()->result_array();

            // foreach ($mrArray as &$mr) {
            //     $mr->locations = $this->db->select('bi.*')
            //         ->from('job_posting_locations sel')
            //         ->join('city bi', 'sel.jpl_city_id = bi.ID')
            //         ->where('sel.jp_id', $mr->jp_id)
            //         ->get()
            //         ->result();
            // }
        return $mrArray;
    }
    public function get_open_listings()
    {
        return getByWhere(
            'job_posting_locations,
            job_posting-job_posting_locations.jp_id=job_posting.jp_id-left,
            city-city.ID=job_posting_locations.jpl_city_id-left,
            position-position.pos_id=job_posting.pos_id-left',
            'job_posting.jp_posted_on,
            job_posting.jp_short_url,
            GROUP_CONCAT(DISTINCT city.Name SEPARATOR \', \') as cities,
            position.position_name as position',
            ['job_posting.requisition_status' => 'created',
                'date_add(job_posting.jp_due_date, interval 24*60*60 - 1 second) >= ' => date('Y-m-d H:i:s')],
            ['job_posting.jp_id'],
            [],
            'job_posting.jp_id',
            [],
            'job_posting.jp_id',
        );
    }
    public function count_open_listings()
    {
        return $this->db
        ->from('job_posting')
        ->where([
            'requisition_status' => 'created',
            'date_add(job_posting.jp_due_date, interval 24*60*60 - 1 second) >= ' => date('Y-m-d H:i:s'),
        ])->count_all_results();
    }
    public function specificJobPosting($id)
    {
        $mrArray = $this->db->select('sel.*,bi.position_name')
            ->from('job_posting sel')
            ->join('position bi', 'sel.pos_id = bi.pos_id')
            ->where('sel.jp_id', $id)
            ->where('sel.requisition_status', 'created')
            ->where('date_add(sel.jp_due_date, interval 24*60*60 - 1 second) >= ', date('Y-m-d H:i:s'))
            ->get()
            ->first_row();
        if ($mrArray) {
            $mrArray->locations = $this->db->select('bi.*')
                ->from('job_posting_locations sel')
                ->join('city bi', 'sel.jpl_city_id = bi.ID')
                ->where('sel.jp_id', $mrArray->jp_id)
                ->get()
                ->result();
            $mrArray->locations = $this->db->select('bi.*')
                ->from('job_posting_locations sel')
                ->join('city bi', 'sel.jpl_city_id = bi.ID')
                ->where('sel.jp_id', $mrArray->jp_id)
                ->get()
                ->result();
            $mrArray->skills = $this->db->select('si.*')
                ->from('job_posting_skills si')
                ->where('si.jp_id', $mrArray->jp_id)
                ->get()
                ->result();
            $array = array();
            foreach ($mrArray->skills as $row) {
                $array[] = $row->jps_name; // add each user id to the array
            }
            $mrArray->skills_list = $array;
        }
        return $mrArray;
    }
    public function specificJobPostingBySlug($slug)
    {
        $mrArray = $this->db->select('sel.*,bi.position_name')
            ->from('job_posting sel')
            ->join('position bi', 'sel.pos_id = bi.pos_id')
            ->where('sel.jp_short_url', $slug)
            ->where('sel.requisition_status', 'created')
            ->where('date_add(sel.jp_due_date, interval 24*60*60 - 1 second) >= ', date('Y-m-d H:i:s'))
            ->get()
            ->first_row();
        if ($mrArray) {
            $mrArray->locations = $this->db->select('bi.*')
                ->from('job_posting_locations sel')
                ->join('city bi', 'sel.jpl_city_id = bi.ID')
                ->where('sel.jp_id', $mrArray->jp_id)
                ->get()
                ->result();
            $mrArray->locations = $this->db->select('bi.*')
                ->from('job_posting_locations sel')
                ->join('city bi', 'sel.jpl_city_id = bi.ID')
                ->where('sel.jp_id', $mrArray->jp_id)
                ->get()
                ->result();
            $mrArray->skills = $this->db->select('si.*')
                ->from('job_posting_skills si')
                ->where('si.jp_id', $mrArray->jp_id)
                ->get()
                ->result();
            $mrArray->job_wfh = $this->db->select('si.*')
                ->from('job_posting_wfh si')
                ->where('si.jp_id', $mrArray->jp_id)
                ->get()
                ->result();
            $array = array();
            foreach ($mrArray->skills as $row) {
                $array[] = $row->jps_name; // add each user id to the array
            }
            $mrArray->skills_list = $array;
            $array = array();
            foreach ($mrArray->job_wfh as $row) {
                $array[] = $row->jpw_name; // add each user id to the array
            }
            $mrArray->job_wfh_list = $array;
        }
        return $mrArray;
    }
    public function interview_create($data = array())
    {return;
        return $this->db->insert('candidate_interview', $data);
    }
    public function delete_interview($id = null)
    {
        return;
        $this->db->where('can_int_id', $id)
            ->delete('candidate_interview');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_interview($data = array())
    {
        return $this->db->where('can_int_id', $data["can_int_id"])
            ->update("candidate_interview", $data);
    }
    public function interview_updateForm($id)
    {
        return $caninterviewInfo = $this->db->select('a.*,b.position_name')->from('candidate_interview a')->join('position b', 'a.job_adv_id=b.pos_id')->where('a.can_int_id', $id)->get()->row();
    }
    /* #################### Selection Part  #######################*/
    public function viewSelection()
    {return;
        return $this->db->select('count(DISTINCT(sel.can_sel_id)) as can_sel_id,sel.*,bi.can_id,bi.first_name,bi.last_name')
            ->from('candidate_selection sel')
            ->join('candidate_basic_info bi', 'sel.can_id = bi.can_id', 'left')
            ->group_by('sel.can_sel_id')
            ->order_by('sel.can_sel_id', 'desc')
            ->get()
            ->result();
    }
    public function selection_create($data = array())
    {
        return $this->db->insert('candidate_selection', $data);
    }
    public function selection_delete($id = null)
    {
        return;
        $this->db->where('can_sel_id', $id)
            ->delete('candidate_selection');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_selection($data = array())
    {
        return $this->db->where('can_sel_id', $data["can_sel_id"])
            ->update("candidate_selection", $data);
    }
    public function selection_updateForm($id)
    {
        $this->db->where('can_sel_id', $id);
        return $query = $this->db->select('a.*,b.position_name')->from('candidate_selection a')->join('position b', 'a.pos_id=b.pos_id')->where('a.can_sel_id', $id)->get()->row();
    }
    public function dropdowninterview()
    {
        $this->db->select('a.*,b.first_name,b.last_name');
        $this->db->from('candidate_shortlist a');
        $this->db->join('candidate_basic_info b', 'a.can_id=b.can_id');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->can_id] = $value->first_name . ' ' . $value->last_name;
            }
        }
        return $list;
    }
    public function dropdownselection()
    {
        $data = $this->db->select('a.*,b.first_name,b.last_name')->from('candidate_interview a')->join('candidate_basic_info b', 'a.can_id=b.can_id')->where('a.selection', 'ok')->get()->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->can_id] = $value->first_name . ' ' . $value->last_name;
            }
        }
        return $list;
    }
    /* selected dropdown position */
    public function selected()
    {
        $query = $this->db->get_where('candidate_interview', array('selection' => "ok"));
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->job_adv_id] = $value->job_adv_id;
            }
        }
        return $list;
    }
/*  ################ selected auto ######################  */
    public function insert_employee($data = array())
    {
        return;
        return $this->db->insert('employee_history', $data); //
    }
    public function Canlist()
    {
        $this->db->select("can_id,CONCAT_WS(' ',first_name,last_name) AS name");
        $this->db->from('candidate_basic_info');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->can_id] = $value->name;
            }
        }
        return $list;
    }
    public function headcode()
    {
        $query = $this->db->query("SELECT MAX(HeadCode) as HeadCode FROM acc_coa WHERE HeadLevel='2' And HeadCode LIKE '502020000%'");
        return $query->row();
    }
    public function create_coa($data = [])
    {
        $this->db->insert('acc_coa', $data);
        return true;
    }
    public function job_cities()
    {
        return array_column(getByWhere(
            'job_posting_locations,
            job_posting-job_posting_locations.jp_id=job_posting.jp_id-left,
            city-city.ID=job_posting_locations.jpl_city_id-left',
            'city.Name',
            ['job_posting.requisition_status' => 'created',
                'date_add(job_posting.jp_due_date, interval 24*60*60 - 1 second) >= ' => date('Y-m-d H:i:s')],
            ['city.Name', 'ASC'],
            0,
            0,
            [],
            'city.Name'
        ), 'Name');
    }
    public function cities()
    {
        $query = $this->db->query("SELECT city.* FROM city WHERE CountryCode='PAK' ");
        return $query->result();
    }
    public function getPositions($search)
    {
        if ($search == '') {
            $postions = $this->db->query("SELECT position.* FROM position ")->result();
        } else {
            $postions = $this->db->query("SELECT position.* FROM position where position_name LIKE '%" . $search . "%'")->result();
        }
        $response = array();
        foreach ($postions as $postion) {
            $response[] = array("value" => $postion->pos_id, "label" => ucfirst($postion->position_name));
        }
        return $response;
    }
    public function create_job($post_data, $params)
    {
        $this->db->trans_start();
        $this->db->insert('job_posting', $post_data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            foreach ($params['job_location'] as $location) {
                $this->db->insert('job_posting_locations', array('jpl_city_id' => $location, 'jp_id' => $insert_id));
            }
            foreach ($params['skills'] as $skill) {
                $this->db->insert('job_posting_skills', array('jps_name' => $skill, 'jps_must_or_nice' => $params['skill_must_or_nice'][preg_replace('@\W@', '_', $skill)], 'jp_id' => $insert_id));
            }
            foreach ($params['wfh_check'] as $wfh_item) {
                $this->db->insert('job_posting_wfh', array('jpw_name' => $wfh_item, 'jpw_must_or_nice' => $params['wfh_must_or_nice'][preg_replace('@\W@', '_', $wfh_item)], 'jp_id' => $insert_id));
            }
        }
        if(!$post_data['jp_is_draft']){
            $this->activity
            ->set_url('recruitment/Requisition/view/' . $insert_id)
            ->set_job($insert_id)
            ->log('requisition_inserted');
        }
        $this->db->trans_complete();
        return $this->db->trans_status() ? $insert_id : false;
    }
    public function save_job($post_data, $params)
    {
        $insert_id = null;
        $old_rec = null;
        $this->db->trans_start();
        if ($params['id']) {
            $old_rec = $this->db->where('jp_id', $params['id'])->get('job_posting')->row();
            $this->db->where('jp_id', $params['id']);
            $this->db->update('job_posting', $post_data);
            $this->db->delete('job_posting_locations', [
                'jp_id' => $params['id'],
            ]);
            $this->db->delete('job_posting_skills', [
                'jp_id' => $params['id'],
            ]);
            $this->db->delete('job_posting_wfh', [
                'jp_id' => $params['id'],
            ]);
            foreach ($params['job_location'] as $location) {
                $this->db->insert('job_posting_locations', array('jpl_city_id' => $location, 'jp_id' => $params['id']));
            }
            foreach ($params['skills'] as $skill) {
                $this->db->insert('job_posting_skills', array('jps_name' => $skill, 'jps_must_or_nice' => $params['skill_must_or_nice'][preg_replace('@\W@', '_', $skill)], 'jp_id' => $params['id']));
            }
            foreach ($params['wfh_check'] as $wfh_item) {
                $this->db->insert('job_posting_wfh', array('jpw_name' => $wfh_item, 'jpw_must_or_nice' => $params['wfh_must_or_nice'][preg_replace('@\W@', '_', $wfh_item)], 'jp_id' => $params['id']));
            }
        } else {
            $this->db->insert('job_posting', $post_data);
            $insert_id = $this->db->insert_id();
            if ($insert_id) {
                foreach ($params['job_location'] as $location) {
                    $this->db->insert('job_posting_locations', array('jpl_city_id' => $location, 'jp_id' => $insert_id));
                }
                foreach ($params['skills'] as $skill) {
                    $this->db->insert('job_posting_skills', array('jps_name' => $skill, 'jps_must_or_nice' => $params['skill_must_or_nice'][$skill], 'jp_id' => $insert_id));
                }
                foreach ($params['wfh_check'] as $wfh_item) {
                    $this->db->insert('job_posting_wfh', array('jpw_name' => $wfh_item, 'jpw_must_or_nice' => $params['wfh_must_or_nice'][preg_replace('@\W@', '_', $wfh_item)], 'jp_id' => $insert_id));
                }
            }
        }
        if($params['id']){
            if(!$post_data['jp_is_draft']){
                $status = 'requisition_updated';
                if($old_rec->jp_is_draft){
                    $status = 'requisition_inserted';
                }
                $this->activity
                ->set_url('recruitment/Requisition/view/' . $params['id'])
                ->set_job($params['id'])
                ->log($status);
            }
        } else {
            $this->activity
            ->set_url('recruitment/Requisition/view/' . $insert_id)
            ->set_job($insert_id)
            ->log('requisition_inserted');
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function selectiveJobPosting($id)
    {
        $mr = $this->db->select('sel.*,bi.position_name')
            ->from('job_posting sel')
            ->join('position bi', 'sel.pos_id = bi.pos_id')
            ->where('sel.jp_id', $id)
            ->get()
            ->first_row();
        if ($mr) {
            $mr->locations = $this->db->select('ci.*')
                ->from('job_posting_locations ci')
                ->where('ci.jp_id', $mr->jp_id)
                ->get()
                ->result();
            $locations_array = array();
            foreach ($mr->locations as $row) {
                $locations_array[] = $row->jpl_city_id; // add each user id to the array
            }
            $mr->locations_list = $locations_array;
            $mr->skills = $this->db->select('si.*')
                ->from('job_posting_skills si')
                ->where('si.jp_id', $mr->jp_id)
                ->get()
                ->result();
            $array = array();
            foreach ($mr->skills as $row) {
                $array[] = $row->jps_name; // add each user id to the array
            }
            $mr->skills_list = $array;
        } else {
            $mr = array();
        }
        return $mr;
    }
    public function update_job($post_data, $params)
    {
        $this->db->where('job_posting.jp_id', $params['jp_id']);
        $data = $this->db->update('job_posting', $post_data);
        if ($data) {
            $this->db->where('job_posting_locations.jp_id', $params['jp_id']);
            $this->db->delete('job_posting_locations');
            foreach ($params['job_location'] as $location) {
                $this->db->insert('job_posting_locations', array('jpl_city_id' => $location, 'jp_id' => $params['jp_id']));
            }
            $this->db->where('job_posting_skills.jp_id', $params['jp_id']);
            $this->db->delete('job_posting_skills');
            foreach ($params['skills'] as $skill) {
                $this->db->insert('job_posting_skills', array('jps_name' => $skill, 'jps_must_or_nice' => $params['skill_must_or_nice'][$skill], 'jp_id' => $params['jp_id']));
            }
            return true;
        } else {
            return false;
        }
    }
    public function updateJobStatus($post_data, $jp_id)
    {
        return true;
        $this->db->where('job_posting.jp_id', $jp_id);
        $data = $this->db->update('job_posting', $post_data);
        if ($data) {
            return true;
        } else {
            return false;
        }
    }
    public function updateSitePublishStatus($post_data, $jp_id)
    {
        return true;
        $this->db->where('job_posting.jp_id', $jp_id);
        $data = $this->db->update('job_posting', $post_data);
        if ($data) {
            return true;
        } else {
            return false;
        }
    }
    public function deleteJobPosting($jp_id)
    {
        $this->activity->set_job($jp_id)->log('job_deleted');
        $this->db->where('job_posting.jp_id', $jp_id);
        $data = $this->db->delete('job_posting');
        if ($data) {
            return true;
        } else {
            return false;
        }
    }
    public function generateShortURlCode($unique_ref_length = 7)
    {
        $possible_chars = "abcdefghijklmnopqrstuvwxyz1234567890";
        $unique_ref = "";
        $query = null;
        do {
            $unique_ref = "";
            $i = 0;
            while ($i < $unique_ref_length) {
                $char = substr($possible_chars, mt_rand(0, strlen($possible_chars) - 1), 1);
                $unique_ref .= $char;
                $i++;
            }
            $query = $this->db->get_where('job_posting', array('jp_short_url' => $unique_ref));
        } while ($query->num_rows() > 0);
        return $unique_ref;
    }
    public function get_candidate_details($can_id)
    {
        $rec = $this->db->select('candidate_basic_info.*, referrer.full_name referer_name, referrer.hrm_id referer_id')
        ->from('candidate_basic_info')
        ->join('employee_details referrer', 'candidate_basic_info.referrer = referrer.employee_id', 'left')
        ->where('candidate_basic_info.can_id', $can_id)
        ->get()
        ->row();
        if ($rec->status == 'rejected') {
            $rec->rejection = getByWhere(
                'candidate_rejection,
                user-user.id=candidate_rejection.rejected_by-left,
                position-position.pos_id=candidate_rejection.future_pos_id-left',
                'candidate_rejection.*,
                CONCAT_WS(\' \', user.firstname, user.lastname) as username,
                position.position_name as future_position',
                ['candidate_rejection.can_id' => $rec->can_id]
            )[0];
        }
        return $rec;
    }
    public function get_candidates($job_id)
    {
        return getByWhere(
            'candidate_basic_info',
            'candidate_basic_info.*',
            [
                'candidate_basic_info.jp_id' => $job_id,
            ],
            ['candidate_basic_info.applied_on', 'ASC']
        );
    }
    public function get_pending_candidate($job_id)
    {
        return getByWhere(
            'candidate_basic_info',
            'candidate_basic_info.*',
            [
                'candidate_basic_info.jp_id' => $job_id,
                'candidate_basic_info.status' => null,
            ],
            ['candidate_basic_info.applied_on', 'ASC']
        );
    }
    public function get_shortlisted_candidates($job_id)
    {
        return $this->db->query("SELECT
        `candidate_basic_info`.*,
        `candidate_shortlist`.`can_short_id`,
        `candidate_shortlist`.`date_of_shortlist`,
        `candidate_shortlist`.`interview_date`
      FROM `candidate_basic_info`
        LEFT JOIN `candidate_shortlist`
          ON `candidate_basic_info`.`can_id` = `candidate_shortlist`.`can_id`
        LEFT JOIN `candidate_rejection`
          ON `candidate_rejection`.`can_id` = `candidate_basic_info`.`can_id`
      WHERE (`candidate_basic_info`.`jp_id` = ?
      AND `candidate_basic_info`.`status` IS NOT NULL
      AND `candidate_rejection`.`rejected_on` IS NULL
      AND can_short_id IN (SELECT
          MAX(can_short_id)
        FROM candidate_shortlist
        GROUP BY can_id))
      ORDER BY `candidate_shortlist`.`date_of_shortlist` ASC", [$job_id])->result();
    }
    public function get_rejected_candidates($job_id)
    {
        return getByWhere(
            'candidate_basic_info,
			candidate_rejection-candidate_rejection.can_id=candidate_basic_info.can_id-left',
            'candidate_basic_info.*,
			candidate_rejection.*,
            candidate_rejection.id as rej_id',
            [
                'candidate_basic_info.status' => 'rejected',
                'candidate_basic_info.jp_id' => $job_id,
                'candidate_rejection.rejected_on !=' => null,
            ],
            ['candidate_rejection.rejected_on', 'ASC']
        );
    }
    public function get($id)
    {
        return $this->db->select('jp.jp_id id, position.position_name as title, requisition_status as status')
        ->join('position', 'jp.pos_id = position.pos_id', 'left')
        ->where('jp.jp_id', $id)
        ->get('job_posting jp')
        ->row();
    }
    public function toggle_referral($id, $state)
    {
        $job = $this->get($id);
        if(!$job) {
            return false;
        }
        $this->db->trans_start();
        $this->db->where('jp_id', $id)->update('job_posting', [
            'has_referrer' => $state ? 1 : 0
        ]);
        $this->activity->set_job($id)->log(['job_referrer_state', $state ? display('enabled') : display('disabled')]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function job_appliers_list($slug)
    {
        return $this->db->select('candidate_basic_info.*,position.*')
            ->from('candidate_basic_info')
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id')
            ->join('position', 'job_posting.pos_id = position.pos_id')
            ->where('job_posting.jp_short_url',$slug)->get()->result();
    }
    public function get_candidate_info($can_id)
    {
        return $this->db->select('candidate_basic_info.*,position.*,candidate_education_info.*,candidate_employment_history.*')
            ->from('candidate_basic_info')
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id')
            ->join('candidate_education_info', 'candidate_education_info.can_id = candidate_basic_info.can_id')
            ->join('candidate_employment_history', 'candidate_employment_history.can_id = candidate_basic_info.can_id')
            ->join('position', 'job_posting.pos_id = position.pos_id')
            ->where('candidate_basic_info.can_id',$can_id)->get()->row();
    }
}
