<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Hired_model extends CI_Model
{
    private $_active_creds = [];
    public function countAllRows()
    {
        return $this->db->where('status', 'completed')->count_all_results('candidate_basic_info');
    }
    public function countDatatable($orWhere = [])
    {
        $this->db->select(
            'candidate_basic_info.*, CONCAT_WS(\' \', candidate_basic_info.first_name, candidate_basic_info.last_name) as full_name,
            position.*, employee_history.hrm_id, employee_history.hire_date'
        )
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id', 'left')
            ->join('position', 'job_posting.pos_id = position.pos_id', 'left')
            ->join('employee_history', 'candidate_basic_info.employee_id = employee_history.employee_id', 'left')
            ->where('candidate_basic_info.status =', 'completed');
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        return $this->db->count_all_results('candidate_basic_info');
    }
    public function getDatatable($post = [], $orWhere = null)
    {
        $this->db->select(
            'candidate_basic_info.*, CONCAT_WS(\' \', candidate_basic_info.first_name, candidate_basic_info.last_name) as full_name,
            position.*, employee_history.hrm_id, employee_history.hire_date'
        )
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id', 'left')
            ->join('position', 'job_posting.pos_id = position.pos_id', 'left')
            ->join('employee_history', 'candidate_basic_info.employee_id = employee_history.employee_id', 'left')
            ->where('candidate_basic_info.status =', 'completed');
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get('candidate_basic_info')
            ->result_array();
    }
    public function generate_credentials($post, $emp_rec)
    {
        $other_portals = false;
        foreach ($post['credentials'] as $cred_key => $cred_values) {
            if ($cred_key == 'hrm') {
                continue;
            }
            if ($cred_values['create'] == 'yes') {
                $other_portals = true;
                break;
            }
        }
        $email = null;
        if ($other_portals && (isset($post['pseudo']) || isset($post['name']))) {
            if (isset($post['pseudo'])) {
                $pseudo_exploded = explode(' ', $post['pseudo']);
                $emp_rec->first_name = $pseudo_exploded[0];
                $emp_rec->last_name = $pseudo_exploded[1];
            }
            $try = 0;
            $num = -1;
            $exists = true;
            $femail = $post['pseudo'] ?? $post['name'];
            if (empty(trim($femail))) {
                log_message('error', 'Empty username for MLM Portals: ' . json_encode($post));
                sendJson(['error' => 'Unable to create MLM username, try again']);
            }
            $email = null;
            do {
                $num++;
                if ($try > 100) {
                    log_message('error', 'User name checking tries greater than 30, quitting');
                    log_message('error', 'User name: ' . $email);
                    sendJson(['error' => 'Unable to create MLM username, try again']);
                    break;
                }
                $email = trim(preg_replace('~\W+~is', ' ', $femail));
                $email = str_replace(' ', '.', $email);
                if ($num > 0) {
                    $email .= $num;
                }
                $email = strtolower($email);
                foreach ($post['credentials'] as $cred_key => $cred_values) {
                    if ($cred_key == 'hrm') {
                        continue;
                    }
                    if ($cred_values['create'] == 'yes') {
                        $this->load->model('recruitment/Cred' . $cred_key . '_model');
                        $res = $this->{'Cred' . $cred_key . '_model'}->userExists($email, $try > 10);
                        if ($res === null) {
                            $try++;
                            break;
                        }
                        $exists = $res === true;
                        if ($exists) {
                            break;
                        }
                    }
                }
            } while ($exists);
        }
        $credentials = [];
        $this->_active_creds = $this->load->config('orientation_portals', true);
        $this->_active_creds = array_merge($this->_active_creds, $this->load->config('other_portals', true));
        foreach ($post['credentials'] as $cred_key => $cred_values) {
            if ($cred_values['create'] == 'yes') {
                $this->load->model('recruitment/Cred' . $cred_key . '_model');
                $credentials[$this->_active_creds[$cred_key]['label']] = $this->{'Cred' . $cred_key . '_model'}->addUser($email, $emp_rec, $cred_values['role']);
                $credentials[$this->_active_creds[$cred_key]['label']]['key'] = $cred_key;
            }
        }
        if ($other_portals && $email) {
            if (isset($post['pseudo'])) {
                $emp_rec2 = $this->db->select('pseudo, medflow_id')->where('employee_id', $emp_rec->employee_id)->get('employee_history')->row_array();
                $this->db->where('employee_id', $emp_rec->employee_id)->update('employee_history', [
                    'medflow_id' => $email,
                    'pseudo' => $post['pseudo'],
                ]);
                $this->load->model('employee/employees_model');
                $this->employees_model->log_employee_change($emp_rec->employee_id, [
                    'medflow_id' => $email,
                    'pseudo' => $post['pseudo'],
                ], $emp_rec2);
            } else {
                $emp_rec2 = $this->db->select('medflow_id')->where('employee_id', $emp_rec->employee_id)->get('employee_history')->row_array();
                $this->db->where('employee_id', $emp_rec->employee_id)->update('employee_history', [
                    'medflow_id' => $email,
                ]);
                $this->load->model('employee/employees_model');
                $this->employees_model->log_employee_change($emp_rec->employee_id, [
                    'medflow_id' => $email,
                ], $emp_rec2);
            }
        }
        return $credentials;
    }
    public function get_credentials($employee_id)
    {
        $data = $this->db->where('employee_id', $employee_id)->get('employee_credentials')->row();
        $emp_rec = decrypt_employee_data($this->db->select('division_id, domain_name, domain_password')->where('employee_id', $employee_id)->get('employee_history')->row());
        $data->credentials = json_decode($this->encryption->decrypt($data->credentials), true);
        if ($emp_rec && $emp_rec->domain_name && $emp_rec->domain_password) {
            $data->credentials['Domain ID'] = [
                'username' => $emp_rec->domain_name,
                'password' => $emp_rec->domain_password,
                'key' => 'domain',
            ];
        }
        foreach ($data->credentials as $key => $cred) {
            switch ($cred['key']) {
                case 'hrm':{
                        $rec = $this->db->select('url')->where('id', $emp_rec->division_id)->get('divisions');
                        if ($rec) {
                            $rec = $rec->row();
                            $data->credentials[$key]['url'] = $rec->url;
                        }
                        break;
                    }
                case 'mlmsp':
                case 'mlmpi':
                case 'mlmkhi':
                case 'mlmiwp':
                case 'mlmpharm':{
                        $data->credentials[$key]['url'] = $this->options->get_system('cred.url.' . $cred['key']);
                    }
            }
        }
        return $data;
    }
}
