<?php
defined('BASEPATH') or exit('No direct script access allowed');
use Curl\Curl;

class Credmlmkhi_model extends CI_Model
{
    private $_role_id_filter = [1];
    private $_creds = null;
    public function __construct()
    {
        parent::__construct();
        $this->_creds = $this->db->where('id', 'mlmkhi')->get('other_portals')->row_array();
        if (empty($this->_creds)) {
            log_message('error', 'No settings found for MLM KHI');
        }
    }
    public function getRoles()
    {
        if (!$data = $this->cache->get('Cred.mlmpi.Roles')) {
            try {
                $curl = new Curl();
                $curl->setHeader('ApiKey', $this->_creds['api_key']);
                $raw_data = $curl->get($this->_creds['url'] . '/GetRoles', [
                    'Server' => 'KHI',
                ]);
                if($curl->error) {
                    throw new Exception('HTTP Error: ' . $curl->errorCode . ': ' . $curl->errorMessage);
                }
                foreach ($raw_data as $raw_dt) {
                    if (in_array($raw_dt->ROLEID, $this->_role_id_filter)) {
                        continue;
                    }
                    $data[] = [
                        'id' => $raw_dt->ROLEID,
                        'name' => $raw_dt->ROLETITLE,
                    ];
                }
            } catch (Throwable $e) {
                log_message('error', 'KHI getRoles: ' . $e->getMessage());
                return [];
            }
            $this->cache->save('Cred.mlmpi.Roles', $data, 10800);
        }

        return $data;
    }
    public function getEmail($string)
    {
        return $string;
    }
    public function userExists($userId, $verbose = false)
    {
        $curl = new Curl();
        try {
            $curl->setHeader('ApiKey', $this->_creds['api_key']);
            $res = $curl->get($this->_creds['url'] . '/Users/isUserAlreadyExist?Server=KHI&User_ID=' . $userId);
            if($curl->error && !in_array($curl->errorCode, [200, 400])) {
                throw new Exception('HTTP Error: ' . $curl->errorCode . ': ' . $curl->errorMessage);
            }
            if($verbose) {
                log_message('error', 'KHI user check reply: ' . json_encode($res));
                log_message('error', 'KHI user check status: ' . $curl->getHttpStatusCode());
            }
        } catch (Throwable $e) {
            log_message('error', 'KHI UserExists' . $e->getMessage());
            return null;
        }
        switch ($curl->getHttpStatusCode()) {
            case 200:
                return true;
                break;
            case 400:
                return false;
                break;
            default:
                return null;
                break;
        }
    }
    public function addUser($username, $employee, $roles)
    {
        $this->load->helper('string');
        $generated_password = str_replace('I', 'L', strtoupper(random_string('alpha', 6)));

        try {
            $curl = new Curl();
            $curl->setHeader('ApiKey', $this->_creds['api_key']);
            $q = http_build_query([
                'fName' => $employee->first_name,
                'lName' => $employee->last_name,
                'Email' => $employee->email,
                'Password' => $generated_password,
                'RoleID' => $roles,
                'User_ID' => $username,
                'Employee_ID' => $employee->hrm_id,
                'Server' => 'KHI',
            ]);
            log_message('error', sprintf('KHI user create request: %s - role id: %s', $employee->hrm_id, $roles));
            $raw_data = $curl->post($this->_creds['url'] . '/Users/add?' . $q);

            if($curl->error && !in_array($curl->errorCode, [202])) {
                throw new Exception('HTTP Error: ' . $curl->errorCode . ': ' . $curl->errorMessage);
            }
            if ($curl->getHttpStatusCode() == 202 || (is_string($raw_data) && $raw_data == 'User Created SuccessFully')) {
                return [
                    'username' => $username,
                    'password' => $generated_password
                ];
            }
            log_message('error', 'Unknown reply from MLM KHI: ' . json_encode($raw_data));
            log_message('error', 'Unknown reply from MLM KHI status: ' . $curl->getHttpStatusCode());
        } catch (Throwable $e) {
            log_message('error', 'KHI AddUser: ' . $e->getMessage());
        }
        return [];
    }
    public function setStatus($medflow_id, $status)
    {
        $curl = new Curl();
        try {
            $curl->setHeader('ApiKey', $this->_creds['api_key']);
            $curl->post($this->_creds['url'] . '/Users/UpdateStatus?Server=KHI&User_ID=' . $medflow_id . '&Status=' . ($status ? 'Y' : 'N'));
            if($curl->error && !in_array($curl->errorCode, [202, 400])) {
                throw new Exception('HTTP Error: ' . $curl->errorCode . ': ' . $curl->errorMessage);
            }
        } catch (Throwable $e) {
            log_message('error', 'KHI setStatus: ' . $e->getMessage());
            return null;
        }
        switch ($curl->getHttpStatusCode()) {
            case 202:
                return true;
                break;
            case 400:
                return false;
                break;
            default:
                return null;
                break;
        }
    }
}
