<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Candidate extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'Candidate_model','Job_model',
        ));
        $this->load->library('excel');
    }
    public function documents($can_id, $file)
    {
        if(!in_array($file, ['resume'])) {
            return show_404();
        }
        $rec = $this->db->select([
            'candidate_basic_info.can_id',
            'candidate_basic_info.resume',
            'drive_ids.drive_id',
        ])
        ->from('candidate_basic_info')
        ->join('drive_ids', 'candidate_basic_info.can_id = drive_ids.row_id AND drive_ids.table = \'candidate_basic_info\'', 'left')
        ->where('can_id', $can_id)
        ->get()
        ->row();
        if($rec->drive_id) {
            $this->load->model('dashboard/setting_model');
            $HRM_Drive = &$this->setting_model->driveInstance;
            $HRM_Drive->stream($rec->drive_id);return;
        } elseif(file_exists(FCPATH . $rec->resume)) {
            $path = FCPATH . $rec->resume;
            header('Pragma: public'); // required
            header('Expires: 0'); // no cache
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s', filemtime($path)) . ' GMT');
            header('Cache-Control: private', false);
            header('Content-Type: ' . get_mime_by_extension($path)); // Add the mime type from Code igniter.
            //header('Content-Disposition: inline; filename="' . $file . '"'); // Add the file name
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($path)); // provide file size
            header('Connection: close');
            readfile($path); // push it out
            exit();
        }
        return show_404();
    }
    public function talentfile($id, $file)
    {
        if(!in_array($file, ['resume'])) {
            return show_404();
        }
        $rec = $this->db->select([
            'talent_network.id',
            'talent_network.resume',
            'drive_ids.drive_id',
        ])
        ->from('talent_network')
        ->join('drive_ids', 'talent_network.id = drive_ids.row_id AND drive_ids.table = \'talent_network\'', 'left')
        ->where('id', $id)
        ->get()
        ->row();
        if($rec->drive_id) {
            $this->load->model('dashboard/setting_model');
            $HRM_Drive = &$this->setting_model->driveInstance;
            $HRM_Drive->stream($rec->drive_id);return;
        } elseif(file_exists(FCPATH . $rec->resume)) {
            $path = FCPATH . $rec->resume;
            header('Pragma: public'); // required
            header('Expires: 0'); // no cache
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s', filemtime($path)) . ' GMT');
            header('Cache-Control: private', false);
            header('Content-Type: ' . get_mime_by_extension($path)); // Add the mime type from Code igniter.
            //header('Content-Disposition: inline; filename="' . $file . '"'); // Add the file name
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($path)); // provide file size
            header('Connection: close');
            readfile($path); // push it out
            exit();
        }
        return show_404();
    }
    public function talent_network()
    {
        $this->permission->module('talent_network', 'read')->redirect();
        $data['title'] = display('talent_network');
        $data['caninfo'] = $this->Candidate_model->viewcanInfoTalentNetwork();
        $data['module'] = "recruitment";
        $data['page'] = "talentNetwork";
        echo Modules::run('template/layout', $data);
    }
    public function candidateinfo_view()
    {
        $this->permission->module('can_basicinfo_list', 'read')->redirect();
        if ($this->input->post()) {
            return $this->getCandidateDataTable();
        }
        $data['title'] = display('candidate_list');
        $data['module'] = "recruitment";
        $data['page'] = "canInfoview";
        echo Modules::run('template/layout', $data);
    }
    private function getCandidateDataTable()
    {
        $search_columns = [
            'candidate_basic_info.can_id',
            'position.position_name',
            'CONCAT_WS(\' \', candidate_basic_info.first_name, candidate_basic_info.last_name)',
            'candidate_basic_info.email',
            'candidate_basic_info.phone',
            'candidate_basic_info.last_employer',
            'candidate_basic_info.total_years_of_experience',
        ];
        $search_arr = [];

        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = [];
        $out_arr["recordsTotal"] = $this->Candidate_model->countAllRows();
        $out_arr["recordsFiltered"] = $this->Candidate_model->countDatatable($search_arr);
        $rows = $this->Candidate_model->getDatatable($this->input->post(), $search_arr);
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'first_name':{
                            $tdData = $rec[$col['data']] . ' ' . $rec['last_name'];
                            break;
                        }
                    case 'action':{
                            $tdData = '';
                            if ($this->permission->method('job_posting', 'read')->access()) {
                                $tdData .= '<a class="btn btn-secondary btn-sm" href="' . base_url('recruitment/job_posting/details/') . $rec['jp_id'] . '#' . $rec['status'] . '">View In Job</a>';
                            }
                            $tdData .= '<a target="_blank" href="' . base_url('recruitment/candidate/documents/') . $rec['can_id'] . '/resume" class="btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
                            if ($this->permission->method('can_basicinfo_list', 'update')->access()) {
                                $tdData .= '<a href="' . base_url('recruitment/Candidate/edit_caninfo/') . $rec['can_id'] . '"class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                            }
                            if ($this->permission->method('can_basicinfo_list', 'delete')->access()) {
                                $tdData .= '<a href="#" data-id="' . $rec['can_id'] . '" class="btn btn-xs btn-danger btn-delete"><i class="fa fa-trash"></i></a>';
                            }
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function bulk_candidate_form()
    {
        $data['title'] = display('create');
        $data['module'] = "recruitment";
        $data['page'] = "bulk_candidates_add_form";
        //$data['dropdown'] = $this->Selection_model->dropdownPosition();
        echo Modules::run('template/layout', $data);
    }
    public function bulkcandidateuploadcsv()
    {
        if (isset($_FILES["excel_file"]["name"]) && $_FILES["excel_file"]["name"] != "" && isset($_FILES["resume_uploads"]["name"]) && count($_FILES['resume_uploads']['name']) > 0) {
            $path = $_FILES["excel_file"]["tmp_name"];
            $candidates_data = [];
            $exc_object = $this->excel->read($path);
            foreach ($exc_object as $key_row => $sale) {
                if ($key_row == 1) {
                    continue;
                }
                if (emptyArray($sale)) {
                    continue;
                }
                if (empty(trim($sale['A']))) {
                    $this->session->set_flashdata('exception', sprintf('Import failed, Empty Job ID column at row# %s', $key_row));
                    redirect($_SERVER['HTTP_REFERER']);
                }
                $job_rec = $this->db->where('jp_id', $sale['A'])->get('job_posting')->row();
                if (!$job_rec) {
                    $this->session->set_flashdata('exception', sprintf('Import failed, Job with ID %s doesn\'t exist at row# %s', $sale['A'], $key_row));
                    redirect($_SERVER['HTTP_REFERER']);
                }
                if (empty(trim($sale['D']))) {
                    $this->session->set_flashdata('exception', sprintf('Import failed, Empty email column at row# %s', $key_row));
                    redirect($_SERVER['HTTP_REFERER']);
                }
                if (empty(trim($sale['H']))) {
                    $this->session->set_flashdata('exception', sprintf('Import failed, Empty resume column at row# %s', $key_row));
                    redirect($_SERVER['HTTP_REFERER']);
                }
                $job_id = $sale['A'];
                $first_name = $sale['B'] ?? '';
                $last_name = $sale['C'] ?? '';
                $email = $sale['D'];
                $phone = $sale['E'] ?? '';
                $alter_phone = $sale['F'] ?? '';
                $address = $sale['G'] ?? '';
                $resume = $sale['H'];
                $last_employer = $sale['I'] ?? '';
                $total_years_of_experience = $sale['J'] ?? 0;
                $file_path = APPPATH . 'modules/recruitment/assets/candidates_resume/' . date('Y-m-d') . "/" . $resume;
                if (!is_dir(APPPATH . 'modules/recruitment/assets/candidates_resume/' . date('Y-m-d'))) {
                    mkdir(APPPATH . 'modules/recruitment/assets/candidates_resume/' . date('Y-m-d'));
                }
                foreach ($_FILES['resume_uploads']['name'] as $file_key => $filename) {
                    $filename = trim($filename);
                    //@unlink($file_path);
                    if ($filename == $resume) {
                        move_uploaded_file($_FILES['resume_uploads']['tmp_name'][$file_key], $file_path);
                    }
                }
                if (!file_exists($file_path)) {
                    $this->session->set_flashdata('exception', sprintf('Resume file (%s) for candidate "%s" not found with the uploads on row# %s', $resume, $email, $key_row));
                    redirect($_SERVER['HTTP_REFERER']);
                }
                $can_id = $this->generate->id();
                $candidates_data[] = array(
                    'can_id' => $can_id,
                    'jp_id' => $job_id,
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                    'email' => $email,
                    'phone' => $phone,
                    'alter_phone' => $alter_phone,
                    'address' => $address,
                    'resume' => './application/modules/recruitment/assets/candidates_resume/' . date('Y-m-d') . "/" . $resume,
                    'last_employer' => $last_employer,
                    'total_years_of_experience' => intval($total_years_of_experience),
                    'applied_on' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                );
                /**
                 * Job ID check see if job exists
                 */
                $job_exist = $this->db->get_where('job_posting', array('jp_id' => $job_id))->result();
                if (!$job_exist) {
                    $this->session->set_flashdata('exception', sprintf('Job ID "%s" doesn\'t exist on excel sheet row# %s', $job_id, $key_row));
                    redirect($_SERVER['HTTP_REFERER']);
                }
                /**
                 * Candidate email check if candidate already exists for this job ID
                 */
                $this->db->select('can_id');
                $this->db->from('candidate_basic_info');
                $this->db->where('email', $email);
                $this->db->where('jp_id', $job_id);
                $candidate_found = $this->db->get()->result();
                if ($candidate_found) {
                    $this->session->set_flashdata('exception', sprintf('Candidate with email "%s" already exists for Job ID %s on excel sheet row# %s', $email, $job_id, $key_row));
                    redirect($_SERVER['HTTP_REFERER']);
                }
            }
            if ($candidates_data) {
                $this->db->trans_start();
                foreach ($candidates_data as $can_data) {
                    $this->db->insert('candidate_basic_info', $can_data);
                    $this->notify->department('hr')->send(
                        sprintf('A new candidate %s has entered into recruitment pool', implode(' ', [$can_data['first_name'], $can_data['last_name'], '(' . $can_data['can_id'] . ')'])),
                        'recruitment/Candidate/candidateinfo_view'
                    );
                }
                $this->db->trans_complete();
                if ($this->db->trans_status()) {
                    $this->session->set_flashdata('message', display('successfully_uploaded'));
                    redirect($_SERVER['HTTP_REFERER']);
                }
            }
        }
        $this->session->set_flashdata('exception', display('select_excel_and_candidate_resume'));
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function caninfo_create_linked_job($job_id)
    {
        $job_data = $this->Candidate_model->jobs_reads($job_id);
        if ($job_data) {
            $data['title'] = display('create_details');
            $data['module'] = "recruitment";
            $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
            $data['jobs_reads'] = $job_data;
            $data['page'] = "canInfo_form";
            echo Modules::run('template/layout', $data);
        } else {
            $this->session->set_flashdata('exception', display('job_data_not_found'));
            redirect("recruitment/Job_posting/manage_job_posting");
        }
    }
    public function edit_caninfo($can_id)
    {
        $this->permission->method('can_basicinfo_list', 'update')->redirect();
        $caninfo_data = $this->Candidate_model->specific_caninfo($can_id);
        if ($caninfo_data) {
            $data['title'] = display('edit_candidate_details');
            $data['module'] = "recruitment";
            $data['caninfo_data'] = $caninfo_data;
            $data['positions'] = getByWhere('position', 'pos_id id, position_name name', [], ['position_name', 'asc']);
            $data['requisition_data'] = $this->Candidate_model->get_requisition_dropdown();
            $data['page'] = "caninfo_edit_form";
            echo Modules::run('template/layout', $data);
        } else {
            $this->session->set_flashdata('exception', display('candidate_data_not_found'));
            redirect("recruitment/Candidate/candidateinfo_view");
        }
    }
    public function can_info_create()
    {
        $data['title'] = display('write_y_p_info');
        #-------------------------------#
        $this->form_validation->set_rules(
            'job_id', display('job_id'),
            'required',
            array(
                'required' => display('job_id') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'first_name', display('first_name'),
            'required',
            array(
                'required' => display('first_name') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'last_name', display('last_name'),
            'required',
            array(
                'required' => display('last_name') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'email', display('email'),
            'required',
            array(
                'required' => display('email') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'phone', display('phone'),
            'required',
            array(
                'required' => display('phone') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'alter_phone', display('alter_phone'),
            'required',
            array(
                'required' => display('alter_phone') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'address', display('address'),
            'required',
            array(
                'required' => display('address') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'last_employer', display('last_employer'),
            'required',
            array(
                'required' => display('last_employer') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'total_years_of_experience', display('total_years_of_experience'),
            'required',
            array(
                'required' => display('total_years_of_experience') . ' is required',
            )
        );
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            if (isset($_FILES) && $_FILES['resume_uploads']['name'] != "") {
                $this->load->library('myupload');
                $id = $this->generate->id();
                $file = $this->myupload->do_upload(
                    './application/modules/recruitment/assets/candidates_resume/', 'resume_uploads'
                );
                $postData1 = [
                    'can_id' => $id,
                    'first_name' => $this->input->post('first_name', true),
                    'last_name' => $this->input->post('last_name', true),
                    'email' => $this->input->post('email', true),
                    'phone' => $this->input->post('phone', true),
                    'alter_phone' => $this->input->post('alter_phone', true),
                    'address' => $this->input->post('address', true),
                    'last_employer' => $this->input->post('last_employer', true),
                    'resume' => $file,
                    'total_years_of_experience' => $this->input->post('total_years_of_experience', true),
                    'jp_id' => $this->input->post('job_id', true),
                    'applied_on' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ];
                $job_exist = $this->db->get_where('job_posting', array('jp_id' => $this->input->post('job_id', true)))->result();
                $this->db->select('can_id');
                $this->db->from('candidate_basic_info');
                $this->db->where('email', $this->input->post('email', true));
                $this->db->where('jp_id', $this->input->post('job_id', true));
                $this->db->or_where('phone', $this->input->post('phone', true));
                $this->db->where('jp_id', $this->input->post('job_id', true));
                $this->db->or_where('alter_phone', $this->input->post('alter_phone', true));
                $this->db->where('jp_id', $this->input->post('job_id', true));
                $candidate_found = $this->db->get()->result();
                if ($job_exist && !$candidate_found) {
                    $res = $this->db->insert('candidate_basic_info', $postData1);
                    if ($res) {
                        $this->notify->department('hr')->send(
                            sprintf('A new candidate %s has entered into recruitment pool', implode(' ', [$postData1['first_name'], $postData1['last_name'], '(' . $postData1['can_id'] . ')'])),
                            'recruitment/Candidate/candidateinfo_view'
                        );
                    }
                    $this->session->set_flashdata('message', display('successfully_saved'));
                    redirect("recruitment/Candidate/candidateinfo_view");
                } else {
                    $this->session->set_flashdata('exception', display('candidate_data_not_uploaded_due_to_error'));
                    $data['title'] = display('create_details');
                    $data['module'] = "recruitment";
                    $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
                    $data['jobs_reads'] = $this->Candidate_model->jobs_reads($_POST['job_id']);
                    $data['page'] = "canInfo_form";
                    echo Modules::run('template/layout', $data);
                }
            } else {
                $this->session->set_flashdata('exception', display('file_not_found'));
                $data['title'] = display('create_details');
                $data['module'] = "recruitment";
                $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
                $data['jobs_reads'] = $this->Candidate_model->jobs_reads($_POST['job_id']);
                $data['page'] = "canInfo_form";
                echo Modules::run('template/layout', $data);
            }
        } else {
            $data['title'] = display('create_details');
            $data['module'] = "recruitment";
            $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
            $data['jobs_reads'] = $this->Candidate_model->jobs_reads($_POST['job_id']);
            $data['page'] = "canInfo_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function can_info_update()
    {
        $data['title'] = display('write_y_p_info');
        #-------------------------------#
        $this->form_validation->set_rules(
            'can_id', display('can_id'),
            'required',
            array(
                'required' => display('can_id') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'job_id', display('job_id'),
            'required',
            array(
                'required' => display('job_id') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'first_name', display('first_name'),
            'required',
            array(
                'required' => display('first_name') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'last_name', display('last_name'),
            'required',
            array(
                'required' => display('last_name') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'email', display('email'),
            'required',
            array(
                'required' => display('email') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'phone', display('phone'),
            'required',
            array(
                'required' => display('phone') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'address', display('address'),
            'required',
            array(
                'required' => display('address') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'last_employer', display('last_employer'),
            'required',
            array(
                'required' => display('last_employer') . ' is required',
            )
        );
        $this->form_validation->set_rules(
            'total_years_of_experience', display('total_years_of_experience'),
            'required',
            array(
                'required' => display('total_years_of_experience') . ' is required',
            )
        );
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $can_rec = $this->db
                ->select('job_posting.*, position.position_name as job_name')
                ->where('can_id', $_POST['can_id'])
                ->join('job_posting', 'candidate_basic_info.jp_id=job_posting.jp_id', 'left')
                ->join('position', 'position.pos_id=job_posting.pos_id', 'left')
                ->get('candidate_basic_info')->row();
            $postData1 = [
                'jp_id' => $this->input->post('job_id', true),
                'first_name' => $this->input->post('first_name', true),
                'last_name' => $this->input->post('last_name', true),
                'email' => $this->input->post('email', true),
                'phone' => $this->input->post('phone', true),
                'alter_phone' => $this->input->post('alter_phone', true),
                'address' => $this->input->post('address', true),
                'last_employer' => $this->input->post('last_employer', true),
                'total_years_of_experience' => $this->input->post('total_years_of_experience', true),
                'updated_at' => current_date(true),
            ];
            if (isset($_FILES) && $_FILES['resume_uploads']['name'] != "") {
                $this->load->library('myupload');
                $file = $this->myupload->do_upload(
                    './application/modules/recruitment/assets/candidates_resume/', 'resume_uploads'
                );
                $postData1['resume'] = $file;
            }
            $this->db->where('can_id', $_POST['can_id']);
            $this->db->update('candidate_basic_info', $postData1);
            $this->activity
                ->set_candidate($_POST['can_id'])
                ->log('candidate_updated');
            if ($can_rec->jp_id != $_POST['job_id']) {
                $this->activity
                    ->set_job($_POST['job_id'])
                    ->set_candidate($_POST['can_id'])
                    ->log([
                        'candidate_moved_job',
                        $can_rec->jp_id,
                        $can_rec->job_name,
                    ]);
            }
            $this->session->set_flashdata('message', display('successfully_updated'));
            redirect("recruitment/Candidate/candidateinfo_view");
        } else {
            $data['title'] = display('edit_candidate_details');
            $data['module'] = "recruitment";
            $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
            $data['requisition_data'] = $this->Candidate_model->get_requisition_dropdown();
            $data['caninfo_data'] = $this->Candidate_model->specific_caninfo($_POST['can_id']);
            $data['page'] = "caninfo_edit_form";
            echo Modules::run('template/layout', $data);
        }
    }
/*  ########################    details save  #######################################  */
    /* ############# For viewing details  #################### */
    public function candatails_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();
        $data['title'] = display('view details');
        $data['all_data'] = $this->Candidate_model->retrieve_all_data();
        $data['module'] = "recruitment";
        $data['page'] = "can_details";
        echo Modules::run('template/layout', $data);
    }
    public function cv()
    {
        $this->permission->module('recruitment', 'read')->redirect();
        $data['title'] = display('view details');
        $id = $this->uri->segment(4);
        $data['cv'] = $this->Candidate_model->employee_details($id);
        $data['edu'] = $this->Candidate_model->eduInfo($id);
        $data['wrk'] = $this->Candidate_model->workingexp($id);
        $data['module'] = "recruitment";
        $data['page'] = "cv";
        echo Modules::run('template/layout', $data);
    }
    /* ############# For viewing details  #################### */
    public function delete_canInfo($id = null)
    {
        $this->permission->method('can_basicinfo_list', 'delete')->redirect();
        if ($this->Candidate_model->delete_cinfo($id)) {
            #set success message
            if($this->input->get('json')) {
                return sendJson(['success' => display('delete_successfully')]);
            }
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            if($this->input->get('json')) {
                return sendJson(['success' => display('please_try_again')]);
            }
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('recruitment/Candidate/candidateinfo_view');
    }
    public function delete_talentNetwork($id = null)
    {
        $this->permission->method('talent_network', 'delete')->redirect();
        if ($this->Candidate_model->delete_talentNetwork($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('recruitment/Candidate/talent_network');
    }
    public function update_canifo_form($id = null)
    {
        redirect();
        $data['title'] = display('write_y_p_info');
        #-------------------------------#
        $this->form_validation->set_rules('can_id', null, 'required|max_length[20]');
        $this->form_validation->set_rules('first_name', display('first_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('last_name', display('last_name'), 'max_length[100]');
        $this->form_validation->set_rules('email', display('email'), 'required|max_length[32]');
        $this->form_validation->set_rules('phone', display('phone'), 'required|max_length[100]');
        $this->form_validation->set_rules('alter_phone', display('alter_phone'), 'max_length[100]');
        $this->form_validation->set_rules('present_address', display('present_address'), 'max_length[100]');
        $this->form_validation->set_rules('parmanent_address', display('parmanent_address'), 'max_length[100]');
        $this->load->library('myupload');
        $img = $this->myupload->do_upload(
            './application/modules/recruitment/assets/images/', 'picture'
        );
        $this->form_validation->set_rules('degree_name[]', display('degree_name'));
        $this->form_validation->set_rules('university_name[]', display('university_name'));
        $this->form_validation->set_rules('cgp[]', display('cgp'));
        $this->form_validation->set_rules('comments', display('comments'));
        $unis = $this->input->post('university_name');
        $degs = $this->input->post('degree_name');
        $cgps = $this->input->post('cgp');
        $this->form_validation->set_rules('company_name[]', display('company_name'));
        $this->form_validation->set_rules('working_period[]', display('working_period'));
        $this->form_validation->set_rules('duties[]', display('duties'));
        $this->form_validation->set_rules('supervisor[]', display('supervisor'));
        $comname = $this->input->post('company_name');
        $wperiod = $this->input->post('working_period');
        $duties = $this->input->post('duties');
        $supe = $this->input->post('supervisor');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData1 = [
                'can_id' => $this->input->post('can_id', true),
                'first_name' => $this->input->post('first_name', true),
                'last_name' => $this->input->post('last_name', true),
                'email' => $this->input->post('email', true),
                'phone' => $this->input->post('phone', true),
                'alter_phone' => $this->input->post('alter_phone', true),
                'present_address' => $this->input->post('present_address', true),
                'parmanent_address' => $this->input->post('parmanent_address', true),
                'picture' => (!empty($img) ? $img : $this->input->post('picture')),
                'ssn' => $this->input->post('ssn', true),
                'state' => $this->input->post('state', true),
                'city' => $this->input->post('city', true),
                'zip' => $this->input->post('zip_code', true),
            ];
            $this->Candidate_model->update_canInfo($postData1);
            $this->db->where('can_id', $this->input->post('can_id'))
                ->delete('candidate_education_info');
            for ($i = 0; $i < sizeof($unis); $i++) {
                $postData2 = [
                    'can_id' => $this->input->post('can_id'),
                    'university_name' => $unis[$i],
                    'degree_name' => $degs[$i],
                    'cgp' => $cgps[$i],
                    'comments' => $this->input->post('comments', true),
                ];
                if (!empty($unis[$i])) {
                    $this->db->insert('candidate_education_info', $postData2);
                }
            }
            $this->db->where('can_id', $this->input->post('can_id'))
                ->delete('candidate_workexperience');
            for ($i = 0; $i < sizeof($comname); $i++) {
                $postData = [
                    'can_id' => $this->input->post('can_id', true),
                    'company_name' => $comname[$i],
                    'working_period' => $wperiod[$i],
                    'duties' => $duties[$i],
                    'supervisor' => $supe[$i],
                ];
                if (!empty($comname[$i])) {
                    $this->db->insert('candidate_workexperience', $postData);
                }
            }
            $this->session->set_flashdata('message', display('successfully_updated'));
            redirect("recruitment/Candidate/candidateinfo_view");
        } else {
            $id = $this->uri->segment(4);
            $data['title'] = display('create_details');
            $data['module'] = "recruitment";
            $data['basinfo'] = $this->Candidate_model->canifo_updateForm($id);
            $data['edinfo'] = $this->Candidate_model->canEdu_updateForm($id);
            $data['work'] = $this->Candidate_model->work($id);
            $data['edu'] = $this->Candidate_model->upcanedu($id);
            $data['page'] = "update_canIfo";
            $data['country_list'] = array(
                "Alabama" => "Alabama",
                "Alaska" => "Alaska",
                "Arizona" => "Arizona",
                "Arkansas" => "Arkansas",
                "California" => "California",
                "Colorado" => "Colorado",
                "Connecticut" => "Connecticut",
                "Delaware" => "Delaware",
                "Florida" => "Florida",
                "Georgia" => "Georgia",
                "Hawaii" => "Hawaii",
                "Idaho" => "Idaho",
                "Illinois" => "Illinois",
                "Indiana" => "Indiana",
                "Iowa" => "Iowa",
                "Kansas" => "Kansas",
                "Kentucky" => "Kentucky",
                "Louisiana" => "Louisiana",
                "Maine" => "Maine",
                "Maryland" => "Maryland",
                "Massachusetts" => "Massachusetts",
                "Michigan" => "Michigan",
                "Minnesota" => "Minnesota",
                "Mississippi" => "Mississippi",
                "Missouri" => "Missouri",
                "Montana" => "Montana",
                "Nebraska" => "Nebraska",
                "Nevada" => "Nevada",
                "New Hampshire" => "New Hampshire",
                "New Jersey" => "New Jersey",
                "New Mexico" => "New Mexico",
                "New York" => "New York",
                "North Carolina" => "North Carolina",
                "North Dakota" => "North Dakota",
                "Ohio" => "Ohio",
                "Oklahoma" => "Oklahoma",
                "Oregon" => "Oregon",
                "Pennsylvania" => "Pennsylvania",
                "Rhode Rhode" => "Rhode Island",
                "South Carolina" => "South Carolina",
                "sDakota" => "sDakota",
                "Tennessee" => "Tennessee",
                "Texas" => "Texas",
                "Utah" => "Utah",
                "Vermont" => "Vermont",
                "Virginia" => "Virginia",
                "Washington" => "Washington",
                "West Virginia" => "West Virginia",
                "Wisconsin" => "Wisconsin",
                "Wyoming" => "Wyoming",
            );
            echo Modules::run('template/layout', $data);
        }
    }
/*##################### ---Advertisement part---####################*/
    public function candidate_edu_info_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();
        $data['title'] = display('educationinfo_list');
        $data['edu'] = $this->Candidate_model->viewEduinfo();
        $data['module'] = "recruitment";
        $data['page'] = "canInfoview";
        echo Modules::run('template/layout', $data);
    }
    public function create_can_eduinfo()
    {
        redirect();
        /***** file upload code start ***********/
        $data['title'] = display('educationinfo_list');
        #-------------------------------#
        $this->form_validation->set_rules('can_id', display('can_id'));
        $this->form_validation->set_rules('degree_name[]', display('degree_name'));
        $this->form_validation->set_rules('university_name[]', display('university_name'));
        $this->form_validation->set_rules('cgp[]', display('cgp'));
        $this->form_validation->set_rules('comments', display('comments'), 'required');
        $unis = $this->input->post('university_name');
        $degs = $this->input->post('degree_name');
        $cgps = $this->input->post('cgp');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $id = $this->input->post('can_id');
            for ($i = 0; $i < sizeof($unis); $i++) {
                $postData = [
                    'can_id' => $this->input->post('can_id'),
                    'university_name' => $unis[$i],
                    'degree_name' => $degs[$i],
                    'cgp' => $cgps[$i],
                    'comments' => $this->input->post('comments', true),
                ];
                $this->Candidate_model->caneduinfo_create($postData);
            }
            $this->session->set_flashdata('message', display('save_successfully'));
            redirect("recruitment/Candidate/caninfo_create/$id/#tabs-3");
        } else {
            $data['title'] = display('create');
            $data['module'] = "recruitment";
            $data['page'] = "can_edu_form";
            $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_can_edu_Info($id = null)
    {
        $this->permission->module('recruitment', 'delete')->redirect();
        if ($this->Candidate_model->delete_canedu_info($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('recruitment/Candidate/candidateinfo_view');
    }
    public function update_can_eduifo_form($id = null)
    {
        redirect();
        $this->form_validation->set_rules('can_id', display('can_id'));
        $this->form_validation->set_rules('degree_name[]', display('degree_name'));
        $this->form_validation->set_rules('university_name[]', display('university_name'));
        $this->form_validation->set_rules('cgp[]', display('cgp'));
        $this->form_validation->set_rules('comments', display('comments'), 'required');
        $unis = $this->input->post('university_name');
        $degs = $this->input->post('degree_name');
        $cgps = $this->input->post('cgp');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $this->db->where('can_id', $this->input->post('can_id'))
                ->delete('candidate_education_info');
            for ($i = 0; $i < sizeof($unis); $i++) {
                $postData = [
                    'can_id' => $this->input->post('can_id'),
                    'university_name' => $unis[$i],
                    'degree_name' => $degs[$i],
                    'cgp' => $cgps[$i],
                    'comments' => $this->input->post('comments', true),
                ];
                $this->db->insert('candidate_education_info', $postData);
            }
            $this->session->set_flashdata('message', display('successfully_updated'));
            redirect("recruitment/Candidate/candidateinfo_view/" . $id);
        } else {
            $data['title'] = display('update');
            $id = $this->uri->segment(4);
            $data['data'] = $this->Candidate_model->canEdu_updateForm($id);
            $data['edu'] = $this->Candidate_model->upcanedu($id);
            $data['work'] = $this->Candidate_model->work($id);
            $data['query'] = $this->Candidate_model->get_eduinf_dropdown($id);
            $data['module'] = "recruitment";
            $data['page'] = "update_canedu_form";
            echo Modules::run('template/layout', $data);
        }
    }
/***** workexperience start ***********/
    public function workexperience_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();
        $data['title'] = display('educationinfo_list');
        $data['exp'] = $this->Candidate_model->viewExperience();
        $data['module'] = "recruitment";
        $data['page'] = "workexperienceView";
        echo Modules::run('template/layout', $data);
    }
    public function create_workexperience()
    {
        redirect();
        $data['title'] = display('workexperience_list');
        #-------------------------------#
        $this->form_validation->set_rules('can_id', display('can_id'), 'required');
        $this->form_validation->set_rules('company_name[]', display('company_name'));
        $this->form_validation->set_rules('working_period[]', display('working_period'));
        $this->form_validation->set_rules('duties[]', display('duties'));
        $this->form_validation->set_rules('supervisor[]', display('supervisor'));
        $comname = $this->input->post('company_name');
        $wperiod = $this->input->post('working_period');
        $duties = $this->input->post('duties');
        $supe = $this->input->post('supervisor');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            for ($i = 0; $i < sizeof($comname); $i++) {
                $postData = [
                    'can_id' => $this->input->post('can_id', true),
                    'company_name' => $comname[$i],
                    'working_period' => $wperiod[$i],
                    'duties' => $duties[$i],
                    'supervisor' => $supe[$i],
                ];
                $this->Candidate_model->canworkexp_create($postData);
            }
            $this->session->set_flashdata('message', display('save_successfully'));
            redirect("recruitment/Candidate/candidateinfo_view");
        } else {
            $data['title'] = display('create');
            $data['module'] = "recruitment";
            $data['page'] = "can_workexperience_form";
            $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
            echo Modules::run('template/layout', $data);
        }
    }
    public function update_workexperience_form($id = null)
    {
        redirect();
        $this->form_validation->set_rules('can_id', display('can_id'), 'required');
        $this->form_validation->set_rules('company_name[]', display('company_name'));
        $this->form_validation->set_rules('working_period[]', display('working_period'));
        $this->form_validation->set_rules('duties[]', display('duties'));
        $this->form_validation->set_rules('supervisor[]', display('supervisor'));
        $comname = $this->input->post('company_name');
        $wperiod = $this->input->post('working_period');
        $duties = $this->input->post('duties');
        $supe = $this->input->post('supervisor');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $this->db->where('can_id', $this->input->post('can_id'))
                ->delete('candidate_workexperience');
            for ($i = 0; $i < sizeof($comname); $i++) {
                $postData = [
                    'can_id' => $this->input->post('can_id', true),
                    'company_name' => $comname[$i],
                    'working_period' => $wperiod[$i],
                    'duties' => $duties[$i],
                    'supervisor' => $supe[$i],
                ];
                $this->db->insert('candidate_workexperience', $postData);
            }
            $this->session->set_flashdata('message', display('successfully_updated'));
            redirect("recruitment/Candidate/candidateinfo_view/" . $id);
        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Candidate_model->workexperience_updateForm($id);
            $id = $this->uri->segment(4);
            $data['work'] = $this->Candidate_model->work($id);
            $data['module'] = "recruitment";
            $data['page'] = "update_workexperience_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_workexperience($id = null)
    {
        $this->permission->module('recruitment', 'delete')->redirect();
        if ($this->Candidate_model->delete_workexp($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('recruitment/Candidate/candidateinfo_view/#menu1');
    }
    public function view_details()
    {
        $data = array();
        $data['ab'] = $this->Candidate_model->employee_details($id);
        //$data['ab']=$this->Candidate_model->Eduinfo($id);
        $this->load->view('cv', $data);
    }
    public function move_to_resource_pool()
    {
        if ($this->input->post()) {
            $this->db->trans_start();
            $can_rec = $this->db->where('can_id', $this->input->post('can_id'))->get('candidate_basic_info')->row();
            $this->db->insert('candidate_resource_pool', [
                'can_id' => $can_rec->can_id,
                'pos_id' => $this->input->post('position'),
                'last_jp_id' => $can_rec->jp_id,
            ]);
            $this->db->where('can_id', $can_rec->can_id)->update('candidate_basic_info', [
                'jp_id' => 0,
                'updated_at' => current_date(true),
            ]);
            $this->db->trans_complete();
            $res = $this->db->trans_status();
            if ($res) {
                $this->activity->set_url('recruitment/Candidate/resource_pool')->set_candidate($this->input->post('can_id'))->log('candidate_moved_resource_pool');
                $this->session->set_flashdata('success', 'Candidate has been moved to resource pool');
            } else {
                $this->session->set_flashdata('exception', 'Unable to move candidate to resource pool, try again');
            }
            redirect('recruitment/Candidate/candidateinfo_view');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function resource_pool()
    {
        $this->permission->method('resource_pool', 'read')->redirect();
        $data['title'] = 'Resource Pool';
        $data['rows'] = getByWhere(
            'candidate_resource_pool,
            candidate_basic_info-candidate_basic_info.can_id=candidate_resource_pool.can_id-left,
            position-position.pos_id=candidate_resource_pool.pos_id-left',
            'candidate_resource_pool.*, candidate_basic_info.*, position.position_name as position',
            []);
        $data['module'] = "recruitment";
        $data['page'] = "resource_pool";
        echo Modules::run('template/layout', $data);
    }
}
