<div class="container-fluid">
    <form action="#" method="post">
        <div class="row">
            <div class="col-md-2"></div>
            <div class="col-md-8">
                <div class="row">
                    <h4><?= display(['Google', 'form', 'account']) ?>:</h4>
                </div>
                <?php if($authenticated) :?>
                <div class="row">
                    <div class="col-md-12">
                        <b><?= display(['Authenticated', 'as']) ?></b>: <?= $account_name ?>
                        <small>(<?= $account_email ?>)</small>
                    </div>
                </div>
                <?php if($this->permission->method('quiz_settings', 'update')->access()): ?>
                <div class="row text-right">
                    <a class="btn btn-danger" href="<?= base_url('quiz/logout') ?>"
                        role="button"><?= display('logout') ?></a>
                </div>
                <?php endif?>
                <?php else:?>
                <div class="row">
                    <div class="col-md-12">
                        <b><?= display(['Authenticated', 'as']) ?></b>: <?= display(['not', 'logged', 'in'], true) ?>
                    </div>
                </div>
                <?php if($this->permission->method('quiz_settings', 'update')->access()): ?>
                <div class="row text-right">
                    <a class="btn btn-danger" href="<?= base_url('quiz/login') ?>"
                        role="button"><?= display('login') ?></a>
                </div>
                <?php endif?>
                <?php endif?>
                <div class="row">
                    <p class="text-muted">*
                        <?= display('HRM') ?><?= display([' ', 'will', 'fetch', 'quiz', 'data', 'from', 'this', 'account'], true) ?>
                    </p>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col-md-2"></div>
            <div class="col-md-8">
                <div class="row">
                    <h4><?= display(['Google', 'email_account']) ?>:</h4>
                </div>
                <?php if($mail_authenticated) :?>
                <div class="row">
                    <div class="col-md-12">
                        <b><?= display(['Authenticated', 'as']) ?></b>: <?= $mail_account_name ?>
                        <small>(<?= $mail_account_email ?>)</small>
                    </div>
                </div>
                <?php if($this->permission->method('quiz_settings', 'update')->access()): ?>
                <div class="row text-right">
                    <a class="btn btn-danger" href="<?= base_url('quiz/mail_logout') ?>"
                        role="button"><?= display('logout') ?></a>
                </div>
                <?php endif?>
                <?php else:?>
                <div class="row">
                    <div class="col-md-12">
                        <b><?= display(['Authenticated', 'as']) ?></b>: <?= display(['not', 'logged', 'in'], true) ?>
                    </div>
                </div>
                <?php if($this->permission->method('quiz_settings', 'update')->access()): ?>
                <div class="row text-right">
                    <a class="btn btn-danger" href="<?= base_url('quiz/mail_login') ?>"
                        role="button"><?= display('login') ?></a>
                </div>
                <?php endif?>
                <?php endif?>
                <div class="row">
                    <p class="text-muted">*
                        <?= display('HRM') ?><?= display([' ', 'will', 'send', 'emails', 'using', 'this', 'account'], true) ?>
                    </p>
                    <p class="text-muted">**
                        <?= display(['mail', 'account', 'login', 'will', 'expire', 'on', 'password', 'change', 'of', 'gmail', 'account'], true) ?>
                    </p>
                </div>
            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-md-2"></div>
            <div class="col-md-8">
                <div class="form-group">
                    <label for="departments">
                        <h4><?= display(['employee', 'departments']) ?></h4>
                    </label>
                    <select class="form-control" name="departments[]" id="departments" multiple <?= $this->permission->method('quiz_settings', 'update')->access() ? null : 'disabled' ?>>
                        <option value="" disabled><?= display(['select', 'option']) ?></option>
                        <?php foreach ($departments as $department) :?>
                        <option value="<?= $department->id ?>"
                            <?= in_array($department->id, $selected_departments) ? 'selected' : null ?>>
                            <?= $department->name ?></option>
                        <?php endforeach?>
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-2"></div>
            <div class="col-md-8">
                <div class="form-group">
                    <label for="warning_letter">
                        <h4><?= display(['warning', 'letter']) ?>:</h4>
                    </label>
                    <select class="form-control" name="warning_letter" id="warning_letter" <?= $this->permission->method('quiz_settings', 'update')->access() ? null : 'disabled' ?>>
                        <option value="" disabled><?= display(['select', 'option']) ?></option>
                        <?php foreach ($letters as $letter) :?>
                        <option value="<?= $letter->id ?>"
                            <?= $letter->id == $selected_letter ? 'selected' : null ?>>
                            <?= $letter->title ?></option>
                        <?php endforeach?>
                    </select>
                </div>
            </div>
        </div>
        <br>
        <?php if($this->permission->method('quiz_settings', 'update')->access()): ?>
        <div class="row">
            <div class="col-md-2"></div>
            <div class="col-md-8 text-center">
                <button type="submit" class="btn btn-primary"><?= display(['save', 'settings']) ?></button>
            </div>
        </div>
        <?php endif?>
    </form>
</div>