<style>
.table .label {
    font-size: 12px;
}
.table .label-success {
    background-color: green;
    border-color: green;
}
</style>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th><?= display('title') ?></th>
                        <th><?= display('due_date') ?></th>
                        <th><?= display(['total', 'marks']) ?></th>
                        <th><?= display('passing_perc') ?></th>
                        <th><?= display(['obtained', 'marks']) ?></th>
                        <th><?= display(['obtained', 'percentage']) ?></th>
                        <th><?= display(['taken', 'at']) ?></th>
                        <th><?= display('link') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($quizzes as $quiz) :?>
                    <?php $obtained_perc = $quiz->takenAt ? ($quiz->obtained / $quiz->totalScore) * 100 : null ?>
                    <tr>
                        <td><?= $quiz->title ?></td>
                        <td><?= formatted_date($quiz->due_date) ?></td>
                        <td><?= $quiz->totalScore ?></td>
                        <td><?= $quiz->passing_perc ?>%</td>
                        <td><?= ($quiz->takenAt && $quiz->resultSent != 'held') ? $quiz->obtained : null ?></td>
                        <td><?= $quiz->resultSent != 'held' ? sprintf('%g', number_format($obtained_perc, 2)) . '%' : null ?></td>
                        <td><?= formatted_date($quiz->takenAt) ?></td>
                        <td><?= $quiz->resultSent != 'held' ? ($quiz->takenAt ? ($obtained_perc >= $quiz->passing_perc ? '<span class="label label-success">'.display('passed').'</span>' : '<span class="label label-danger">'.display('failed').'</span>') : '<a target="_blank" class="btn btn-primary" href="'. base_url('quiz/link/') . $quiz->id .'"><i class="fa fa-link" aria-hidden="true"></i></a>') : null ?>
                        </td>
                    </tr>
                    <?php endforeach?>
                </tbody>
            </table>
        </div>
        <div class="col-sm-12 text-right">
            <p>* <?= display(['it', 'can', 'take', 'upto', 'two', 'minutes', 'for', 'results', 'to', 'reflect', 'on'], true) ?>
                HRM</p>
        </div>
    </div>
</div>