<style>
    .table-quiz-loader,
    .table-quiz-loader:before,
    .table-quiz-loader:after {
        border-radius: 50%;
        width: 2.5em;
        height: 2.5em;
        -webkit-animation-fill-mode: both;
        animation-fill-mode: both;
        -webkit-animation: load7 1.8s infinite ease-in-out;
        animation: load7 1.8s infinite ease-in-out;
    }

    .table-quiz-loader {
        color: #000000;
        font-size: 4px;
        position: unset;
        margin-left: 20px;
        margin-top: -10px;
        text-indent: -9999em;
        -webkit-transform: translateZ(0);
        -ms-transform: translateZ(0);
        transform: translateZ(0);
        -webkit-animation-delay: -0.16s;
        animation-delay: -0.16s;
    }

    .table-quiz-loader:before,
    .table-quiz-loader:after {
        content: '';
        position: absolute;
        top: 0;
    }

    .table-quiz-loader:before {
        left: -3.5em;
        -webkit-animation-delay: -0.32s;
        animation-delay: -0.32s;
    }

    .table-quiz-loader:after {
        left: 3.5em;
    }

    @-webkit-keyframes load7 {

        0%,
        80%,
        100% {
            box-shadow: 0 2.5em 0 -1.3em;
        }

        40% {
            box-shadow: 0 2.5em 0 0;
        }
    }

    @keyframes load7 {

        0%,
        80%,
        100% {
            box-shadow: 0 2.5em 0 -1.3em;
        }

        40% {
            box-shadow: 0 2.5em 0 0;
        }
    }
</style>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th><?= display('title') ?></th>
                        <th><?= display(['form', 'name']) ?></th>
                        <th><?= display('due_date') ?></th>
                        <th><?= display('passing_perc') ?></th>
                        <th><?= display('link') ?></th>
                        <th><?= display(['Auto', 'Send', 'Results']) ?></th>
                        <th><?= display(['added', 'at']) ?></th>
                        <th><?= display('updated_at') ?></th>
                        <th><?= display('action') ?></th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
    window.dtable = $('table.table').DataTable($.extend({},
        window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                beforeSend: function() {},
                complete: function() {
                    if(!window.dtable_reload && $('table.table .table-quiz-loader').length > 0) {
                        window.dtable_reload = setInterval(() => {
                            window.dtable.ajax.reload()
                            if($('table.table .table-quiz-loader').length < 1) {
                                clearInterval(window.dtable_reload);
                            }
                        }, 5000);
                    }
                }
            },
            columns: [{
                'data': 'id',
            }, {
                'data': 'label',
            }, {
                'data': 'title',
            }, {
                'data': 'due_date',
            }, {
                'data': 'passing_perc',
            }, {
                'data': 'link',
            }, {
                'data': 'autorelease-score',
            }, {
                'data': 'added_at',
            }, {
                'data': 'modifiedTime',
            }, {
                'data': 'action',
                'sortable': false
            }, ],
            order: [
                [0, 'desc']
            ]
        }
    ))
    $('table.table').on('click', '.btn-delete', function(e) {
        e.preventDefault()
        $this = $(this);
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will remove all data of "<strong>${$this.data('name')}</strong>", do you really want to proceed?<br>You won't be able to revert this action!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>quiz/delete",
                    data: {
                        id: $this.data('id')
                    },
                    success: function(res) {
                        if (res.success) {
                            Swal.fire(
                                '<?= display('deleted') ?>!',
                                res.message,
                                'success'
                            )
                            
                            window.dtable.ajax.reload()
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.message,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
});
</script>