<style>
.nav.nav-tabs li:not(.active) a {
    pointer-events: all;
}
</style>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <form method="post" id="wizard-form">
                <div id="quiz-wizard">
                    <ul class="nav">
                        <li>
                            <a class="nav-link" href="#step-1">
                                Step 1
                                <p><small><?= display(['select', 'quiz']) ?></small></p>
                            </a>
                        </li>
                        <li>
                            <a class="nav-link" href="#step-2">
                                Step 2
                                <p><small><?= display(['select', 'employees']) ?></small></p>
                            </a>
                        </li>
                        <li>
                            <a class="nav-link" href="#step-3">
                                Step 3
                                <p><small><?= display('compose_email') ?></small></p>
                            </a>
                        </li>
                        <li>
                            <a class="nav-link" href="#step-4">
                                Step 4
                                <p><small><?= display('finish') ?></small></p>
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div id="step-1" class="tab-pane" role="tabpanel">
                            <p><?= display(['enter', 'quiz', 'details'], true) ?></p>
                            <hr>
                            <div class="container-fluid">
                                <div class="form-group row">
                                    <label for="quiz_id"
                                        class="col-sm-4 col-form-label"><?= display(['select', 'quiz']) ?></label>
                                    <div class="col-sm-8">
                                        <select class="form-control" name="quiz_id" id="quiz_id">
                                            <option value=""><?= display('select_one') ?></option>
                                            <?php foreach ($quizzes as $quiz) :?>
                                            <option value="<?= $quiz['id'] ?>"
                                                <?= $quiz['isQuiz'] ? null : 'disabled' ?>><?= $quiz['label'] ?>
                                            </option>
                                            <?php endforeach?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="label" class="col-sm-4 col-form-label"><?= display('label') ?></label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="label" id="label" value=""
                                            placeholder="<?= display(['Monday', 'Quiz', 'For', 'Team'], true) ?> A">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="" class="col-sm-4 col-form-label"><?= display(['Today']) ?></label>
                                    <div class="col-sm-8">
                                        <p><?= formatted_date_now() ?></p>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="due_date"
                                        class="col-sm-4 col-form-label"><?= display(['Due', 'Date']) ?></label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control flatpickr" name="due_date" id="due_date"
                                            value="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="passing_perc"
                                        class="col-sm-4 col-form-label"><?= display(['Passing', 'Percentage']) ?></label>
                                    <div class="col-sm-2">
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="passing_perc"
                                                id="passing_perc" value="95" style="border-radius: 0px !important">
                                            <span class="input-group-addon">%</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="autorelease-score"
                                        class="col-sm-4 col-form-label"><?= display(['Auto', 'Send', 'Results']) ?></label>
                                    <div class="col-sm-2">
                                        <div class="input-group">
                                            <select name="autorelease-score" id="autorelease-score"
                                                class="form-control dont-select-me" required="required">
                                                <option value="1"><?= display('yes') ?></option>
                                                <option value="0"><?= display('no') ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <?php if(defined('INTERNAL_HRM') && $this->session->userdata('employee_id') == 277): ?>
                                <div class="form-group row">
                                    <label for="record_purposes"
                                        class="col-sm-4 col-form-label"><?= display(['for', 'Record', 'purposes']) ?></label>
                                    <div class="col-sm-2">
                                        <div class="input-group">
                                            <select name="record_purposes" id="record_purposes"
                                                class="form-control dont-select-me" required="required">
                                                <option value="0"><?= display('no') ?></option>
                                                <option value="1"><?= display('yes') ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <?php endif;?>
                            </div>
                        </div>
                        <div id="step-2" class="tab-pane" role="tabpanel">
                            <p><?= display(['assign', 'quiz', 'to', 'employees'], true) ?></p>
                            <hr>
                            <div role="tabpanel">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#employees" aria-controls="home" role="tab"
                                            data-toggle="tab"><?= display(['employees']) ?></a>
                                    </li>
                                    <li role="presentation">
                                        <a href="#team-managers" aria-controls="tab" role="tab"
                                            data-toggle="tab"><?= display(['team', 'managers']) ?></a>
                                    </li>
                                </ul>

                                <!-- Tab panes -->
                                <div class="tab-content">
                                    <div role="tabpanel" class="tab-pane active" id="employees">
                                        <table class="table table-bordered table-hover table-striped table-responsive">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        <input type="checkbox" class="form-check-input emp-checkall"
                                                            title="<?= display(['select', 'all']) ?>">
                                                    </th>
                                                    <th><?= display('hrm_id') ?></th>
                                                    <th><?= display('pseudo') ?></th>
                                                    <th><?= display('name') ?></th>
                                                    <th><?= display('title') ?></th>
                                                    <th><?= display('DOJ') ?></th>
                                                    <th><?= display('email') ?></th>
                                                    <th><?= display(['manager', 'name']) ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($employees_tenure_wise as $tenure_label => $employees) :?>
                                                <?php if(!$employees) {
                                                    continue;
                                                } ?>
                                                <tr>
                                                    <td scope="row" colspan="8" style="font-size: large">
                                                        <strong><?= display('tenure') ?>: <?= $tenure_label ?></strong>
                                                    </td>
                                                </tr>
                                                <?php foreach ($employees as $employee) :?>
                                                <tr>
                                                    <td scope="row"><input type="checkbox" name="emps[]"
                                                            value="<?= $employee->employee_id ?>"
                                                            class="form-check-input <?= empty(trim($employee->business_email)) ? null : 'emp-check' ?>"
                                                            <?= empty(trim($employee->business_email)) ? 'disabled' : null ?>>
                                                    </td>
                                                    <td><?= $employee->hrm_id ?></td>
                                                    <td><?= $employee->pseudo ?></td>
                                                    <td><?= $employee->full_name ?></td>
                                                    <td><?= $employee->position ?></td>
                                                    <td><?= $employee->hire_date ?></td>
                                                    <td><?= $employee->business_email ?></td>
                                                    <td><?= $employee->direct_manager_name ?></td>
                                                </tr>
                                                <?php endforeach?>
                                                <?php endforeach?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div role="tabpanel" class="tab-pane" id="team-managers">
                                        <table class="table table-bordered table-hover table-striped table-responsive">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        <input type="checkbox" class="form-check-input emp-checkall"
                                                            title="<?= display(['select', 'all']) ?>">
                                                    </th>
                                                    <th><?= display('hrm_id') ?></th>
                                                    <th><?= display('pseudo') ?></th>
                                                    <th><?= display('name') ?></th>
                                                    <th><?= display('title') ?></th>
                                                    <th><?= display('DOJ') ?></th>
                                                    <th><?= display('email') ?></th>
                                                    <th><?= display(['manager', 'name']) ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($managers_tenure_wise as $tenure_label => $employees) :?>
                                                <?php if(!$employees) {
                                                    continue;
                                                } ?>
                                                <tr>
                                                    <td scope="row" colspan="8" style="font-size: large">
                                                        <strong><?= display('tenure') ?>: <?= $tenure_label ?></strong>
                                                    </td>
                                                </tr>
                                                <?php foreach ($employees as $employee) :?>
                                                <tr>
                                                    <td scope="row"><input type="checkbox" name="emps[]"
                                                            value="<?= $employee->employee_id ?>"
                                                            class="form-check-input <?= empty(trim($employee->business_email)) ? null : 'emp-check' ?>"
                                                            <?= empty(trim($employee->business_email)) ? 'disabled' : null ?>>
                                                    </td>
                                                    <td><?= $employee->hrm_id ?></td>
                                                    <td><?= $employee->pseudo ?></td>
                                                    <td><?= $employee->full_name ?></td>
                                                    <td><?= $employee->position ?></td>
                                                    <td><?= $employee->hire_date ?></td>
                                                    <td><?= $employee->business_email ?></td>
                                                    <td><?= $employee->direct_manager_name ?></td>
                                                </tr>
                                                <?php endforeach?>
                                                <?php endforeach?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="step-3" class="tab-pane" role="tabpanel">
                            <div class="container-fluid">
                                <div class="form-group">
                                    <label for="selEmp">To</label>
                                    <input type="text" class="form-control" id="emTo" disabled>
                                </div>
                                <div class="form-group">
                                    <label for="emFrom">From</label>
                                    <input type="text" class="form-control" id="emFrom" disabled>
                                </div>
                                <div class="form-group">
                                    <label for="emCC">CC</label>
                                    <input type="text" class="form-control" id="emCC" disabled>
                                </div>
                                <div class="form-group">
                                    <label for="emBCC">BCC <small>(Comma-separated emails)</small></label>
                                    <input type="text" class="form-control" name="bcc" id="emBCC">
                                </div>
                                <div class="form-group">
                                    <label for="emSubject">Subject</label>
                                    <input type="text" class="form-control" name="subject" id="emSubject" required>
                                </div>
                                <div class="form-group">
                                    <label for="txtBody">Body</label>
                                    <textarea class="form-control editor" name="body" id="txtBody" rows="3"
                                        required></textarea>
                                </div>
                            </div>
                        </div>
                        <div id="step-4" class="tab-pane" role="tabpanel">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-md-2"></div>
                                    <div class="col-md-8">
                                        <div class="form-group row">
                                            <button type="button"
                                                class="btn btn-primary btn-preview-mail"><?= display('preview_email') ?>
                                                <i class="fa fa-eye" aria-hidden="true"></i></button>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-sm-6">
                                                <div class="radio icheck-danger">
                                                    <input type="radio" id="rad-send-now" name="send" value="now"
                                                        checked>
                                                    <label for="rad-send-now"><?= display(['send', 'now']) ?></label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="radio icheck-danger">
                                                    <input type="radio" id="rad-send-later" name="send" value="later">
                                                    <label
                                                        for="rad-send-later"><?= display(['send', 'later']) ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row" id="later_block" style="visibility: hidden;">
                                            <label for="email_scheduled"
                                                class="col-sm-4 col-form-label"><?= display('schedule_email') ?></label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control flatpickr-full"
                                                    name="email_scheduled" id="email_scheduled" value="">
                                            </div>
                                        </div>
                                        <div class="form-group row text-center">
                                            <button type="submit"
                                                class="btn btn-primary"><?= display(['submit', 'quiz']) ?> <i
                                                    class="fa fa-paper-plane" aria-hidden="true"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<link rel="stylesheet" href="<?=base_url()?>assets/plugins/smartwizard/smart_wizard_all.min.css">
<script src="<?=base_url()?>assets/plugins/smartwizard/jquery.smartWizard.min.js"></script>
<script src="<?php echo base_url(); ?>assets/js/ckeditor/ckeditor.js"></script>
<script src="<?php echo base_url(); ?>assets/js/ckeditor/adapters/jquery.js"></script>
<script>
$(document).ready(function() {
    $('#quiz-wizard').smartWizard({
        selected: 0, // Initial selected step, 0 = first step
        theme: 'arrows', // theme for the wizard, related css need to include for other than default theme
        backButtonSupport: true, // Enable the back button support
        enableURLhash: false, // Enable selection of the step based on url hash
        toolbarSettings: {
            toolbarPosition: 'both', // none, top, bottom, both
            toolbarExtraButtons: [] // Extra buttons to show on toolbar, array of jQuery input/buttons elements
        },
        lang: { // Language variables for button
            next: '<?= display('next') ?>',
            previous: '<?= display('previous') ?>'
        },
    });
    $('.flatpickr').flatpickr({
        dateFormat: 'd-m-Y',
        minDate: new Date().fp_incr(1)
    })
    $('.flatpickr-full').flatpickr({
        enableTime: true,
        dateFormat: "d-m-Y h:i K",
        minDate: new Date().fp_incr(1)
    })
    $('textarea.editor').ckeditor();
    $('input.emp-checkall').on('change', function() {
        if ($(this).is(':checked')) {
            $(this).closest('table').find('input.emp-check').prop('checked', true);
        } else {
            $(this).closest('table').find('input.emp-check').prop('checked', false);
        }
    })
    $('input[name=send]').on('change', function() {
        let $radio = $('input[name=send]:checked');
        if ($radio.val() == 'later') {
            $('#later_block').css('visibility', 'visible')
        } else {
            $('#later_block').css('visibility', 'hidden')
        }
    })
    $('#quiz_id').on('change', function() {
        $('#label').val($.trim($(this).find('option:selected').text()));
    })
    $("#quiz-wizard").on("leaveStep", function(e, anchorObject, currentStepIndex, nextStepIndex,
        stepDirection) {
        let hasErrors = false;
        switch (currentStepIndex) {
            case 0: {
                let $step = $('#step-1');
                if (!$step.find('#quiz_id').val()) {
                    alert('<?= display(['quiz', 'is', 'required'], true) ?>');
                    hasErrors = true;
                    break;
                }
                if (!$step.find('#label').val()) {
                    alert('<?= display(['title', 'is', 'required'], true) ?>');
                    hasErrors = true;
                    break;
                }
                if (!$step.find('#due_date').val()) {
                    alert('<?= display(['due', 'date', 'is', 'required'], true) ?>');
                    hasErrors = true;
                    break;
                }
                let perc = parseInt($step.find('#passing_perc').val());
                if (!perc) {
                    alert('<?= display(['passing', 'percentage', 'is', 'required'], true) ?>');
                    hasErrors = true;
                    break;
                }
                if (perc < 10 || perc > 100) {
                    alert(
                        '<?= display(['passing', 'percentage', 'value', 'must', 'be', 'between', '10-100'], true) ?>'
                    );
                    hasErrors = true;
                    break;
                }
                break;
            }
            case 1: {
                let $step = $('#step-2');
                if ($step.find('input.emp-check:checked').length < 1) {
                    hasErrors = true;
                    alert('<?= display(['select', 'at', 'least', 'one', 'employee'], true) ?>');
                    break;
                }
                myajax({
                    type: "POST",
                    url: '<?= base_url() ?>quiz/getComposedEmail',
                    data: $('form#wizard-form').serialize(),
                    success: function(res) {
                        let $nextStep = $('#step-3');
                        if (res.success) {
                            $nextStep.find('input#emTo').val(res.success.to.join(', '))
                            $nextStep.find('input#emCC').val(res.success.cc.join(', '))
                            $nextStep.find('input#emFrom').val(res.success.from)
                            $nextStep.find('input#emBCC').val(res.success.bcc)
                            $nextStep.find('input#emSubject').val(res.success.subject)
                            $nextStep.find('textarea#txtBody').val(res.success.body)
                        } else {
                            alert(res.error ??
                                '<?= display(['invalid', 'response', 'from', 'server']) ?>'
                            )
                        }
                    }
                });
                break;
            }
        }
        $("html, body").animate({
            scrollTop: 0
        }, "slow");
        return !hasErrors;
    });
    $('button.btn-preview-mail').on('click', function() {
        let $modal = $('#modal-view-email');
        let $step = $('#step-3');
        $modal.find('input#emToV').val($step.find('input#emTo').val())
        $modal.find('input#emFromV').val($step.find('input#emFrom').val())
        $modal.find('input#emCCV').val($step.find('input#emCC').val())
        $modal.find('input#emBCCV').val($step.find('input#emBCC').val())
        $modal.find('input#emSubjectV').val($step.find('input#emSubject').val())
        $modal.find('div#txtBodyV').html($step.find('textarea#txtBody').val())
        $modal.modal('show')
    })
    $('form#wizard-form').on('submit', function(e) {
        e.preventDefault();
        let $form = $(this);
        myajax({
            type: "POST",
            data: $form.serialize(),
            success: function(res) {
                if (res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    ).then(() => {
                        if (res.redirect) {
                            location.href = res.redirect
                        }
                    })
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error ??
                        '<?= display(['invalid', 'response', 'from', 'server']) ?>',
                        'error'
                    )
                }
            }
        });
    })
});
</script>
<!-- Modal -->
<div class="modal fade" id="modal-view-email" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?= display('email_preview') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="container-fluid">
                    <div class="form-group">
                        <label for="selEmpV">To</label>
                        <input type="text" class="form-control" id="emToV" disabled>
                    </div>
                    <div class="form-group">
                        <label for="emFromV">From</label>
                        <input type="text" class="form-control" id="emFromV" disabled>
                    </div>
                    <div class="form-group">
                        <label for="emCCV">CC</label>
                        <input type="text" class="form-control" id="emCCV" disabled>
                    </div>
                    <div class="form-group">
                        <label for="emBCCV">BCC</label>
                        <input type="text" class="form-control" id="emBCCV" disabled>
                    </div>
                    <div class="form-group">
                        <label for="emSubjectV">Subject</label>
                        <input type="text" class="form-control" id="emSubjectV" disabled>
                    </div>
                    <div class="form-group">
                        <label for="txtBodyV">Body</label>
                        <div id="txtBodyV" style="border: solid 1px black; padding: 1px 3px"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>