<div class="container-fluid">
    <table class="table table-bordered table-hover">
        <tbody>
            <tr>
                <th><?= display(['employee', 'name']) ?></th>
                <td><?= $employee->full_name ?> (<?= $employee->hrm_id ?>)</td>
                <th><?= display(['attempted', 'at']) ?></th>
                <td><?= formatted_date($employee->submittedAt, true) ?></td>
            </tr>
            <tr>
                <th><?= display('pseudo') ?></th>
                <td><?= $employee->pseudo ?></td>
                <th><?= display('email') ?></th>
                <td><?= $employee->business_email ?></td>
            </tr>
            <tr>
                <th><?= display(['Quiz', 'name']) ?></th>
                <td><?= $employee->quiz_title ?></td>
                <th><?= display('scored') ?></th>
                <td><?= $employee->totalScore ?> / <?= $employee->quizTotal ?></td>
            </tr>
            <tr>
                <th><?= display(['passing', 'percentage']) ?></th>
                <td><?= $employee->quiz_percentage ?>%</td>
                <th><?= display(['obtained', 'percentage']) ?></th>
                <td><?= sprintf('%g%%', number_format($employee->obtained_percentage, 2)) ?></td>
            </tr>
            <tr>
                <th><?= display('status') ?></th>
                <td><?= slug_to_readable($employee->status) ?></td>
            </tr>
        </tbody>
    </table>
    
    <table class="table" style="width: 100%">
        <colgroup>
            <col width="2%">
            <col width="9%">
            <col width="80%">
            <col width="9%">
        </colgroup>
        <tbody>
            <?php foreach ($questions as $key => $question) :?>
            <tr>
                <td scope="row">
                    <?php if($question['isCorrect']) : ?>
                        <i class="fa fa-check" aria-hidden="true" style="color:green; font-size:30px"></i>
                    <?php else:?>
                        <i class="fa fa-times" aria-hidden="true" style="color:red; font-size:30px"></i>
                    <?php endif ?>
                </td>
                <td><b>Q. <?= $key + 1 ?></b>:</td>
                <td><?= $question['title'] ?></td>
                <td><b><?= display('scored') ?></b><br><?= $question['score'] ?> / <?= $question['pointValue'] ?></td>
            </tr>
            <tr>
                <td scope="row"><b><?= display('answer') ?></b>:</td>
                <td colspan="3">
                    <?php if(count($question['answers']) == 1): ?>
                        <p><?= $question['answers'][0] ?></p>
                    <?php else:?>
                        <ul>
                        <?php foreach ($question['answers'] as $answer) :?>
                            <li><?= $answer ?></li>
                        <?php endforeach?>
                        </ul>
                    <?php endif?>
                </td>
            </tr>
            <?php if($question['feedback']) :?>
            <tr>
                <td scope="row"><b><?= display('Remarks') ?></b>:</td>
                <td colspan="3"><?= $question['feedback'] ?></td>
            </tr>
            <tr><td colspan="4"></td></tr>
            <?php endif?>
            <?php endforeach?>
        </tbody>
    </table>
</div>