<?php

class Quiz_employee_model extends CI_Model
{
    public function listQuery($id, $orWhere = [], $deleted = false)
    {
        $query = $this->db->where('form_id', $id)->from('google_quiz_employee_details');
        if ($deleted) {
            $query = $query->where('deletedAt !=', null);
        } else {
            $query = $query->where('deletedAt', null);
        }
        if ($orWhere) {
            $query = $query->group_start();
            foreach ($orWhere as $key => $value) {
                $query = $query->or_like($key, $value, 'after', false);
            }
            $query = $query->group_end();
        }
        return $query;
    }
    public function countAllRows($id, $deleted = false)
    {
        $query = $this->listQuery($id, [], $deleted);
        return $query->count_all_results();
    }
    public function countDatatable($id, $orWhere, $deleted = false)
    {
        $query = $this->listQuery($id, $orWhere, $deleted);
        return $query->count_all_results();
    }
    public function getDatatable($id, $post, $orWhere, $deleted = false)
    {
        $query = $this->listQuery($id, $orWhere, $deleted);
        $query->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $query->get()->result_array();
    }
    public function soft_delete($form_employee_id)
    {
        $this->db->trans_start();
        $emp = $this->db->select('form_id, employee_id, quiz_title')->where('form_employee_id', $form_employee_id)->get('google_quiz_employee_details')->row();
        $this->db->where('form_employee_id', $form_employee_id)->update('qz_rel_form_employee', [
            'deletedAt' => date('Y-m-d H:i:s'),
        ]);
        $this->activity->set_employee($emp->employee_id)
            ->log([
                'quiz_deleted_employee',
                $emp->quiz_title,
                $emp->form_id,
            ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function restore($form_employee_id)
    {
        $this->db->trans_start();
        $emp = $this->db->select('form_id, employee_id, quiz_title')->where('form_employee_id', $form_employee_id)->get('google_quiz_employee_details')->row();
        $this->db->where('form_employee_id', $form_employee_id)->update('qz_rel_form_employee', [
            'deletedAt' => null,
        ]);
        $this->activity->set_employee($emp->employee_id)
            ->log([
                'quiz_restored_employee',
                $emp->quiz_title,
                $emp->form_id,
            ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function add($form_id, $employee_id)
    {
        $this->db->trans_start();
        $form = $this->db->select('record_purposes')->where('id', $form_id)->get('qz_form')->row();
        $emp_rec = $this->db->select('business_email, direct_manager_email')->where('employee_id', $employee_id)->get('employee_details')->row();
        if (!$emp_rec) {
            return false;
        }
        $this->db->insert('qz_rel_form_employee', [
            'form_id' => $form_id,
            'employee_id' => $employee_id,
            'email' => $emp_rec->business_email,
        ]);
        if ($form->record_purposes != 1) {
            $email = $this->db->where(['form_id' => $form_id])->order_by('id', 'asc')->get('qz_email_queue')->row();
            if ($email) {
                $this->db->insert('qz_email_queue', [
                    'form_id' => $form_id,
                    'employee_id' => $employee_id,
                    'eto' => $emp_rec->business_email,
                    'subject' => $email->subject,
                    'content' => json_encode(array_merge($email->content, ['cc' => [$emp_rec->direct_manager_email]])),
                    'send_at' => $email->send_at,
                    'added_at' => date('Y-m-d H:i:s'),
                ]);
            }
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
}
