<?php
class Email_model extends CI_Model
{
    public function get($id = null)
    {
        $this->db->from('qz_email_queue');
        if ($id) {
            return $this->db->where('id', $id)->get()->row();
        }
        return $this->db->order_by('id', 'asc')->get()->row();
    }
    public function countAllRows($form_id)
    {
        if ($form_id) {
            $this->db->where('qz_email_queue.form_id', $form_id);
        }
        return $this->db->count_all_results('qz_email_queue');
    }
    public function countDatatable($form_id, $orWhere = [])
    {
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        if ($form_id) {
            $this->db->where('qz_email_queue.form_id', $form_id);
        }
        $this->db->join('employee_details', 'qz_email_queue.employee_id=employee_details.employee_id', 'left')
            ->join('qz_form', 'qz_email_queue.form_id=qz_form.id', 'left');
        return $this->db->count_all_results('qz_email_queue');
    }
    public function getDatatable($form_id, $orWhere = [])
    {
        $post = $this->input->post();

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->select('qz_email_queue.*, employee_details.hrm_id, employee_details.full_name, qz_form.title')
            ->join('employee_details', 'qz_email_queue.employee_id=employee_details.employee_id', 'left')
            ->join('qz_form', 'qz_email_queue.form_id=qz_form.id', 'left');
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);

        if ($form_id) {
            $this->db->where('qz_email_queue.form_id', $form_id);
        }
        return $this->db->get('qz_email_queue')->result_array();
    }
    public function requeue($ids)
    {
        $this->db->trans_start();
        foreach ($ids as $id) {
            $lg_rec = $this->get($id);
            $update_rec = [
                'status' => 'queued',
                'retries' => 0,
            ];
            if ($lg_rec->status != 'queued') {
                $update_rec['total_retries'] = $lg_rec->total_retries + 1;
            }
            $this->db->where('id', $id)->update('qz_email_queue', $update_rec);
            $this->activity->log([
                'quiz_email_requeued',
                $id,
                $lg_rec->eto,
            ]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function sendReminders()
    {
        $recs = $this->db->select([
            'qz_form.id',
            'qz_form.title',
            'qz_form.description',
            'qz_form.link',
            'qz_form.due_date',
            'qz_rel_form_employee.employee_id',
            'employee_details.business_email',
            'employee_details.direct_manager_email',
        ])->from('qz_rel_form_employee')
            ->join('qz_form', 'qz_rel_form_employee.form_id=qz_form.id', 'left')
            ->join('employee_details', 'qz_rel_form_employee.employee_id=employee_details.employee_id', 'left')
            ->where([
                'qz_form.due_date >=' => date('Y-m-d H:i:s'),
                'qz_rel_form_employee.submittedAt' => null,
                'qz_rel_form_employee.deletedAt' => null,
            ])
            ->get()
            ->result();

        if ($recs) {
            $date_now = date('Y-m-d H:i:s');
            $this->db->trans_start();
            foreach ($recs as $rec) {
                $email_content = [
                    'cc' => [$rec->direct_manager_email],
                ];
                $email_content['body'] = $this->load->view('quiz/emails/email_body', [
                    'title' => $rec->title,
                    'quiz_link' => $rec->link,
                    'due_date' => formatted_date($rec->due_date),
                    'reminder' => 1,
                ], true);
                $this->db->insert('qz_email_queue', [
                    'form_id' => $rec->id,
                    'employee_id' => $rec->employee_id,
                    'eto' => $rec->business_email,
                    'subject' => sprintf('Reminder: Invitation for \'%s\' Certification Quiz', $rec->title),
                    'content' => json_encode($email_content),
                    'send_at' => $date_now,
                    'added_at' => $date_now,
                ]);
            }
            $this->db->trans_complete();
            return $this->db->trans_status();
        }

        return true;
    }
    public function sendWarnings()
    {
        $this->load->model('quiz/quiz_model');
        $recs = $this->db->select([
            'qz_form.id',
            'qz_form.title',
            'qz_form.description',
            'qz_form.link',
            'qz_form.due_date',
            'qz_rel_form_employee.form_employee_id',
            'qz_rel_form_employee.employee_id',
            'employee_details.full_name',
            'employee_details.business_email',
            'employee_details.direct_manager_email',
            'employee_details.indirect_manager_email',
            'email_templates.email_hr',
        ])->from('qz_rel_form_employee')
            ->join('qz_form', 'qz_rel_form_employee.form_id=qz_form.id', 'left')
            ->join('employee_details', 'qz_rel_form_employee.employee_id=employee_details.employee_id', 'left')
            ->join('email_templates', 'employee_details.division_id=email_templates.division_id', 'left')
            ->where([
                'qz_form.due_date <' => date('Y-m-d H:i:s'),
                'qz_rel_form_employee.warningSent' => 0,
                'qz_rel_form_employee.submittedAt' => null,
                'qz_rel_form_employee.deletedAt' => null,
            ])
            ->get()
            ->result();
        if ($recs) {
            $letter_id = $this->options->get_system('system.quiz.warning_letter');
            $this->load->model('incident/letter_model');
            $date_now = date('Y-m-d H:i:s');
            $this->db->trans_start();
            foreach ($recs as $rec) {
                $incident_id = $this->letter_model->add_letter(
                    [$rec->employee_id],
                    $letter_id,
                    sprintf('<p>Missed the %s quiz</p>', $rec->title),
                    'reason_for_warning=Quiz Missed',
                    true
                );
                $email_content = [
                    'cc' => [$rec->direct_manager_email, $rec->indirect_manager_email],
                ];
                $email_content['body'] = $this->load->view('quiz/emails/warning_email', [
                    'title' => $rec->title,
                    'name' => $rec->full_name,
                    'incident_id' => $incident_id,
                ], true);
                $this->db->insert('qz_email_queue', [
                    'form_id' => $rec->id,
                    'employee_id' => $rec->employee_id,
                    'eto' => defined('STAGING_SERVER') ? $this->quiz_model->mailClient->userinfo()->getEmail() : $rec->email_hr,
                    'subject' => sprintf('Warning letter for \'%s\' quiz non-takers', $rec->title),
                    'content' => json_encode($email_content),
                    'send_at' => $date_now,
                    'added_at' => $date_now,
                ]);
                $this->db->where('form_employee_id', $rec->form_employee_id)->update('qz_rel_form_employee', [
                    'warningSent' => 1,
                ]);
            }
            $this->db->trans_complete();
            return $this->db->trans_status();
        }

        return true;
    }
    public function generateEmails()
    {
        $recs = $this->db->select([
            'form_id',
            'employee_id',
            'business_email',
            'direct_manager_email',
            'quiz_percentage',
            'obtained_percentage',
            'quiz_title',
            'full_name',
        ])
        ->group_start()
            ->or_where(['resultSent' => 'queued', 'autorelease-score' => 'yes'])
            ->group_end()
            ->where(['resultSent !=' => 'sent', 'submittedAt !=' => null, 'deletedAt' => null])
            ->get('google_quiz_employee_details')->result();
        $this->db->trans_start();
        foreach ($recs as $rec) {
            $result_email = [
                'form_id' => $rec->form_id,
                'employee_id' => $rec->employee_id,
                'eto' => $rec->business_email,
                'subject' => '',
                'content' => ['cc' => [$rec->direct_manager_email]],
                'send_at' => $now = date('Y-m-d H:i:s'),
                'added_at' => $now,
            ];
            if ($rec->obtained_percentage >= $rec->quiz_percentage) {
                $result_email['subject'] = sprintf('You have passed the %s quiz', $rec->quiz_title);
                $result_email['content']['body'] = $this->load->view('quiz/emails/quiz_passed', [
                    'employee_name' => $rec->full_name,
                    'title' => $rec->quiz_title,
                    'percentage' => round($rec->obtained_percentage, 2),
                ], true);
            } else {
                $result_email['subject'] = sprintf('You will be notified to retake the %s quiz', $rec->quiz_title);
                $result_email['content']['body'] = $this->load->view('quiz/emails/quiz_failed', [
                    'employee_name' => $rec->full_name,
                    'title' => $rec->quiz_title,
                    'percentage' => round($rec->obtained_percentage, 2),
                ], true);
            }
            $result_email['content'] = json_encode($result_email['content']);
            $this->db->insert('qz_email_queue', $result_email);
            $this->db->where(['form_id' => $rec->form_id, 'employee_id' => $rec->employee_id])->update('qz_rel_form_employee', [
                'resultSent' => 'sent',
            ]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
}
