<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Quiz_employee extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'quiz_model',
            'quiz_employee_model',
        ]);
        if (!$this->input->is_ajax_request()
            && !in_array($this->router->method, ['settings', 'login', 'mail_login', 'logout', 'mail_logout'])
            && (!$this->quiz_model->googleClient->auth() || !$this->quiz_model->mailClient->auth())) {
            $this->session->set_flashdata('exception', display(['one', 'or', 'more', 'accounts', 'is', 'logged', 'out'], true) . '. ' . display(['please', 'login', 'to', 'proceed'], true));
            redirect('quiz/settings');
        }
    }
    public function add()
    {
        $this->permission->method('all_quiz', 'create')->redirect();
        if ($this->input->post('form_id') && $this->input->post('employee_id')) {
            $rec = $this->db->where([
                'form_id' => $this->input->post('form_id'),
                'employee_id' => $this->input->post('employee_id'),
            ])->get('qz_rel_form_employee')
                ->row();
            if ($rec) {
                if (is_null($rec->deletedAt)) {
                    return sendJson(['error' => display(['employee', 'already', 'exists', 'in', 'this', 'quiz'], true)]);
                } else {
                    if ($this->quiz_employee_model->restore($rec->form_employee_id)) {
                        return sendJson(['success' => display(['employee', 'record', 'restored', 'successfully'], true), 'restored' => 1]);
                    }
                }
            } else {
                if ($this->quiz_employee_model->add($this->input->post('form_id'), $this->input->post('employee_id'))) {
                    return sendJson(['success' => display(['employee', 'added', 'successfully'], true)]);
                }
            }
        }
        return sendJson(['error' => 'Invalid employee selection']);
    }
    public function delete()
    {
        $this->permission->method('all_quiz', 'delete')->redirect();
        if ($this->input->post('form_employee_id')) {
            if ($this->quiz_employee_model->soft_delete($this->input->post('form_employee_id'))) {
                return sendJson(['success' => display(['employee', 'record', 'removed', 'from', 'quiz'], true)]);
            }
        }
        return sendJson(['error' => 'Invalid employee selection']);
    }
    public function restore()
    {
        $this->permission->method('all_quiz', 'delete')->redirect();
        if ($this->input->post('form_employee_id')) {
            if ($this->quiz_employee_model->restore($this->input->post('form_employee_id'))) {
                return sendJson(['success' => display(['employee', 'record', 'restored', 'successfully'], true)]);
            }
        }
        return sendJson(['error' => 'Invalid employee selection']);
    }
}
