<?php if($this->permission->method('tax_slabs', 'create')->access()) : ?>
<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#modelAdd">
        <?= display('add_tax_slab') ?>
        </button>
    </div>
</div>
<br>
<?php endif?>
<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-default thumbnail"> 
            <div class="panel-body table-responsive">
                <table width="100%" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Min</th>
                            <th>Max</th>
                            <th>Fixed Tax</th>
                            <th>Rate (%)</th>
                            <th class="hideexport">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modelAdd" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <form action="#">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?= display('add_tax_slab') ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                      <label for="txtAddMin">Minimum Amount</label>
                      <input type="text" class="form-control currency" name="min" id="txtAddMin" placeholder="Minimum Amount">
                    </div>
                    <div class="form-group">
                      <label for="txtAddMin">Maximum Amount</label>
                      <input type="text" class="form-control currency" name="max" id="txtAddMax" placeholder="Maximum Amount">
                    </div>
                    <div class="form-group">
                      <label for="txtAddRate">Fixed Tax</label>
                      <input type="text" class="form-control currency" name="fixed" id="txtAddFixed" placeholder="Fixed Rate">
                    </div>
                    <div class="form-group">
                      <label for="txtAddRate">Rate (%)</label>
                      <input type="text" class="form-control rate" name="rate" id="txtAddRate" placeholder="Rate (%)">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="modal fade" id="modelEdit" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <form action="#">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?= display('edit_tax_slab') ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" class="form-control" value="">
                    <div class="form-group">
                        <label for="txtEditMin">Minimum Amount</label>
                        <input type="text" class="form-control currency" name="min" id="txtEditMin" placeholder="Minimum Amount">
                    </div>
                    <div class="form-group">
                        <label for="txtEditMin">Maximum Amount</label>
                        <input type="text" class="form-control currency" name="max" id="txtEditMax" placeholder="Maximum Amount">
                    </div>
                    <div class="form-group">
                      <label for="txtEditFixed">Fixed Tax</label>
                      <input type="text" class="form-control currency" name="fixed" id="txtEditFixed" placeholder="Fixed Rate">
                    </div>
                    <div class="form-group">
                        <label for="txtEditRate">Rate (%)</label>
                        <input type="text" class="form-control rate" name="rate" id="txtEditRate" placeholder="Rate (%)">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({}, window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'POST',
                beforeSend: function(){}
            },
            columns: [
                {
                    'data': 'min',
                },
                {
                    'data': 'max',
                },
                {
                    'data': 'fixed',
                },
                {
                    'data': 'rate',
                },
                {
                    'data': 'action',
                    'sortable': false
                },
            ],
            "order": [[ 3, "asc" ]]
        }))
        $('.currency').inputmask({
            alias: 'numeric',
            groupSeparator: ',',
            digitsOptional: true,
        })
        $('.rate').inputmask({
            alias: 'numeric',
            groupSeparator: ',',
            digitsOptional: true,
            suffix: ' %'
        })
    });
    $('.modal form').on('submit', function(e) {
        e.preventDefault();
        var $form = $(this)
        var $modal = $form.closest('.modal')
        myajax({
            type: "POST",
            url: "<?= base_url() ?>payroll/tax/action",
            data: $form.serialize(),
            beforeSend: function() {
                $modal.find('span.error').remove();
            },
            success: function (res) {
                if(res.success) {
                    Swal.fire(
                        'Success!',
                        res.success,
                        'success'
                    )
                    $form.trigger('reset')
                    $modal.modal('hide')
                    window.dtable.ajax.reload()
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else if(res.errors) {
                    res.errors.forEach(err => {
                        $modal.find(`[name=${err[0]}]`).closest('div').append(`<span class="error">${err[1]}</span>`)
                    });
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    })
    $('table.table').on('click', '.btn-edit', function(e) {
        e.preventDefault();
        var $modal = $('#modelEdit');
        var $btn = $(this)
        myajax({
            type: "POST",
            url: "<?= base_url() ?>payroll/tax/get",
            data: {
                'id': $btn.data('id')
            },
            success: function (res) {
                if(res.success) {
                    $modal.find('[name=id]').val(res.success.id);
                    $modal.find('[name=min]').val(parseFloat(res.success.min));
                    $modal.find('[name=max]').val(parseFloat(res.success.max));
                    $modal.find('[name=fixed]').val(parseFloat(res.success.fixed));
                    $modal.find('[name=rate]').val(parseFloat(res.success.rate));
                    $modal.modal('show')
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    })
    $('table.table').on('click', '.btn-delete', function(e) {
        e.preventDefault()
        var $this = $(this);
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will remove this tax slab<br>You won't be able to revert this action!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>payroll/tax/delete",
                    data: {
                        id: $this.data('id')
                    },
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?= display('deleted') ?>!',
                                res.success,
                                'success'
                            )
                            window.dtable.ajax.reload()
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
</script>