<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <div class="panel-title">
                </div>
            </div>
            <div class="panel-body">
                <form action="#" id="generation-form">
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label for="selEmployee">Employee</label>
                            <select class="form-control" name="employee[]" id="selEmployee" multiple>
                                <?php foreach ($employees as $employee):?>
                                    <option value="<?= $employee->id ?>"><?= $employee->name ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label for="selDepartment">Department</label>
                            <select class="form-control" name="department[]" id="selDepartment" multiple>
                                <?php foreach ($departments as $department):?>
                                    <option value="<?= addslashes(strtolower($department->name)) ?>"><?= $department->name ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label for="selDiv">Division</label>
                            <select class="form-control" name="division" id="selDiv" required>
                                <?php foreach ($divisions as $division):?>
                                    <option value="<?= $division->id ?>"><?= $division->name ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-4">
                        <div class="form-group">
                            <label for="txtDate">Month</label>
                            <select class="form-control" name="month" id="selmon" required>
                                <?php foreach ($months as $month):?>
                                    <option value="<?= $month ?>" <?= date('F') == ucfirst($month) ? 'selected' : null ?>><?= ucfirst($month) ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-4">
                        <div class="form-group">
                            <label for="">Year</label>
                            <select class="form-control" name="year" id="selyr" required>
                                <?php foreach ($years as $year):?>
                                    <option value="<?= $year ?>" <?= date('Y') == $year ? 'selected' : null ?>><?= $year ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-4">
                        <div class="form-group">
                            <label for="selsts">Type</label>
                            <select class="form-control" name="status" id="selsts" required>
                                <option value="approved" selected>Approved</option>
                                <option value="pending">Pending</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div class="form-group pull-right">
                            <button type="submit" class="btn btn-primary">Generate</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<br>
<script>
    $('form#generation-form').on('submit', function (e) {
        e.preventDefault();
        var $form = $(this)
        myajax({
            type: "POST",
            url: "<?= base_url('payroll/preview/check') ?>",
            data: $form.serialize(),
            success: function (res) {
                if(res.success) {
                    location.href = res.success
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    });
</script>