<?php if($this->session->userdata('isAdmin')): ?>
<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <div class="panel-title">
                </div>
            </div>
            <div class="panel-body">
                <form action="#" id="generation-form">
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label for="selDiv">Division</label>
                            <select class="form-control" name="division" id="selDiv">
                                <option value="">Select One</option>
                                <?php foreach ($divisions as $division):?>
                                    <option value="<?= $division->id ?>"><?= $division->name ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label for="selMon">Month</label>
                            <select class="form-control" name="month" id="selMon">
                                <?php foreach ($months as $month):?>
                                    <option value="<?= $month ?>" <?= ucfirst($month) == date('F', strtotime('-1 months')) ? 'selected' : null ?>><?= ucfirst($month) ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label for="selYear">Year</label>
                            <select class="form-control" name="year" id="selYear">
                                <?php foreach ($years as $year):?>
                                    <option value="<?= $year ?>" <?= date('Y') == $year ? 'selected' : null ?>><?= $year ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div class="form-group pull-right">
                            <button type="submit" class="btn btn-primary">Generate</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<br>
<?php endif?>
<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-default thumbnail"> 
            <!-- <div class="col-md-12">
                <div class="form-group pull-right">
                    <button type="button" class="btn btn-success" id="btn-reload"><i class="fa fa-refresh" aria-hidden="true"></i> Reload Table</button>
                </div>
            </div> -->
            <div class="panel-body table-responsive">
                <table width="100%" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Year</th>
                            <th>Month</th>
                            <th>Division</th>
                            <th>HR Status</th>
                            <th>CFO Status</th>
                            <th>Generated At</th>
                            <?php if($show_payroll==true){?>
                            <th>View</th>
                            <th>Export</th>
                            <th>Bank</th>
                            <th class="hideexport">Regenerate</th>
                            <?php }?>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php if($show_payroll==true){?>
<script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({}, window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'POST',
                beforeSend: function(){}
            },
            columns: [
                {
                    'data': 'year',
                },
                {
                    'data': 'month',
                },
                {
                    'data': 'division',
                },
                {
                    'data': 'hr_status',
                },
                {
                    'data': 'cfo_status',
                },
                {
                    'data': 'updated_at',
                },
                {
                    'data': 'processed',
                    'sortable': false
                },
                {
                    'data': 'export',
                    'sortable': false
                },
                {
                    'data': 'bank',
                    'sortable': false
                },
                {
                    'data': 'regenerate',
                    'sortable': false
                },
            ],
            "order": [[ 0, "desc" ]]
        }))
        setInterval(() => {
            window.dtable.ajax.reload()
        }, 10000);
    })
</script>
<?php }else{?>
    <script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({}, window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'POST',
                beforeSend: function(){}
            },
            columns: [
                {
                    'data': 'year',
                },
                {
                    'data': 'month',
                },
                {
                    'data': 'division',
                },
                {
                    'data': 'hr_status',
                },
                {
                    'data': 'cfo_status',
                },
                {
                    'data': 'updated_at',
                },
            ],
            "order": [[ 0, "desc" ]]
        }))
        setInterval(() => {
            window.dtable.ajax.reload()
        }, 10000);
    })
</script>

<?php }?>
    
<script>
    $('table.table').on('click', '.btn-regenerate', function(e) {
        e.preventDefault();
        var id = $(this).data('id')
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will remove this payroll data and regenerate<br>You won't be able to revert this action!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, regenerate it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>payroll/regenerate",
                    data: {
                        id: id
                    },
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            )
                            window.dtable.ajax.reload()
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
    $('table.table').on('click', '.btn-approve', function(e) {
        e.preventDefault();
        var title = $(this).data('title')
        Swal.fire({
            title: `Are you sure?`,
            html: `Approve the '<strong>${title}</strong>' payroll? You won't be able to revert this action`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, approve it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>payroll/approve",
                    data: {
                        title: title,
                        id: $(this).data('id'),
                        type: $(this).data('type'),
                    },
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            )
                            window.dtable.ajax.reload()
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
    $('#generation-form').on('submit', function(e) {
        e.preventDefault()
        var $form = $(this)
        myajax({
            type: "POST",
            url: "<?= base_url() ?>payroll/generate",
            data: $form.serialize(),
            success: function (res) {
                if(res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                    window.dtable.ajax.reload()
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    })
    $('#btn-reload').on('click', function(){
        $('.se-pre-con').show()
        window.dtable.ajax.reload()
    })
</script>