<?php if($this->permission->method('budget_payroll', 'create')->access()): ?>
<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <div class="panel-title">
                </div>
            </div>
            <div class="panel-body">
                <form action="#" id="generation-form">
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label for="selDiv">Division</label>
                            <select class="form-control" name="division" id="selDiv" required>
                                <option value="">Select One</option>
                                <?php foreach ($divisions as $division):?>
                                    <option value="<?= $division->id ?>"><?= $division->name ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-4">
                        <div class="form-group">
                        <label for="txtDate">Start Date</label>
                        <input type="text" class="form-control datepicker" name="start" required>
                        </div>
                    </div>
                    <div class="col-xs-4">
                        <div class="form-group">
                        <label for="">End Date</label>
                        <input type="text" class="form-control datepicker" name="end" required>
                        </div>
                    </div>
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label for="selEmployee">Employee</label>
                            <select class="form-control" name="employee[]" id="selEmployee" multiple>
                                <option value="all" selected>All</option>
                                <?php foreach ($employees as $employee):?>
                                    <option value="<?= $employee->id ?>"><?= sprintf('%s %s (%s)', $employee->first_name, $employee->last_name, $employee->hrm_id) ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                        <div class="form-group">
                            <label for="selDepartment">Department</label>
                            <select class="form-control" name="department[]" id="selDepartment" multiple>
                                <option value="all" selected>All</option>
                                <?php foreach ($departments as $department):?>
                                    <option value="<?= $department->id ?>"><?= $department->name ?></option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div class="form-group pull-right">
                            <button type="submit" class="btn btn-primary">Generate</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<br>
<?php endif?>
<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-default thumbnail"> 
            <div class="col-md-12">
                <div class="form-group pull-right">
                    <button type="button" class="btn btn-success" id="btn-reload"><i class="fa fa-refresh" aria-hidden="true"></i> Reload Table</button>
                </div>
            </div>
            <div class="panel-body table-responsive">
                <table width="100%" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Division</th>
                            <th>Start</th>
                            <th>End</th>
                            <th>Generated At</th>
                            <th>Status</th>
                            <?php if($show_payroll==true){?>
                            <th class="hideexport">Export</th>
                            <th class="hideexport">Regenerate</th>
                            <!-- <th class="hideexport">Actions</th> -->
                            <?php }?>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php if($show_payroll==true){?>
<script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({}, window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'POST',
                beforeSend: function(){}
            },
            columns: [
                {
                    'data': 'division',
                },
                {
                    'data': 'start',
                },
                {
                    'data': 'end',
                },
                {
                    'data': 'updated_at',
                },
                {
                    'data': 'processed',
                    'sortable': false
                },
                {
                    'data': 'export',
                    'sortable': false
                },
                {
                    'data': 'regenerate',
                    'sortable': false
                },
                // {
                //     'data': 'action',
                //     'sortable': false
                // },
            ],
            "order": [[ 4, "desc" ]]
        }))
        setInterval(() => {
            window.dtable.ajax.reload()
        }, 8000);
    })
</script>
<?php }else{?>
    <script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({}, window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'POST',
                beforeSend: function(){}
            },
            columns: [
                {
                    'data': 'division',
                },
                {
                    'data': 'start',
                },
                {
                    'data': 'end',
                },
                {
                    'data': 'updated_at',
                },
                {
                    'data': 'processed',
                    'sortable': false
                },
            ],
            "order": [[ 4, "desc" ]]
        }))
        setInterval(() => {
            window.dtable.ajax.reload()
        }, 8000);
    })
</script>
<?php }?>
<script>    
    $('table.table').on('click', '.btn-regenerate', function(e) {
        e.preventDefault();
        var id = $(this).data('id')
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will remove this payroll data and regenerate<br>You won't be able to revert this action!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, regenerate it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>payroll/regenerate",
                    data: {
                        id: id
                    },
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            )
                            window.dtable.ajax.reload()
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
    $('table.table').on('click', '.btn-delete', function(e) {
        e.preventDefault()
        $this = $(this);
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will remove all data of this budget<br>You won't be able to revert this action!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>payroll/budget/delete",
                    data: {
                        id: $this.data('id')
                    },
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?= display('deleted') ?>!',
                                res.success,
                                'success'
                            )
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        } 
                    }
                });
            }
        })
    })
    $('#generation-form').on('submit', function(e) {
        e.preventDefault()
        var $form = $(this)
        myajax({
            type: "POST",
            url: "<?= base_url() ?>payroll/budget/generate",
            data: $form.serialize(),
            success: function (res) {
                if(res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                    window.dtable.ajax.reload()
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    })
    $('#btn-reload').on('click', function(){
        $('.se-pre-con').show()
        window.dtable.ajax.reload()
    })
</script>