<?php
class Payroll_ajax_model extends CI_Model
{
    private function query($orWhere = [], $p_type = 'payroll')
    {
        $this->db->select('payroll.*, divisions.name as division');
        $this->db->from('payroll');
        $this->db->join('divisions', 'payroll.division_id=divisions.id', 'left');

        $roles = array_intersect($this->session->roles,[20,23,26]);

        if(empty($roles) && !$this->session->isAdmin):
        $this->db->where('divisions.id',$this->session->division_id);
        endif;

        $this->db->where('type', $p_type);

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
    }
    public function countAllRows($type = 'pending', $cfo_approved = false, $p_type = 'payroll')
    {
        if ($cfo_approved) {
            $this->db->where('cfo_status', $type);
        }
        return $this->db->where(['hr_status' => $type, 'type' => $p_type])->count_all_results('payroll');
    }
    public function countDatatable($orWhere = [], $type = 'pending', $cfo_approved = false, $p_type = 'payroll')
    {
        $this->query($orWhere, $p_type);
        if ($cfo_approved) {
            $this->db->where('cfo_status', $type);
        }
        return $this->db->where('hr_status', $type)->count_all_results();
    }
    public function getDatatable($post, $orWhere = [], $type = 'pending', $cfo_approved = false, $p_type = 'payroll')
    {
        $this->query($orWhere, $p_type);
        if ($cfo_approved) {
            $this->db->where('cfo_status', $type);
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        $this->db->order_by('id', 'desc');
        return $this->db->where('hr_status', $type)->get()->result_array();
    }
}
