<?php
class Tax extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'tax_model' => 'taxes',
        ]);
    }
    public function slabs()
    {
        $this->permission->method('tax_slabs', 'read')->redirect();
        if ($this->input->post()) {
            $this->datatable();return;
        }
        $data['title'] = display('tax_slabs');
        $data['module'] = "payroll";
        $data['page'] = "tax/tax_slabs";
        echo Modules::run('template/layout', $data);
    }
    public function get()
    {
        $this->permission->method('tax_slabs', 'read')->redirect();
        if ($this->input->post('id')) {
            $rec = $this->taxes->get($this->input->post('id'));
            if ($rec) {
                sendJson(['success' => $rec]);
            } else {
                sendJson(['error' => 'Unable to find data for this record']);
            }
        }
        sendJson(['error' => 'Unknown request']);
    }
    public function action()
    {
        if (!$this->permission->method('tax_slabs', 'create')->access() && !$this->permission->method('tax_slabs', 'update')->access()) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        foreach ($_POST as $key => $value) {
            $_POST[$key] = preg_replace('#[^\d\.]+#', '', $_POST[$key]);
        }
        $rules_config = array(
            array(
                'field' => 'min',
                'label' => 'Minimum Amount',
                'rules' => 'trim|required|numeric|greater_than_equal_to[0]|less_than[1000000000000000000]',
            ),
            array(
                'field' => 'max',
                'label' => 'Maximum Amount',
                'rules' => 'trim|required|numeric|greater_than_equal_to[0]|less_than[1000000000000000000]',
            ),
            array(
                'field' => 'fixed',
                'label' => 'Fixed Rate',
                'rules' => 'trim|required|numeric|greater_than_equal_to[0]|less_than[1000000000000000000]',
            ),
            array(
                'field' => 'rate',
                'label' => 'Rate',
                'rules' => 'trim|required|numeric|greater_than_equal_to[0]|less_than[1000]',
            ),
        );
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === false) {
            $errors = [];
            foreach ($rules_config as $value) {
                $has_error = form_error($value['field']);
                if ($has_error) {
                    $errors[] = [$value['field'], $has_error];
                }
            }
            sendJson(['errors' => $errors]);
        }
        $existing_bracket = $this->taxes->get_slab($this->input->post('min'), $this->input->post('max'), $_POST['id'] ?? 0);
        if ($this->input->post('min') > $this->input->post('max')) {
            sendJson(['errors' => [['max', 'Max value cannot be less than min']]]);
        }
        if ($existing_bracket) {
            sendJson(['error' => sprintf('Tax bracket already exists with rate %s%% (%s, %s)', $existing_bracket->rate, number_format($existing_bracket->min, 2), number_format($existing_bracket->max, 2))]);
        }
        $res = false;
        if (!$this->input->post('id')) {
            if (!$this->permission->method('tax_slabs', 'create')->access()) {
                sendJson(['error' => 'You don\'t have permission to perform this action']);
            }
            $res = $this->taxes->add($this->input->post());
        } else {
            if (!$this->permission->method('tax_slabs', 'update')->access()) {
                sendJson(['error' => 'You don\'t have permission to perform this action']);
            }
            $res = $this->taxes->update($this->input->post());
        }
        if ($res) {
            sendJson(['success' => 'Tax bracket saved successfully']);
        } else {
            sendJson(['error' => 'Unable to save tax bracket, try again']);
        }
    }
    public function delete()
    {
        if (!$this->permission->method('tax_slabs', 'delete')->access()) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        if ($this->input->post('id')) {
            if ($this->taxes->delete($this->input->post('id'))) {
                sendJson(['success' => 'Slab deleted successfully']);
            } else {
                sendJson(['error' => 'Unable to delete slab, try again later']);
            }
        }
        sendJson(['error' => 'Invalid request']);
    }
    private function datatable()
    {
        $search_arr = [];
        $search_columns = [
            'min',
            'max',
            'rate',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->taxes->countAllRows();
        $out_arr["recordsFiltered"] = $this->taxes->countDatatable($search_arr);
        $rows = $this->taxes->getDatatable($this->input->post(), $search_arr);
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'min':
                    case 'max':
                    case 'fixed':{
                            $tdData = number_format($rec[$col['data']], 2);
                            break;
                        }
                    case 'rate':{
                            $tdData = sprintf('%g %%', $rec[$col['data']]);
                            break;
                        }
                    case 'action':{
                            $btns = [];

                            if ($this->permission->method('tax_slabs', 'update')->access()) {
                                $btns[] = '<button  class="btn btn-xs btn-success btn-edit" data-id="' . $rec['id'] . '"><i class="fa fa-pencil"></i></button>';
                            }
                            if ($this->permission->method('tax_slabs', 'delete')->access()) {
                                $btns[] = '<a href="#" data-id="' . $rec['id'] . '" class="btn btn-xs btn-danger btn-delete" data-id="' . $rec['id'] . '" style="margin-left:3px"><i class="fa fa-close"></i></a>';
                            }
                            if (!$btns) {
                                $tdData = '';
                                break;
                            }
                            $tdData .= implode('', $btns);
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
}
