<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Payslips extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'payroll_ajax_model' => 'payroll_ajax',
            'payslip_model' => 'payslip',
        ]);
    }
    function list() {
        $this->permission->method('salaryslips', 'read')->redirect();
        $interval = 30; $current_time = date('Y-m-d H:i:s');
        $show_payroll = $this->db->order_by('created_at','desc')
            ->group_start()->where('user_id',172)->or_where('user_id',115)->or_where('user_id',2994)->group_end()
            ->where('is_super_visor',1)
            // ->where("created_at >= DATE_SUB('$current_time', INTERVAL $interval MINUTE)")
            ->where("created_at <= '$current_time'")
            ->get('login_verify')->num_rows();
        if ($this->input->post()) {
            $this->get_approved_datatable($show_payroll);return;
        }
        $data['divisions'] = $this->db->select('id, name')->order_by('name')->get('divisions')->result();
        $data['months'] = [
            'january',
            'february',
            'march',
            'april',
            'may',
            'june',
            'july',
            'august',
            'september',
            'october',
            'november',
            'december',
        ];
        $year = date('Y');
        $data['years'] = range($year - 10, $year + 10);
        $data['title'] = display('salaryslips');
        $data['module'] = "payroll";
        $data['show_payroll'] = $show_payroll;
        $data['page'] = "payslip/list";
        echo Modules::run('template/layout', $data);
    }
    public function slips($id)
    {
        $this->permission->method('salaryslips', 'read')->redirect();
        $data['slips'] = $this->payslip->get_slips($id);

        $data['title'] = display('salaryslips');
        $data['module'] = "payroll";
        $data['page'] = "payslip/slips";
        echo Modules::run('template/layout', $data);
    }
    public function generate($id)
    {
        $this->permission->method('salaryslips', 'create')->redirect();
        if ($this->payslip->generate($id)) {
            $this->session->set_flashdata('exception', 'Slips are being generated for sending');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->session->set_flashdata('exception', 'Unable to generate slips, try again');
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function view($payroll_id, $employee_id)
    {
        // if(!endsWith($_SERVER['HTTP_REFERER'], 'employee/Employees/cv')){
        // $this->permission->method('salaryslips', 'read')->redirect();
        // }
        if($employee_id!==$this->session->employee_id){
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->payslip->process_slip($payroll_id, $employee_id, false);
    }
    private function get_approved_datatable($show_payroll=false)
    {
        $search_arr = [];
        $search_columns = [
            'payroll.id',
            'payroll.month',
            'payroll.year',
            'divisions.name',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        }
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->payroll_ajax->countAllRows('approved', true);
        $out_arr["recordsFiltered"] = $this->payroll_ajax->countDatatable($search_arr, 'approved', true);
        $rows = $this->payroll_ajax->getDatatable($this->input->post(), $search_arr, 'approved', true);

        foreach ($rows as $index => $rec) {
            $status = $this->payslip->get_status($rec['id']);
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'month':{
                            $tdData = ucfirst($rec[$col['data']]);
                            break;
                        }
                    case 'status':{
                            if (in_array('pending', $status['slip_status'])) {
                                $tdData = 'Waiting for 10th of month';
                            } elseif (in_array('generated', $status['slip_status'])) {
                                $tdData = 'Generating slips to send...';
                            } elseif (in_array('failed', $status['slip_status']) || in_array('failed', $status['email_status'])) {
                                $tdData = 'Some slips were not sent';
                            } elseif (in_array('queued', $status['slip_status']) || in_array('queued', $status['email_status'])) {
                                $tdData = 'Queued for sending';
                            } elseif (in_array('sent', $status['email_status'])) {
                                $tdData = 'All slips sent to employee emails';
                            }
                            break;
                        }
                    case 'action':{
                            if($show_payroll==true){
                                $payroll_roles = array_intersect($this->session->roles,[20,23,26]);
                                $tdData = '';
                                if(!empty($payroll_roles) || $this->session->isAdmin){
                                $tdData .= '<div class="btn-group"><button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action <span class="caret"></span></button><ul class="dropdown-menu">';
                                $btns = [];

                                $btns[] = '<li><a href="' . base_url('payroll/payslips/slips/') . $rec['id'] . '" >View Slips</a></li>';
                                if (in_array('pending', $status['slip_status']) && $this->permission->method('salaryslips', 'create')->access()) {
                                    $btns[] = '<li><a href="' . base_url('payroll/payslips/generate/') . $rec['id'] . '" >Email All Slips Now</a></li>';
                                }

                                if (!$btns) {
                                    $tdData .= '';
                                    break;
                                }
                                if (count($btns) > 1) {
                                    array_splice($btns, 1, 0, ['<li role="separator" class="divider"></li>']);
                                }
                                $tdData .= implode('', $btns);
                                $tdData .= '</ul></div>';

                                }
                                else {

                                if(isset($this->session->employee_id) && $this->session->employee_id):
                                $tdData .= '&nbsp;<a class="btn btn-primary" target="_blank" href="'.base_url(sprintf('payroll/payslips/view/%s/%s', $rec['id'], $this->session->employee_id)).'" role="button"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                                endif;

                                }

                                break;
                            }
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
}
