<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Notification_model extends CI_Model
{
    public $hr_id;
    public function __construct()
    {
        parent::__construct();
        $dep_ids = $this->load->config('department_ids', true, true);
        $this->hr_id = $dep_ids['hr'];
    }
    public function notice_view()
    {
        return $this->db->select('*')
            ->from('notice_board')
            ->order_by('notice_id', 'desc')
            ->get()
            ->result();
    }
    public function notification_create($data = array())
    {
        return $this->db->insert('notification', $data);
    }
    public function toggle_state($userId, $notification_id, $viewed)
    {
        $notif_rec = $this->db->where([
            'user_id' => $userId,
            'notification_id' => $notification_id,
        ])->get('rel_notification_user')->row();
        if ($notif_rec) {
            return $this->db->where([
                'user_id' => $userId,
                'notification_id' => $notification_id
            ])->update('rel_notification_user', ['viewed' => $viewed]);
        } else {
            return $this->db->insert('rel_notification_user', [
                'user_id' => $userId,
                'notification_id' => $notification_id,
                'viewed' => $viewed
            ]);
        }
    }
    public function toggle_state_all($userId)
    {
        return $this->db->where([
            'user_id' => $userId,
        ])->update('rel_notification_user', ['viewed' => 1]);
    }
    public function notifications($userId, $start, $limit, $order)
    {
        $start = intval($start);
        $limit = intval($limit);
        if($limit < 0){
            $limit = 0;
        }
        $order = strtolower($order) == 'asc' ? 'ASC' : 'DESC';
        return $this->db->select('notification`.*, rel_notification_user.viewed')
        ->join('rel_notification_user', 'rel_notification_user.notification_id=notification.id', 'right')
        ->where('rel_notification_user.user_id', $userId)
        ->limit($limit, $start)
        ->order_by('notification.id', $order)
        ->get('notification')
        ->result();
    }
    public function count_notifications_datatable($userId)
    {
        return $this->db->select('notification`.*, rel_notification_user.viewed')
        ->join('rel_notification_user', 'rel_notification_user.notification_id=notification.id', 'right')
        ->where('rel_notification_user.user_id', $userId)
        ->count_all_results('notification');
    }
    public function count_unread_notification($userId)
    {
        return $this->db->select('notification`.*, rel_notification_user.viewed')
        ->join('rel_notification_user', 'rel_notification_user.notification_id=notification.id', 'right')
        ->where('rel_notification_user.user_id', $userId)
        ->where('IFNULL(rel_notification_user.viewed, 0) =', 0)
        ->count_all_results('notification');
    }
    public function notice_delete($id = null)
    {
        $this->db->trans_begin();
        $notif_rec = $this->db->where('id', $id)->get('notification')->row();
        $this->activity->log([
            'notification_deleted',
            $id,
            $notif_rec->text
        ]);
        $this->db->where('id', $id)
            ->delete('notification');
        $this->db->where('notification_id', $id)
            ->delete('rel_notification_user');
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            return false;
        } else {
            $this->db->trans_commit();
            return true;
        }
    }
    public function notification_update($data, $id)
    {
        return $this->db->where('id', $id)
            ->update("notification", $data);
    }
    public function notice_updateForm($id)
    {
        $this->db->where('notice_id', $id);
        $query = $this->db->get('notice_board');
        return $query->row();
    }
    public function details($id)
    {
        return $this->db->select('*')
            ->from('notice_board')
            ->where('notice_id', $id)
            ->get()
            ->result();
    }
}
