<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Notice_controller extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'Notice_model',
        ));
        $this->load->library('myupload');
    }
    public function notice_view()
    {
        $this->permission->method('noticeboard', 'read')->redirect();
        $data['title'] = display('noticeboard');
        $data['mang'] = $this->Notice_model->notice_view();
        $data['module'] = "noticeboard";
        $data['page'] = "notice_view";
        echo Modules::run('template/layout', $data);
    }
    public function create_notice()
    {
        $this->permission->method('noticeboard', 'read')->redirect();
        if ($this->input->post()) {
            $this->permission->method('noticeboard', 'create')->redirect();
            $this->form_validation->set_rules('notice_type', display('notice_type'), 'trim|required|max_length[50]');
            $this->form_validation->set_rules('notice_date', display('notice_date'));
            $this->form_validation->set_rules('notice_descriptiion', display('notice_descriptiion'));
            $this->form_validation->set_rules('notice_by', display('notice_by'), 'max_length[50]');
            $img = $this->myupload->do_upload(
                './application/modules/noticeboard/assets/images/',
                'notice_attachment', true);
            if ($img['status'] == 'error') {
                $this->session->set_flashdata('exception', $img['message']);
            } elseif ($this->form_validation->run() === true) {
                if ($img['status'] == 'success') {
                    $img = $img['file'];
                } else {
                    $img = null;
                }
                $notice_date = $this->input->post('notice_date', true);
                $notice_date = $notice_date ? date('Y-m-d', strtotime($notice_date)) : date('Y-m-d');
                $created_by = $this->session->userdata('id');
                $postData = [
                    'notice_descriptiion' => $this->input->post('notice_descriptiion', true),
                    'notice_date' => $notice_date,
                    'notice_type' => $this->input->post('notice_type', true),
                    'notice_by' => $this->input->post('notice_by', true),
                    'notice_attachment' => $img,
                    'created_by' => $created_by,
                ];
                if (isset($_POST['save_publish'])) {
                    $postData['status'] = 1;
                }
                $res = $this->Notice_model->notice_create($postData);
                if ($res) {
                    if (isset($_POST['save_publish'])) {
                        $this->db->trans_start();
                        $this->notify->global()->send(sprintf('New notice published "%s"', $postData['notice_type']), 'noticeboard/Notice_controller/view_details/' . $res);
                        $this->Notice_model->email($res);
                        $this->db->trans_complete();
                    }
                    $this->session->set_flashdata('message', display('successfully_created'));
                    redirect("noticeboard/Notice_controller/create_notice");
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
            }
        }
        $data['title'] = display('noticeboard');
        $data['module'] = "noticeboard"; //
        $data['mang'] = $this->Notice_model->notice_view();
        $data['file_limit'] = bytes_to_words($this->myupload->get_ini_limit());
        $data['page'] = "notice_form";
        echo Modules::run('template/layout', $data);
    }
    public function delete_notice($id = null)
    {
        $this->permission->method('noticeboard', 'delete')->redirect();
        if ($this->Notice_model->notice_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("noticeboard/Notice_controller/notice_view");
    }
    public function update_notice_form($id = null)
    {
        $this->permission->method('noticeboard', 'update')->redirect();
        $data['title'] = display('agent');
        if ($this->input->post()) {

            $this->form_validation->set_rules('notice_descriptiion', display('notice_descriptiion'), 'trim|required');
            $this->form_validation->set_rules('notice_date', display('notice_date'), 'trim|required');
            $this->form_validation->set_rules('notice_type', display('notice_type'), 'trim|required|max_length[50]');
            $this->form_validation->set_rules('notice_by', display('notice_by'), 'max_length[50]');
            $img = $this->myupload->do_upload(
                './application/modules/noticeboard/assets/images/',
                'notice_attachment', true);
            if ($img['status'] == 'error') {
                $this->session->set_flashdata('exception', $img['message']);
            } elseif ($this->form_validation->run() === true) {
                if ($img['status'] == 'success') {
                    $img = $img['file'];
                } else {
                    $img = null;
                }
                $notice_date = $this->input->post('notice_date', true);
                $notice_date = date('Y-m-d', strtotime($notice_date));
                $Data = [
                    'notice_id' => $this->input->post('notice_id', true),
                    'notice_descriptiion' => $this->input->post('notice_descriptiion', true),
                    'notice_date' => $notice_date,
                    'notice_type' => $this->input->post('notice_type', true),
                    'notice_by' => $this->input->post('notice_by', true),
                    'notice_attachment' => (!empty($img) ? $img : $this->input->post('notice_attachment')),
                ];
                if (isset($_POST['save_publish'])) {
                    $Data['status'] = 1;
                }
                if ($this->Notice_model->update_notice($Data)) {
                    if (isset($_POST['save_publish'])) {
                        $this->db->trans_start();
                        $this->notify->global()->send(sprintf('New notice published "%s"', $Data['notice_type']), 'noticeboard/Notice_controller/view_details/' . $id);
                        $this->Notice_model->email($id);
                        $this->db->trans_complete();
                    }
                    $this->session->set_flashdata('message', display('successfully_updated'));
                    redirect("noticeboard/Notice_controller/notice_view");
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
            }
        }
        $data['title'] = display('update');
        $data['data'] = $this->Notice_model->notice_updateForm($id);
        $data['module'] = "noticeboard";
        $data['file_limit'] = bytes_to_words($this->myupload->get_ini_limit());
        $data['page'] = "update_notice_form";
        echo Modules::run('template/layout', $data);
    }
    public function download()
    {
        $this->load->helper('download');
        $filepath = $this->input->get('file');
        if (file_exists($filepath)) {
            return force_download($filepath, null);
        } else {
            return false;
        }
    }
    public function view_details()
    {
        $id = $this->uri->segment(4);
        $data['title'] = display('Details');
        $data['detls'] = $this->Notice_model->notice_view($id);
        $data['module'] = "noticeboard";
        $data['page'] = "notice_datails";
        echo Modules::run('template/layout', $data);
    }
    public function change_status()
    {
        $this->permission->method('noticeboard', 'update')->redirect();
        $get = $this->input->get();
        if (isset($get['id'])) {
            $noticeboard_update = $this->Notice_model->update_notice(['notice_id' => $get['id'], 'status' => 1]);
            if (isset($noticeboard_update)) {
                $notice_rec = $this->Notice_model->details($get['id'])[0];
                $this->db->trans_start();
                $this->notify->global()->send(sprintf('New notice published "%s"', $notice_rec->notice_type), 'noticeboard/Notice_controller/view_details/' . $get['id']);
                $this->Notice_model->email($get['id']);
                $this->db->trans_complete();
                $data['status'] = 'success';
                $data['message'] = 'Notice published successfully';
            } else {
                $data['status'] = 'error';
                $data['message'] = 'Notice not publish successfully';
            }
        } else {
            $data['status'] = 'error';
            $data['message'] = 'Something went wrong';
        }
        echo json_encode($data);
    }
    public function download_notice($id)
    {
        $data['row'] = $this->Notice_model->details($id)[0];
        $data['row']->notice_descriptiion = preg_replace('#\n\r#im', '<p style="line-height: 2px;">&nbsp;</p>', $data['row']->notice_descriptiion);
        $this->load->library('pdfgenerator');
        $this->pdfgenerator->generate($this->load->view('notice_print', $data, true), $data['row']->notice_type . '.pdf');
    }
    public function unread_count()
    {
        if ($this->session->userdata('id')) {
            sendJson(['count' => $this->Notice_model->get_unread(null, 'count')]);
        }
    }
    public function mark_read($id)
    {
        if ($this->session->userdata('id')) {
            $res = $this->Notice_model->mark_read(
                $id,
                $this->session->userdata('id')
            );
            if ($res) {
                sendJson(['success' => 1]);
            }
        }
        sendJson(['error' => 1]);
    }
}
