<?php
class Logs_model extends CI_Model
{
    private $employees_data = [];
    public function get($where = [])
    {
        $rows = [];
        try {
            if (isset($where['user'])) {
                $this->db->where_in('userId', $where['user']);
            }
            if (isset($where['module'])) {
                $this->db->where_in('module', $where['module']);
            }

            $rows = $this->db
                ->select('employee_update_log.*,
            CONCAT_WS(\' \', COALESCE(employee_history.first_name, user.firstname), COALESCE(employee_history.last_name, user.lastname)) as employee,
            employee_history.hrm_id')
                ->order_by('logged', 'desc')
                ->join('user', 'user.id=employee_update_log.userId', 'left')
                ->join('employee_history', 'user.email=employee_history.email', 'left')
                ->where('logged >=', $where['from'])
                ->where('logged <=', $where['to'])
                ->get('employee_update_log')->result();
        } catch (\Throwable $e) {
            error_log($e->getMessage());
        }
        if (!empty($rows)) {
            $rows = array_map(function ($row) {
                if (strpos($row->message, 'Created') !== 0 && $row->module == 'employee' && $row->table_name == 'employee_history' && !empty($row->row_id)) {
                    $emp_rec = $this->get_employee($row->row_id);
                    $row->message = sprintf('%s of \'%s %s (%s)\'', $row->encrypted ? decrypt_employee_data([$row->field => $row->message])[$row->field] : $row->message, $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id);
                }
                $row->logged = formatted_date($row->logged, true);
                return $row;
            }, $rows);
        }
        return $rows;
    }
    public function get_users()
    {
        $users = $this->db
            ->select('user.id, CONCAT_WS(\' \', COALESCE(employee_history.first_name, user.firstname), COALESCE(employee_history.last_name, user.lastname)) as name,
        employee_history.hrm_id')
            ->join('employee_history', 'user.email=employee_history.email', 'left')
            ->order_by('firstname', 'asc')
            ->get('user')->result();

        return array_map(function ($user) {
            if ($user->hrm_id) {
                $user->name = sprintf('%s (%s)', $user->name, $user->hrm_id);
            }
            return $user;
        }, $users);
    }
    public function get_modules()
    {
        return array_column($this->db->select('module')->distinct('module')->order_by('module')->get('employee_update_log')->result(), 'module');
    }
    public function get_employee($employee_id)
    {
        if (isset($this->employees_data['E' . $employee_id])) {
            return $this->employees_data['E' . $employee_id];
        } else {
            $emp_rec = $this->db->select('first_name, last_name, hrm_id')->where('employee_id', $employee_id)->get('employee_history')->row();
            return $this->employees_data['E' . $employee_id] = $emp_rec;
        }
    }
}
