<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Logs extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->permission->method('logs', 'read')->redirect();
        $this->load->model('logs_model');
    }
    function list() {
        $this->permission->method('logs', 'read')->redirect();

        $curr_month_range = [
            'first' => date('Y-m-d', strtotime('-2 days')),
            'last' => date('Y-m-d')
        ];
        $where = [];

        if (!empty($this->input->get('user'))) {
            $where['user'] = is_array($this->input->get('user')) ? $this->input->get('user') : [$this->input->get('user')];
        }
        if (!empty($this->input->get('module'))) {
            $where['module'] = is_array($this->input->get('module')) ? $this->input->get('module') : [$this->input->get('module')];
        }

        if (empty($this->input->get('from'))) {
            $where['from'] = $curr_month_range['first'] . ' 00:00:00';
        } else {
            $where['from'] = sql_date($this->input->get('from') . ' 00:00:00', true);
        }
        if (empty($this->input->get('to'))) {
            $where['to'] = $curr_month_range['last'] . ' 23:59:59';
        } else {
            $where['to'] = sql_date($this->input->get('to') . ' 23:59:59', true);
        }

        $data['title'] = 'User Activity Logs';
        $data['module'] = 'logs';
        $data['page'] = 'list';
        $data['users'] = $this->logs_model->get_users();
        $data['modules'] = $this->logs_model->get_modules();
        $data['curr_month_range'] = $curr_month_range;

        $data['rows'] = $this->logs_model->get($where);
        echo Modules::run('template/layout', $data);
    }
}
