<style>
    .td-flex-row {
        display: flex;
        flex-direction: row;
    }
    .punch-time {
        color: #fff;
        background-color: #de4e57;
        padding: 1px 2px;
    }
</style>
<div class="row">
    <div class="col-sm-12">
        <form>
            <div class="form-group">
            <label for="selStatus"><?= display(['filter', 'by', 'status']) ?></label>
            <select class="form-control" name="status" id="selStatus" onchange="this.form.submit()">
                <option value=""></option>
                <option value="pending-supervisor" <?= $this->session->userdata('_leave_status') == 'pending-supervisor' ? 'selected' : null ?>>Awaiting Supervisor Response</option>
                <option value="approved-supervisor" <?= $this->session->userdata('_leave_status') == 'approved-supervisor' ? 'selected' : null ?>>Approved By Supervisor</option>
                <option value="denied-supervisor" <?= $this->session->userdata('_leave_status') == 'denied-supervisor' ? 'selected' : null ?>>Denied By Supervisor</option>
                <option value="pending-hr" <?= $this->session->userdata('_leave_status') == 'pending-hr' ? 'selected' : null ?>>Awaiting HR Response</option>
                <option value="approved-hr" <?= $this->session->userdata('_leave_status') == 'approved-hr' ? 'selected' : null ?>>Approved By HR</option>
                <option value="denied-hr" <?= $this->session->userdata('_leave_status') == 'denied-hr' ? 'selected' : null ?>>Denied By HR</option>
            </select>
            </div>
        </form>
    </div>
    <!--  table area -->
    <div class="col-sm-12">

        <div class="panel panel-default thumbnail"> 

            <div class="panel-body table-responsive">
                <table width="100%" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th><?php echo display('cid') ?></th>
                            <th>HRM ID</th>
                             <th><?php echo display('name') ?></th>
                             <th><?php echo display('apply_strt_date') ?></th>
                           <th><?php echo display('apply_end_date') ?></th>
                           <th><?php echo display('leave_aprv_strt_date') ?></th>
                           <th><?php echo display('leave_aprv_end_date') ?></th>
                            <th>Submitted</th>
                           <th><?php echo display('status') ?></th>
                           <th class="hideexport"><?php echo display('action') ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>  <!-- /.table-responsive -->
            </div>
        </div>
    </div>
</div>
<script>
$(function () {
    
    $('table.table').dataTable( {
            responsive: false,
            processing: true,
            serverSide: true,
            language: {
                processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span> '
            },
            ajax: {
                method: 'post',
                url: '<?= base_url('leave/Leave/getDatatable') ?>',
                beforeSend: () => {},
            },
            columns: [
                {
                    'data': 'leave_appl_id',
                }, {
                    'data': 'hrm_id',
                }, {
                    'data': 'employee_name',
                }, {
                    'data': 'apply_strt_date',
                }, {
                    'data': 'apply_end_date'
                }, {
                    'data': 'leave_aprv_strt_date'
                }, {
                    'data': 'leave_aprv_end_date'
                }, {
                    'data': 'apply_date',
                }, {
                    'data': 'hr_status',
                }, {
                    'data': 'action',
                    'sortable': false,
                    'class': 'td-flex-row'
                }
            ],
            "columnDefs": [ {
                // "targets": [3, 4, 5, 6, 7],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }
            
            } ],
            "order": [[ 0, "desc" ]]
        }, window.default_datatable_opts)
        $('table.table').on('click', '.btn-delete', function(e) {
            e.preventDefault();
            $btn = $(this)
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $('.se-pre-con').show()
                    location.href = "<?= base_url("leave/Leave/delete_application/") ?>" + $btn.data('id')
                }
            })
        })
});
</script>