<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Leave_model extends CI_Model
{
    public function viewWeekly()
    {
        return $this->db->select('weekly_holiday.*,shift.name as shift_name')->from('weekly_holiday')
            ->join('shift', 'shift.id=weekly_holiday.shift_id')
            ->order_by('weekly_holiday.wk_id', 'desc')
            ->get()
            ->result();
    }
    public function weekleave_create($data = array())
    {
        $this->activity->set_shift($data['shift_id'])->log([
            'weeklyleave_inserted',
            $data['dayname'],
        ]);
        $this->db->insert('weekly_holiday', $data);
    }
    public function weekleave_delete($id = null)
    {
        $leave_rec = $this->db->where('wk_id', $id)->get('weekly_holiday')->row();
        $this->activity->set_shift($leave_rec->shift_id)->log([
            'weeklyleave_deleted',
            $leave_rec->dayname,
        ]);
        $this->db->where('wk_id', $id)
            ->delete('weekly_holiday');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_weeklev($data = array())
    {
        $this->activity
            ->set_url('leave/Leave/create_weekleave')
            ->set_shift($data['shift_id'])
            ->log([
                'weeklyleave_updated',
                $data['dayname'],
            ]);
        return $this->db->where('wk_id', $data["wk_id"])
            ->update("weekly_holiday", $data);
    }
    public function weekleave_updateForm($id)
    {
        $this->db->where('wk_id', $id);
        $query = $this->db->get('weekly_holiday');
        return $query->row();
    }
    public function viewholiday()
    {
        $query_for_shift = $this->db->select('payroll_holiday.* , GROUP_CONCAT(shift.name) as shifts')
            ->from('payroll_holiday')
            ->join('payroll_holiday_shift_wise', 'payroll_holiday_shift_wise.payrl_holi_id=payroll_holiday.payrl_holi_id', 'right')
            ->join('shift', 'shift.id=payroll_holiday_shift_wise.shift_id', 'left')
            ->order_by('payroll_holiday.payrl_holi_id', 'desc')
            ->group_by('payroll_holiday.payrl_holi_id')
            ->get()
            ->result();
        $query_for_dept = $this->db->select('payroll_holiday.*, GROUP_CONCAT(department.department_name) as departments')
            ->from('payroll_holiday')
            ->join('payroll_holiday_department_wise', 'payroll_holiday_department_wise.payrl_holi_id=payroll_holiday.payrl_holi_id', 'right')
            ->join('department', 'department.dept_id=payroll_holiday_department_wise.dept_id', 'left')
            ->order_by('payroll_holiday.payrl_holi_id', 'desc')
            ->group_by('payroll_holiday.payrl_holi_id')
            ->get()
            ->result();

        $query_for_employee = $this->db->select('payroll_holiday.*')
        ->from('payroll_holiday')
        ->join('payroll_holiday_employee_wise', 'payroll_holiday_employee_wise.payrl_holi_id=payroll_holiday.payrl_holi_id', 'right')
        ->join('employee_history', 'employee_history.employee_id=payroll_holiday_employee_wise.employee_id', 'left')
        ->order_by('payroll_holiday.payrl_holi_id', 'desc')
        ->group_by('payroll_holiday.payrl_holi_id')
        ->get()
        ->result();

        return array_merge($query_for_shift,$query_for_dept, $query_for_employee);
    }
    public function view_shift_holiday($id = null)
    {
        if (isset($id)) {
            return $this->db->get_where('payroll_holiday_shift_wise', ['id' => $id])->result();
        } else {
            return $this->db->select("ph.holiday_name as holiday_name, GROUP_CONCAT(s.name) AS shift_name,ph.*")
                ->from('payroll_holiday_shift_wise as phsw')
                ->join('payroll_holiday as ph', 'phsw.payrl_holi_id = ph.payrl_holi_id')
                ->join('shift as s', 's.id = phsw.shift_id', 'left')
                ->order_by('ph.payrl_holi_id', 'desc')
                ->group_by('ph.payrl_holi_id')
                ->get()
                ->result();
        }
    }
    public function view_shift_holiday_calendar($id = null)
    {
        if (isset($id)) {
            return $this->db->get_where('payroll_holiday_shift_wise', ['id' => $id])->result();
        } else {
            $this->db->select("ph.holiday_name as holiday_name, GROUP_CONCAT(s.name) AS shift_name,ph.*")
                ->from('payroll_holiday_shift_wise as phsw')
                ->join('payroll_holiday as ph', 'phsw.payrl_holi_id = ph.payrl_holi_id')
                ->join('shift as s', 's.id = phsw.shift_id', 'left');
            if ($this->session->userdata('isAdmin') == 1) {
            } else {
                $this->db->where('phsw.shift_id', $this->session->userdata('shift'));
            }
            return $this->db->order_by('ph.start_date', 'asc')
                ->group_by('ph.payrl_holi_id')
                ->get()
                ->result();
        }
    }
    public function holiday_create($data)
    {
        $this->db->trans_begin();
        $res = $this->db->insert('payroll_holiday', [
            'holiday_name' => $data['holiday_name'],
            'start_date' => date('Y-m-d', strtotime($data['start_date'])),
            'end_date' => date('Y-m-d', strtotime($data['end_date'])),
            'no_of_days' => $data['no_of_days'],
            'created_by' => $this->session->userdata('id'),
            'updated_by' => $this->session->userdata('id'),
        ]);
        if ($res) {
            $res = $this->db->insert_id();
            if (array_count_values($data['shifts']) != 0) {
                foreach ($data['shifts'] as $shift_id) {
                    $this->activity
                        ->set_shift($shift_id)
                        ->log([
                            'payroll_holiday_inserted',
                            $data['holiday_name'],
                        ]);
                    $this->db->insert('payroll_holiday_shift_wise', [
                        'payrl_holi_id' => $res,
                        'shift_id' => $shift_id,
                    ]);
                }
            }
            if (array_count_values($data['departments']) != 0) {
                foreach ($data['departments'] as $dept_id) {
                    $this->activity
                        ->set_shift($dept_id)
                        ->log([
                            'payroll_holiday_inserted',
                            $data['holiday_name'],
                        ]);
                    $this->db->insert('payroll_holiday_department_wise', [
                        'payrl_holi_id' => $res,
                        'dept_id' => $dept_id,
                    ]);
                }
            }
            if (array_count_values($data['departments']) == 0 && array_count_values($data['shifts']) == 0) {
                $this->db->insert('payroll_holiday_employee_wise', [
                    'payrl_holi_id' => $res,
                    // 'dept_id' => $dept_id,
                ]);
            }
        }
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            return false;
        } else {
            $this->db->trans_commit();
            return true;
        }
    }
    public function holiday_delete($id = null, $table = null)
    {
        if (isset($table)) {
            $this->db->where('id', $id)
                ->delete($table);
        } else {
            $leave_rec = $this->db->where('payrl_holi_id', $id)->get('payroll_holiday')->row();
            $this->activity->log([
                'payroll_holiday_deleted',
                $leave_rec->holiday_name,
                $id,
            ]);
            $this->db->where('payrl_holi_id', $id)->delete('payroll_holiday');
            $this->db->where('payrl_holi_id', $id)->delete('payroll_holiday_shift_wise');
        }
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_holiday($data)
    {
        $this->db->trans_begin();
        $res = $this->db->where('payrl_holi_id', $data["payrl_holi_id"])
            ->update("payroll_holiday", [
                'holiday_name' => $data['holiday_name'],
                'start_date' => date('Y-m-d', strtotime($data['start_date'])),
                'end_date' => date('Y-m-d', strtotime($data['end_date'])),
                'no_of_days' => $data['no_of_days'],
                'updated_by' => $this->session->userdata('id'),
            ]);
        if ($res) {
            $this->activity
                ->set_url('leave/Leave/holiday_view')
                ->log([
                    'payroll_holiday_updated',
                    $data['holiday_name'],
                    $data["payrl_holi_id"],
                ]);
            $res = $data["payrl_holi_id"];
            if (array_count_values($data['shifts']) != 0) {

                $this->db->where('payrl_holi_id', $res)->delete('payroll_holiday_department_wise');
                $this->db->where('payrl_holi_id', $res)->delete('payroll_holiday_shift_wise');
                foreach ($data['shifts'] as $shift_id) {
                    $this->db->insert('payroll_holiday_shift_wise', [
                        'payrl_holi_id' => $res,
                        'shift_id' => $shift_id,
                    ]);
                }
            }
            if (array_count_values($data['departments']) != 0) {
                $this->db->where('payrl_holi_id', $res)->delete('payroll_holiday_shift_wise');
                $this->db->where('payrl_holi_id', $res)->delete('payroll_holiday_department_wise');
                foreach ($data['departments'] as $dept_id) {
                    $this->db->insert('payroll_holiday_department_wise', [
                        'payrl_holi_id' => $res,
                        'dept_id' => $dept_id,
                    ]);
                }
            }
            if (array_count_values($data['employees']) != 0) {
                $this->db->where(['payrl_holi_id' => $res, 'employee_id' => null])->delete('payroll_holiday_employee_wise');
                // if ($remove_empty_emp->employee) {
                //     # code...
                // }
                foreach ($data['employees'] as $employee_id) {
                    $check_emp_holiday = $this->db->where(['payrl_holi_id' => $res, 'employee_id' => $employee_id])->get('payroll_holiday_employee_wise')->row();
                    if (empty($check_emp_holiday)) {
                        $this->db->insert('payroll_holiday_employee_wise', [
                            'payrl_holi_id' => $res,
                            'employee_id' => $employee_id,
                        ]);
                    }
                }
            }
        }
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            return false;
        } else {
            $this->db->trans_commit();
            return true;
        }
    }
    public function holiday_updateForm($id)
    {
        $query_for_shift = $this->db->select('payroll_holiday.*, GROUP_CONCAT(shift.id) as shifts')
            ->where('payroll_holiday.payrl_holi_id', $id)
            ->join('payroll_holiday_shift_wise', 'payroll_holiday_shift_wise.payrl_holi_id=payroll_holiday.payrl_holi_id', 'right')
            ->join('shift', 'shift.id=payroll_holiday_shift_wise.shift_id', 'left')
            ->order_by('payroll_holiday.payrl_holi_id', 'desc')
            ->group_by('payroll_holiday.payrl_holi_id')
            ->get('payroll_holiday')
            ->row();

        $query_for_dept = $this->db->select('payroll_holiday.*, GROUP_CONCAT(department.dept_id) as departments')
            ->where('payroll_holiday.payrl_holi_id', $id)
            ->join('payroll_holiday_department_wise', 'payroll_holiday_department_wise.payrl_holi_id=payroll_holiday.payrl_holi_id', 'right')
            ->join('department', 'department.dept_id=payroll_holiday_department_wise.dept_id', 'left')
            ->order_by('payroll_holiday.payrl_holi_id', 'desc')
            ->group_by('payroll_holiday.payrl_holi_id')
            ->get('payroll_holiday')
            ->row();

        $query_for_employee = $this->db->select("payroll_holiday.* ,GROUP_CONCAT(DISTINCT employee_history.dept_id) as dept_id ,GROUP_CONCAT(employee_history.employee_id) as employee_list")
            ->where('payroll_holiday.payrl_holi_id', $id)
            ->join('payroll_holiday_employee_wise', 'payroll_holiday_employee_wise.payrl_holi_id=payroll_holiday.payrl_holi_id', 'right')
            ->join('employee_history', 'employee_history.employee_id=payroll_holiday_employee_wise.employee_id', 'left')
            ->order_by('payroll_holiday.payrl_holi_id', 'desc')
            ->group_by('payroll_holiday.payrl_holi_id')
            ->get('payroll_holiday')
            ->row();


            if (isset($query_for_shift->shifts)) {
                return $query_for_shift;
            }
            // if (isset($query_for_dept->departments)) {
            //     return $query_for_dept;
            // }
            if (isset($query_for_employee)) {
                return $query_for_employee;
            }

    }
    public function application_create($data = array(), $files = null)
    {
        $employee_id = 0;
        $supervisor_id = 0;
        $auto_approve_status = '';
        if ($this->session->userdata('isAdmin') == 1 || $this->session->userdata('supervisor') == 1 || $this->permission->full('leave')->access()) {
            $employee_id = $data['employee_id'];
        } else {
            $employee_id = $this->session->userdata('employee_id');
        }
        $emp_rec = null;
        if ($this->session->userdata('employee_id') == $employee_id) {
            $supervisor_id = $this->session->userdata('direct_supervisor');
        } else {
            $emp_rec = getByWhere('employee_history', 'CONCAT_WS(\' \', first_name, last_name) as fullname, hrm_id, super_visor_id as direct_supervisor', ['employee_id' => $this->input->post('employee_id')]);
            if ($emp_rec) {
                $emp_rec = $emp_rec[0];
            }
            $supervisor_id = $emp_rec->direct_supervisor;
        }
        $leave_details = $this->available_leaves($employee_id, $this->input->post('leave_type_id', true));


        $this->db->trans_start();
        $postData = [
            'employee_id' => $employee_id,
            'leave_type_id' => $this->input->post('leave_type_id', true) == 5 ? 3 : $this->input->post('leave_type_id', true) ,
            'apply_strt_date' => sql_date($this->input->post('apply_strt_date', true)),
            'apply_end_date' => sql_date($this->input->post('leave_day_type') == 'half_day' ? $this->input->post('apply_strt_date') : $this->input->post('apply_end_date', true)),
            'reason' => htmlspecialchars($this->input->post('reason', true)),
            'apply_date' => date('Y-m-d'),
            'apply_day' => $this->input->post('leave_day_type') == 'half_day' ? '0.5' : $this->input->post('apply_day', true),
            'supervisor_id' => $supervisor_id,
            'apply_hard_copy' => $files ? json_encode($files) : null,
        ];

        //AUTO APPROVAL LEAVES & ECL & NCNS

        // Status 
        // 0 is equal to ecl
        // 1 is equal to ncnc
        // 2 is equal to late arrival
        // 3 is equal to informed
        
        $number_of_days = $this->input->post('apply_day') * 2;
        $apply_strt_date = date_create($this->input->post('apply_strt_date'));
        $current_date = date_create(date('d-m-Y'));
        $interval = date_diff($apply_strt_date, $current_date);
        if ($interval->days >= $number_of_days && date('d-m-Y') < $this->input->post('apply_strt_date') && $this->input->post('leave_type_id') == 3) {
            $auto_approve_status = 'Auto-Approve';
        }
        else if(date('d-m-Y') >= $this->input->post('apply_strt_date')){
            $auto_approve_status = '';

            if ($this->input->post('attendance_type')) {
                $postData['apply_leave_status'] = $this->input->post('attendance_type');
            }
            else {
                $check_type = $this->db->select('status')->where(['employee_id' => $employee_id, 'day' => $postData['apply_strt_date']])->get('attendance_status')->row();
                if (!empty($check_type)) {
                    $postData['apply_leave_status'] = $check_type->status;
                }
                else if($this->input->post('leave_type_id') == 5){
                    $postData['apply_leave_status'] = 0;
                }
                else {
                    $postData['apply_leave_status'] = 1;
                }
            }
        }
        else if(date('d-m-Y') <= $this->input->post('apply_strt_date') && $this->input->post('leave_type_id') == 5 && empty($this->input->post('attendance_type'))){ 
            $postData['apply_leave_status'] = 0;
        }
        else if(!empty($this->input->post('attendance_type'))) {
            $postData['apply_leave_status'] = $this->input->post('attendance_type');
        }

        // else if($this->input->post('leave_type_id') == 2) {
        //     $auto_approve_status = '';
        // }
        // else {
        //     // for ecl status
        //     $auto_approve_status = 'Auto-Approve';
        //     $postData['apply_leave_status'] = 0;
        // }
        if ($this->session->userdata('isAdmin') == 1 || ($this->session->userdata('employee_id') != $employee_id && $this->session->userdata('is_hr') == 1)) {
                if (isset($data['leave_aprv_strt_date'])) {
                    $postData['leave_aprv_strt_date'] = sql_date($data['leave_aprv_strt_date']);
                    $postData['leave_aprv_end_date'] = sql_date($this->input->post('leave_day_type') == 'half_day' ? $data['leave_aprv_strt_date'] : $data['leave_aprv_end_date']);
                    $postData['num_aprv_day'] = $this->input->post('leave_day_type') == 'half_day' ? '0.5' : $data['num_aprv_day'];
                }
                else {
                    $postData['leave_aprv_strt_date'] = sql_date($this->input->post('apply_strt_date', true));
                    $postData['leave_aprv_end_date'] = sql_date($this->input->post('leave_day_type') == 'half_day' ? $data['leave_aprv_strt_date'] : $this->input->post('apply_end_date', true));
                    $postData['num_aprv_day'] = $this->input->post('leave_day_type') == 'half_day' ? '0.5' : $this->input->post('apply_day', true);
                }
            
            $postData['approve_date'] = date('Y-m-d');
            $postData['approved_by'] = !empty($data['approved_by']) ? $data['approved_by'] : ($this->session->userdata('employee_id') ?? 1);
        }
        else if($this->session->userdata('isAdmin') != 1 && $auto_approve_status == 'Auto-Approve' && $this->input->post('leave_type_id') == 3) {
            $postData['leave_aprv_strt_date'] = sql_date($this->input->post('apply_strt_date', true));
            $postData['leave_aprv_end_date'] = sql_date($this->input->post('leave_day_type') == 'half_day' ? $this->input->post('apply_strt_date') : $this->input->post('apply_end_date', true));
            $postData['num_aprv_day'] = $this->input->post('leave_day_type') == 'half_day' ? '0.5' : $this->input->post('apply_day', true);
            $postData['approve_date'] = date('Y-m-d');
            $postData['approved_by'] = 1;
        }
        $this->db->insert('leave_apply', $postData);
        $lastId = $this->db->insert_id();
        $days_data = $this->calculate_range($employee_id, $postData['apply_strt_date'], $postData['apply_end_date'], true);
        if (!$days_data['count']) {
            sendJson(['error' => 'Selected period is already off, at least one working day is required as leave']);
        }
        $applied_count = 0;
        foreach ($days_data['days'] as $day) {
            $applied_count += $this->input->post('leave_day_type') == 'half_day' ? 0.5 : 1;
            $this->db->insert('leave_applied_days', [
                'leave_appl_id' => $lastId,
                'day' => sql_date($day['day']),
                'type' => $this->input->post('leave_day_type') == 'half_day' ? 'half_day' : 'full_day',
                'applied' => 1,
            ]);
        }
        if ($applied_count > ($leave_details['quota'] - $leave_details['availed'])) {
            sendJson(['error' => sprintf('Invalid application! your applied leaves exceed available leaves.')]);
        }
        if ($this->session->userdata('isAdmin') == 1 || ($this->session->userdata('employee_id') != $employee_id && $this->session->userdata('is_hr') == 1) || $auto_approve_status == 'Auto-Approve') {
            $approved_days_data = $this->calculate_range($employee_id, $postData['leave_aprv_strt_date'], $postData['leave_aprv_end_date'], true);
            if ($approved_days_data['days']) {
                $this->db->where('leave_appl_id', $lastId)->update('leave_applied_days', [
                    'active' => 0,
                ]);
                    
                // $superviso_status = $this->session->userdata('supervisor') ? 'approved' : 'pending';

                $this->db->where('leave_appl_id', $lastId)->update('leave_apply', [
                    'hr_status' => 'approved',
                    // 'supervisor_status' =>$superviso_status,
                ]);
                $applied_count = 0;
                foreach ($approved_days_data['days'] as $day) {
                    $applied_count += $this->input->post('leave_day_type') == 'half_day' ? 0.5 : 1;
                    $this->db->insert('leave_applied_days', [
                        'leave_appl_id' => $lastId,
                        'day' => sql_date($day['day']),
                        'type' => $this->input->post('leave_day_type') == 'half_day' ? 'half_day' : 'full_day',
                    ]);
                }
                if ($applied_count > ($leave_details['quota'] - $leave_details['availed'])) {
                    sendJson(['error' => sprintf('Invalid application! your applied leaves exceed available leaves.')]);
                }
                if (date('Y', strtotime($postData['leave_aprv_strt_date'])) != date('Y')) {
                    $leave_details_year = $this->available_leaves($employee_id, $this->input->post('leave_type_id', true), date('Y', strtotime($postData['leave_aprv_strt_date'])));
                    if ($applied_count > ($leave_details_year['quota'] - $leave_details_year['availed'])) {
                        $quota_rec_current = $this->get_quota(
                            $postData['employee_id'],
                            $postData['leave_type_id']
                        );
                        $quota_rec_old = $this->get_quota(
                            $postData['employee_id'],
                            $postData['leave_type_id'],
                            date('Y', strtotime($postData['leave_aprv_strt_date']))
                        );
                        if (!$quota_rec_old) {
                            $this->db->insert('employee_leaves', [
                                'emp_id' => $postData['employee_id'],
                                'leave_type' => $postData['leave_type_id'] == 5 ? 3 : $postData['leave_type_id'],
                                'year' => date('Y', strtotime($postData['leave_aprv_strt_date'])),
                                'leave_qouta' => $applied_count,
                            ]);
                        } else {
                            $this->db->where('id', $quota_rec_old->id)->update('employee_leaves', [
                                'leave_qouta' => $quota_rec_old->leave_qouta + $applied_count,
                            ]);
                        }
                        $this->db->where('id', $quota_rec_current->id)->update('employee_leaves', [
                            'leave_qouta' => $quota_rec_current->leave_qouta - $applied_count,
                        ]);
                    }
                }
                // $this->send_email($this->get_id($lastId), 'approved');
            }
        }
        // $this->notify->department('hr')->employee([$supervisor_id, $postData['employee_id']]);
        // if ($this->session->userdata('employee_id') == $postData['employee_id']) {
        //     $this->notify->send(sprintf('%s added a leave application', $this->session->userdata('fullname')), 'leave/Leave/update_application_form/' . $lastId);
        // } else {
        //     $this->notify->send(sprintf('%s added a leave application for employee %s (%s)', $this->session->userdata('fullname'), $emp_rec->fullname, $emp_rec->hrm_id), 'leave/Leave/update_application_form/' . $lastId);
        // }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function get_subordinates($include = true, $override = false)
    {
        $this->load->model('employee/employees_model');
        return $this->employees_model->get_subordinates(null, $include, $override);
    }
    public function dropdown()
    {
        $data = [];
        if ($this->session->userdata('isAdmin') == 1 || $this->permission->full('leave')->access()) {
            $data = $this->db->select('employee_id, first_name, last_name, hrm_id, termination_date')->where_in('status', ['active','resigned'])->order_by('first_name', 'asc')->get('employee_history')->result_array();
        } elseif ($this->session->userdata('supervisor') == 1) {
            $data = $this->get_subordinates();
        } else {
            $data = $this->db->select('employee_id, first_name, last_name, hrm_id')->where('employee_history.employee_id', $this->session->userdata('employee_id'))->get('employee_history')->result_array();
        }
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                if (!isset($value['termination_date']) || empty($value['termination_date'])) {
                    $list[$value['employee_id']] = sprintf('%s %s (%s)', $value['first_name'], $value['last_name'], $value['hrm_id']);
                }
                else {
                        $termination_date=date_create($value['termination_date']);
                        $current_date=date_create(date('Y-m-d'));
                        $diff=date_diff($termination_date,$current_date);
                        if ($diff->days == 40) {
                            $list[$value['employee_id']] = sprintf('%s %s (%s)', $value['first_name'], $value['last_name'], $value['hrm_id']);
                        }
                }
                // $list[$value['employee_id']] = sprintf('%s %s (%s)', $value['first_name'], $value['last_name'], $value['hrm_id']);
            }
        }
        return $list;
    }
    public function manageleave()
    {
        $subords = [];
        if ($this->session->userdata('supervisor') == 1) {
            $subords = array_column($this->get_subordinates(true, true), 'employee_id');
        }
        $this->db->select('ap.*,p.employee_id,p.first_name,p.last_name, p.hrm_id, type.leave_type')
            ->from('leave_apply ap')
            ->join('employee_history p', 'ap.employee_id = p.employee_id', 'left')
            ->join('leave_type as type', 'ap.leave_type_id = type.leave_type_id', 'left');
        if ($this->session->userdata('isAdmin') || $this->permission->full('leave')->access()) {
        } elseif ($this->permission->method('leave_application', 'update')->access()) {
        } elseif ($this->session->userdata('supervisor') == 1 && count($subords) > 0) {
            $this->db->where_in('p.employee_id', $subords);
        } else {
            $this->db->where('p.employee_id', $this->session->userdata('employee_id'));
        }
        return $this->db->group_by('ap.leave_appl_id')
            ->order_by('ap.leave_appl_id', 'desc')
            ->get()
            ->result();
    }
    public function application_delete($id = null)
    {
        $leave_rec = $this->db->where('leave_appl_id', $id)->get('leave_apply')->row();
        $this->db->trans_start();
        $this->activity->set_employee($leave_rec->employee_id)
            ->log([
                'leave_deleted',
                $id,
            ]);
        $this->db->where('leave_appl_id', $id)->delete('leave_apply');
        $this->db->where('leave_appl_id', $id)->delete('leave_applied_days');
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function update_application($data = array(), $leave_data = null)
    {
        $this->db->trans_start();
        $leave_rec = $this->db->select('leave_appl_id, leave_type_id, employee_id')->where('leave_appl_id', $data['leave_appl_id'])->get('leave_apply')->row();
        $leave_details = $this->available_leaves($leave_rec->employee_id, $leave_rec->leave_type_id);
        $approved_days_data = $this->calculate_range($leave_rec->employee_id, $data['leave_aprv_strt_date'], $data['leave_aprv_end_date'], true);
        if ($approved_days_data['days']) {
            $this->db->where('leave_appl_id', $leave_rec->leave_appl_id)->update('leave_applied_days', [
                'active' => 0,
            ]);
            $applied_count = 0;
            foreach ($approved_days_data['days'] as $day) {
                $applied_count += ($this->input->post('leave_day_type') == 'half_day' ? 0.5 : 1);
                $this->db->insert('leave_applied_days', [
                    'leave_appl_id' => $data['leave_appl_id'],
                    'day' => sql_date($day['day']),
                    'type' => $this->input->post('leave_day_type') == 'half_day' ? 'half_day' : 'full_day',
                ]);
            }
            if ($applied_count > ($leave_details['quota'] - $leave_details['availed'])) {
                sendJson(['error' => sprintf('Invalid application! Selected days exceed available leaves.')]);
            }
            if (date('Y', strtotime($data['leave_aprv_strt_date'])) != date('Y')) {
                $leave_details_year = $this->available_leaves($leave_rec->employee_id, $data['leave_appl_id'], date('Y', strtotime($data['leave_aprv_strt_date'])));
                if ($applied_count > ($leave_details_year['quota'] - $leave_details_year['availed'])) {
                    $quota_rec_current = $this->get_quota(
                        $leave_rec->employee_id,
                        $leave_rec->leave_type_id
                    );
                    $quota_rec_old = $this->get_quota(
                        $leave_rec->employee_id,
                        $leave_rec->leave_type_id,
                        date('Y', strtotime($data['leave_aprv_strt_date']))
                    );
                    if (!$quota_rec_old) {
                        $this->db->insert('employee_leaves', [
                            'emp_id' => $leave_rec->employee_id,
                            'leave_type' => $leave_rec->leave_type_id == 5 ? 3 : $leave_rec->leave_type_id,
                            'year' => date('Y', strtotime($data['leave_aprv_strt_date'])),
                            'leave_qouta' => $applied_count,
                        ]);
                    } else {
                        $this->db->where('id', $quota_rec_old->id)->update('employee_leaves', [
                            'leave_qouta' => $quota_rec_old->leave_qouta + $applied_count,
                        ]);
                    }
                    $this->db->where('id', $quota_rec_current->id)->update('employee_leaves', [
                        'leave_qouta' => $quota_rec_current->leave_qouta - $applied_count,
                    ]);
                }
            }
        } else {
            sendJson(['error' => 'No work days found in the selected range']);
        }
        $this->db->where('leave_appl_id', $data["leave_appl_id"])->update("leave_apply", $data);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function reject_application($data = array())
    {
        return $this->db->where('leave_appl_id', $data["leave_appl_id"])->update("leave_apply", $data);
    }
    public function application_updateForm($id)
    {
        $this->db->where('leave_appl_id', $id);
        $query = $this->db->get('leave_apply');
        return $query->row();
    }
    public function get_id($id)
    {
        $query = $this->db->select('leave_apply.*, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as employee_fullname, employee_history.hrm_id, leave_type.leave_type as leave_name')
            ->join('employee_history', 'leave_apply.employee_id=employee_history.employee_id', 'left')
            ->join('leave_type', 'leave_type.leave_type_id=leave_apply.leave_type_id', 'left')
            ->get_where('leave_apply', array('leave_appl_id' => $id));
        return $query->row_array();
    }
    // insert others leave type
    public function save_leave_type($data = array())
    {
        $this->activity->log([
            'leave_type_inserted',
            $data['leave_type'],
        ]);
        return $this->db->insert('leave_type', $data);
    }
    // get all leave type for apply leave
    public function get_leave_type()
    {
        $this->db->select('*')->where('active',1);
        $this->db->from('leave_type');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->leave_type_id] = $value->leave_type;
            }
        }
        return $list;
    }
    // get all leave type
    public function get_all_leave_type()
    {
        $this->db->select('*');
        $this->db->from('leave_type');
        $query = $this->db->get();
        return $query->result();
    }
    //get leave type by leave type id
    public function get_leave_type_by_id($id)
    {
        $this->db->where('leave_type_id', $id);
        $query = $this->db->get('leave_type');
        return $query->row();
    }
    // update leave type
    public function save_update_leave_type($data = array())
    {
        $this->activity->log([
            'leave_type_updated',
            $data["leave_type"],
            $data["leave_type_id"],
        ]);
        $this->db->where('leave_type_id', $data["leave_type_id"])
            ->update('leave_type', $data);
    }
    // delete leave type by id
    public function delete_leave_type($id = null)
    {
        $leave_rec = $this->db->where('leave_type_id', $id)->get('leave_type')->row();
        $this->activity->log([
            'leave_type_deleted',
            $leave_rec->leave_type,
            $id,
        ]);
        $this->db->where('leave_type_id', $id)
            ->delete('leave_type');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function supervisorList()
    {
        return $result = $this->db->select('first_name,last_name,employee_id,hrm_id')->from('employee_history')->where('is_super_visor', 1)->get()->result();
    }
    public function get_annual_holidays($shift_ids = null)
    {
        $this->db->select('payroll_holiday.holiday_name, payroll_holiday.start_date, payroll_holiday.end_date, GROUP_CONCAT(payroll_holiday_shift_wise.shift_id) as shifts')
            ->join('payroll_holiday_shift_wise', 'payroll_holiday.payrl_holi_id=payroll_holiday_shift_wise.payrl_holi_id', 'right')
            ->group_by('payroll_holiday_shift_wise.payrl_holi_id');
        if ($shift_ids) {
            $this->db->where_in('payroll_holiday_shift_wise.shift_id', is_array($shift_ids) ? $shift_ids : [$shift_ids]);
        }
        return $this->db->get('payroll_holiday')
            ->result_array();
    }
    public function countAllRows()
    {
        $this->query();
        return $this->db->count_all_results('leave_apply');
    }
    public function query()
    {
        $post = $this->input->post();

        $subords = [];
        if ($this->session->userdata('supervisor') == 1) {
            $subords = array_column($this->get_subordinates(true, true), 'employee_id');
        }
        $this->db->select('leave_apply.*, employee_history.employee_id, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as employee_name, employee_history.hrm_id, leave_type.leave_type')
            ->join('employee_history', 'leave_apply.employee_id = employee_history.employee_id', 'left')
            ->join('leave_type', 'leave_apply.leave_type_id = leave_type.leave_type_id', 'left');
        if ($this->session->userdata('isAdmin') || $this->permission->full('leave')->access()) {
        } elseif ($this->permission->method('leave_application', 'update')->access()) {
        } elseif ($this->session->userdata('supervisor') == 1 && count($subords) > 0) {
            $this->db->where_in('employee_history.employee_id', $subords);
        } else {
            $this->db->where('employee_history.employee_id', $this->session->userdata('employee_id'));
        }
        if (isset($post['request']) && $post['request'] == 'dashboard') {
            $this->db->where(['leave_apply.hr_status' => 'pending', 'leave_apply.supervisor_status' => 'pending']);
        }
        else if($this->session->userdata('_leave_status')) {
            switch ($this->session->userdata('_leave_status')) {
                case 'pending-supervisor':{
                    $this->db->where(['supervisor_id >' => 0, 'supervisor_status' => 'pending', 'hr_status' => 'pending']);
                    break;
                }
                case 'approved-supervisor':
                case 'pending-hr':{
                    $this->db->group_start()
                    ->group_start()
                    ->where(['supervisor_id >' => 0, 'supervisor_status' => 'approved'])
                    ->group_end()
                    ->or_group_start()
                    ->where(['supervisor_id <=' => 0])
                    ->group_end()
                    ->group_end()
                    ->where(['hr_status' => 'pending']);
                    break;
                }
                case 'denied-supervisor':{
                    $this->db->where(['supervisor_status' => 'denied', 'hr_status' => 'pending']);
                    break;
                }
                case 'approved-hr':{
                    $this->db->where(['hr_status' => 'approved']);
                    break;
                }
                case 'denied-hr':{
                    $this->db->where(['hr_status' => 'denied']);
                    break;
                }
            }
        }
    }
    public function countDatatable($orWhere, $where_arr = [])
    {
        $this->query();
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $value) {
                if (strpos($value[1], '%') === false) {
                    $this->db->or_where($value[0] . ' = ', $value[1]);
                } else {
                    $this->db->or_like($value[0], $value[1], 'none', false);
                }
            }
            $this->db->group_end();
        }
        foreach ($where_arr as $where_ar) {
            $this->db->where($where_ar[0], $where_ar[1]);
        }
        return $this->db->count_all_results('leave_apply');
    }
    public function getDatatable($orWhere, $where_arr = [])
    {
        $post = $this->input->post();
        $this->query();
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $value) {
                if (strpos($value[1], '%') === false) {
                    $this->db->or_where($value[0] . ' = ', $value[1]);
                } else {
                    $this->db->or_like($value[0], $value[1], 'none', false);
                }
            }
            $this->db->group_end();
        }
        foreach ($where_arr as $where_ar) {
            $this->db->where($where_ar[0], $where_ar[1]);
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get('leave_apply')->result_array();
    }
    public function get_weekend($employee_id)
    {
        return $this->db->select('employee_history.shift as id, weekly_holiday.dayname')
            ->join('weekly_holiday', 'employee_history.shift=weekly_holiday.shift_id', 'left')
            ->where('employee_history.employee_id', $employee_id)
            ->get('employee_history')->row();
    }
    public function holiday_for_day($shift, $date)
    {
        return $this->db
            ->select('payroll_holiday.holiday_name as name')
            ->where([
                'payroll_holiday.start_date <=' => $date,
                'payroll_holiday.end_date >=' => $date,
                'payroll_holiday_shift_wise.shift_id' => $shift,
            ])
            ->join('payroll_holiday_shift_wise', 'payroll_holiday.payrl_holi_id=payroll_holiday_shift_wise.payrl_holi_id', 'left')
            ->get('payroll_holiday')
            ->row();
    }
    public function get_approved_leave($employee_id, $date)
    {
        return $this->db
            ->where([
                'employee_id' => $employee_id,
                'leave_aprv_strt_date <= ' => $date,
                'leave_aprv_end_date >= ' => $date,
                'hr_status' => 'approved',
            ])
            ->count_all_results('leave_apply');
    }
    public function get_pending_leave($employee_id, $date)
    {
       return $this->db
            ->where([
                'employee_id' => $employee_id,
                'apply_strt_date >= ' => $date,
                'apply_end_date <= ' => $date,
                'hr_status' => 'pending',
            ])
            ->count_all_results('leave_apply');
    }
    public function available_leaves($employee_id, $leave_type, $year = null)
    {
        if (!$year) {
            $year = date('Y');
        }
        if($leave_type == 5) {
            $leave_type = 3;
        }
        $employee_leave = $this->db->query(
            'CALL get_used_leaves(?, ?, ?)',
            [$leave_type, $employee_id, date('Y')]
        )->row();
        $this->db->next_result();
        $totalleave = $this->db->select('leave_qouta leave_days')->from('employee_leaves')->where(['emp_id' => $employee_id, 'leave_type' => $leave_type, 'year' => $year])->get()->row();
        
        $employe_type_department = $this->db->select('employee_history.employee_id, department.department_name, duty_type.type_name')->from('employee_history')
        ->join('department','department.dept_id = employee_history.dept_id')
        ->join('duty_type','duty_type.id = employee_history.duty_type')->where('employee_id',$employee_id)->get()->row();

        // if ($employe_type_department->type_name == 'Contractual') {
        //     // $employe_type_department->department_name == 'Software House'
        //     $current_month_leave = $this->db->select('*')->from('leave_apply')->where(['employee_id' => $employee_id, 'leave_type_id' => $leave_type, 
        //     'MONTH(apply_date)' => date('m'), 'YEAR(apply_date)' => date('Y'), 'hr_status' => 'approved'])->get()->num_rows();
        // }
        return [
            'availed' => floatval($employee_leave->lv ?? 0),
            'quota' => floatval($totalleave->leave_days ?? 0),
            'check_current_month_leave' => $current_month_leave ?? 0,
        ];
    }
    public function calculate_range($employee_id, $start, $end, $filter_holidays = false, $check_pending_leave = false )
    {
        $shift = $this->get_weekend($employee_id);
        if ($shift->id) {
            $weekend = explode(',', $shift->dayname);
            $days = date_range(
                $start,
                $end,
                '+1 day',
                'd-m-Y'
            );
            $day_labels = [];
            $day_count = 0;
            foreach ($days as $day) {

                $approved_leave = $this->get_approved_leave($employee_id, sql_date($day));
                if ($approved_leave > 0) {
                    $day_labels[] = [
                        'num' => '',
                        'day' => $day,
                        'label' => 'Paid Leave',
                    ];
                    continue;
                }
                if ($check_pending_leave) {
                    $pending_leave = $this->get_pending_leave($employee_id, sql_date($day));
                    if ($pending_leave > 0) {
                        $day_labels[] = [
                            'num' => '',
                            'day' => $day,
                            'label' => 'Already apply',
                        ];
                        continue;
                    }
                }
                $annual_holiday = $this->holiday_for_day($shift->id, sql_date($day));
                if ($annual_holiday) {
                    $day_labels[] = [
                        'num' => '',
                        'day' => $day,
                        'label' => $annual_holiday->name,
                    ];
                    continue;
                }
                $weekday = date('l', strtotime($day));
                if (in_array($weekday, $weekend)) {
                    $day_labels[] = [
                        'num' => '',
                        'day' => $day,
                        'label' => $weekday,
                    ];
                    continue;
                }
                $day_count++;
                $day_labels[] = [
                    'num' => $day_count,
                    'day' => $day,
                    'label' => null,
                ];
            }
            if ($filter_holidays) {
                $day_labels = array_filter($day_labels, function ($day_lab) {
                    return !empty($day_lab['num']);
                });
            }

            //Check Employee leave between start and end date
            $leave_available = $this->check_emp_leave_bw_sd_ed($employee_id, $start, $end);
            $calc_hours = $this->calculate_hours_bw_ed_cd($start,$end,$shift->id,$employee_id);


            return [
                'status' => 'success',
                'days' => $day_labels,
                'count' => $day_count,
                'leave_available' => $leave_available,
                'calc_hours' => $calc_hours
            ];
        }
        return [
            'status' => 'error',
            'message' => 'No shift is assigned to you, please contact HR',
        ];
    }
    public function calculate_hours_bw_ed_cd($start,$end,$shift_id,$employee_id)
    {
        $selected_date = empty($end) ? $start : $end;
        $shift_time = $this->db->select('*')->where('id',$shift_id)->get('shift')->row();

        //For Flexible_shift
        if ($shift_time->flexible_shift == 1) {
            $check_emp_attendance = $this->db->select('status, day, active, punchout_time')
            ->where([
                'uid' => $employee_id,
                'status' => 'out',
                'active' => 1
            ])
            ->order_by('day', 'desc')->get('attendance_history')->row();

            $punchout_time = date('H:i:s',strtotime($check_emp_attendance->punchout_time));

            $enddate = date('Y-m-d '.$punchout_time, strtotime($selected_date));
        }
        else {
            //For Non Flexible_shift
            $enddate = date('Y-m-d '.$shift_time->end, strtotime($selected_date));
        }
        //Add Hours If friday add 96 hours else 48 hours
        if (date('l',strtotime($selected_date)) == 'Friday') {
            $addHours = '+96 hours';
        }
        else {
            $addHours = '+48 hours'; 
        }
        $final_date = date('Y-m-d H:i:s', strtotime($enddate. $addHours));

        $day1 = strtotime($final_date);
        $day2 = strtotime(date('Y-m-d H:i:s'));

        $diffHours = round(($day1 - $day2) / 3600);
        return $diffHours;
    }
    public function check_emp_leave_bw_sd_ed($employee_id, $start, $end)
    {
        $employee = $this->db->select('dept_id')->from('employee_history')->where('employee_id', $employee_id)->get()->row();
        $employee_list = $this->db->select('employee_id')->from('employee_history')->where('dept_id', $employee->dept_id)
        ->where('status','active')
        ->where('is_super_visor',0)->get()->result();

        $data = [];
        $count = 0;
        foreach ($employee_list as $key => $emp) {
            $data[$key] = $this->db->select('leave_apply.employee_id, leave_applied_days.*')->from('leave_apply')
            ->where('leave_apply.employee_id', $emp->employee_id)
            ->join('leave_applied_days','leave_applied_days.leave_appl_id = leave_apply.leave_appl_id')
            ->where('leave_applied_days.day BETWEEN "'. sql_date($start). '" AND "'. sql_date($end). '" ')
            ->where('leave_applied_days.applied',1)
            ->group_by(['leave_apply.employee_id'])
            // ->group_by(['leave_applied_days.leave_appl_id'])
            ->get()->row();

            if (!empty($data[$key])) {
                $count++;
            }
        }
            $employee_on_leave_count = $count;
            $total_employee = count($employee_list);

            $count1 = $employee_on_leave_count / $total_employee;
            // $count2 = $count1 * 100;
            $result = number_format(($count1 * 100), 0);
            return $result;
        
    }
    public function leave_detail($leave_id, $applied = 0, $status = null)
    {
        $this->db->select('day, type')
            ->where(['leave_appl_id' => $leave_id, 'applied' => $applied]);
        if (!is_null($status)) {
            $this->db->where('active', $status);
        }
        $leave_detail = $this->db->get('leave_applied_days')->result();
        if (!$leave_detail) {
            return [];
        }
        $data = [];
        foreach ($leave_detail as $leave_dt) {
            $data[formatted_date($leave_dt->day)] = $leave_dt->type;
        }
        return $data;
    }
    public function send_email($leave, $type)
    {
        $leave = $this->get_id($leave['leave_appl_id']);
        $emp_info = $this->employee_info($leave['employee_id']);
        $days = '';
        if ($type == 'approved') {
            $days = formatted_date($leave['leave_aprv_strt_date']);
            if ($leave['leave_aprv_strt_date'] != $leave['leave_aprv_end_date']) {
                $days = sprintf('%s - %s', $days, formatted_date($leave['leave_aprv_end_date']));
            }
        } else {
            $days = formatted_date($leave['apply_strt_date']);
            if ($leave['apply_strt_date'] != $leave['apply_end_date']) {
                $days = sprintf('%s - %s', $days, formatted_date($leave['apply_end_date']));
            }
        }
        if (!empty($emp_info)) {
            $this->template_mail->config($emp_info['division_id'])
            ->_send(
                $emp_info['email'],
                null,
                sprintf('Leave Application for %s (#%s) is %s', $days, $leave['leave_appl_id'], ucfirst($type)),
                $this->load->view('leave/emails/process', ['employee' => $emp_info, 'days' => $days, 'request' => (array) $leave, 'action' => $type], true),
                $emp_info['supervisor_email']
            );
        }
    }
    public function employee_info($id)
    {
        $date = date("Y-m",strtotime("-1 month"));
        $previous_month = date("Y-m",strtotime("-1 month"));
        $current_month = date("Y-m");
        return $this->db
            ->select('eh.first_name, eh.last_name, COALESCE(eh.business_email, eh.home_email) as email, COALESCE(supervisor.business_email, supervisor.home_email) as supervisor_email, eh.division_id, d.name as division')
            ->join('divisions d', 'eh.division_id=d.id', 'left')
            ->join('employee_history supervisor', 'eh.super_visor_id=supervisor.employee_id', 'left')
            ->where('eh.employee_id', $id)
            ->where('(eh.status = "active" OR (eh.status = "resigned" AND DATE_FORMAT(eh.termination_date,"%Y-%m") BETWEEN "' .$previous_month.'" AND "'.$current_month.'"))')
            ->get('employee_history eh')->row_array();
    }
    public function get_leave_round_rows()
    {
        $recs = $this->db->query("SELECT
        `employee_history`.`employee_id`,
        `employee_leaves`.`id`,
        SUM(`leave_type`.`leave_days`) as `sanctioned_quota`,
        TIMESTAMPDIFF(
          MONTH,
          `employee_history`.`hire_date`,
          CURRENT_DATE()
        ) as tenure,
        SUM(`employee_leaves`.`leave_qouta`) as `quota`,
        IF(FLOOR(
          TIMESTAMPDIFF(
            MONTH,
            `employee_history`.`hire_date`,
            CURRENT_DATE()
          ) * (SUM(`leave_type`.`leave_days`) / 12)
        ) > SUM(`leave_type`.`leave_days`),
        SUM(`leave_type`.`leave_days`),
        FLOOR(
          TIMESTAMPDIFF(
            MONTH,
            `employee_history`.`hire_date`,
            CURRENT_DATE()
          ) * (SUM(`leave_type`.`leave_days`) / 12)
        )) as expected_quota,
        `leave_type`.`leave_type` as `leave_label`
      FROM
        `leave_type`
        LEFT JOIN `employee_leaves` ON `leave_type`.`leave_type_id` = `employee_leaves`.`leave_type` AND `employee_leaves`.`year` = YEAR(CURRENT_DATE())
        LEFT JOIN `employee_history` ON `employee_leaves`.`emp_id` = `employee_history`.`employee_id`
      WHERE
        `employee_history`.`status` = 'active'
        AND TIMESTAMPDIFF(
          MONTH,
          hire_date,
          CURRENT_DATE()
        ) <= 12
        AND `leave_type`.`leave_type` NOT LIKE '%special%' ESCAPE '!'
      GROUP BY `employee_history`.`employee_id`
      HAVING `quota` < `expected_quota`")->result();
        $employees = [];

        foreach ($recs as $rec) {
            $rec->quota = floatval($rec->quota);
            if (isset($employees[$rec->employee_id])) {
                if ($employees[$rec->employee_id]->quota > $rec->quota) {
                    $employees[$rec->employee_id] = $rec;
                }
            } else {
                $employees[$rec->employee_id] = $rec;
            }
        }
        return array_values($employees);
    }
    public function get_quota($employee_id, $leave_type, $year = null)
    {
        if (!$year) {
            $year = date('Y');
        }
        if($leave_type == 5) {
            $leave_type = 3;
        }
        return $this->db->where([
            'emp_id' => $employee_id,
            'leave_type' => $leave_type,
            'year' => $year,
        ])->get('employee_leaves')->row();
    }
}
