<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Leave extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set('Asia/Karachi');
        $this->load->model(array(
            'Leave_model', 'department/Department_model', 'attendance/Csv_model',
        ));
        $this->form_validation->CI = &$this;
        $this->form_validation->set_message('valid_date', 'Invalid date selected in the {field} field.');
        $this->form_validation->set_message('date_is_after', 'Date {field} must come after {param}.');
    }
    public function check_holiday_settings()
    {
        $get = $this->input->post();
        $data = [];
        if (!empty($get['shift_id'])) {
            if (isset($get['id'])) {
                $where = ['shift_id' => $get['shift_id'], 'wk_id!=' => $get['id']];
            } else {
                $where = ['shift_id' => $get['shift_id']];
            }
            $already_assigned = $this->db->select('shift_id')->get_where('weekly_holiday', $where)->result();
            if (count($already_assigned) > 0) {
                $data['status'] = 'error';
                $data['message'] = 'shift already assigned weekly holiday';
            } else {
                $data['status'] = 'success';
                $data['message'] = 'Shift not booked already!';
            }
        } else {
            $data['status'] = 'error';
            $data['message'] = 'something went wrong';
        }
        echo json_encode($data);
    }
    public function weekly_leave_view()
    {
        $this->permission->method('leave_application', 'read')->redirect();
        $data['title'] = display('selection');
        $data['weeklev'] = $this->Leave_model->viewWeekly();
        $data['module'] = "leave";
        $data['page'] = "weeklyleave_view";
        echo Modules::run('template/layout', $data);
    }
    public function create_weekleave()
    {
        $data['title'] = display('selectionlist');
        #-------------------------------#
        $this->form_validation->set_rules('dayname[]', display('dayname[]'), 'max_length[30]');
        if ($this->form_validation->run() === true) {
            $Specilized_category = $this->input->post('dayname');
            $shift_id = $this->input->post('shift_id');
            $data = array('dayname' => implode(",", $Specilized_category), 'shift_id' => $shift_id);
            if ($this->Leave_model->weekleave_create($data)) {
                $this->session->set_flashdata('exception', display('please_try_again'));
            } else {
                $this->session->set_flashdata('message', display('save_successfully'));
            }
            redirect("leave/Leave/create_weekleave");
        } else {
            $data['title'] = display('create');
            $data['module'] = "leave";
            $data['page'] = "weeklyform";
            $data['shift'] = $this->Department_model->shift_management_list();
            $data['weeklev'] = $this->Leave_model->viewWeekly();
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_weekleave($id = null)
    {
        $this->permission->method('leave_application', 'delete')->redirect();
        if ($this->Leave_model->weekleave_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("leave/Leave/weekly_leave_view");
    }
    public function update_weekleave_form($id = null)
    {
        $this->form_validation->set_rules('wk_id');
        $this->form_validation->set_rules('dayname[]', display('dayname'), 'max_length[30]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $Specilized_category = $this->input->post('dayname');
            $shift = $this->input->post('shift_id');
            $dataf = array('wk_id' => $this->input->post('wk_id'),
                'dayname' => implode(",", $Specilized_category), 'shift_id' => $shift,
            );
            if ($this->Leave_model->update_weeklev($dataf)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("leave/Leave/create_weekleave");
        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Leave_model->weekleave_updateForm($id);
            $data['module'] = "leave";
            $data['page'] = "update_wkleave_form";
            $data['shift'] = $this->Department_model->shift_management_list();
            echo Modules::run('template/layout', $data);
        }
    }
    public function holiday_view()
    {
        $dept_id = [13,41,50,28,29];

        $this->permission->method('leave_application', 'read')->redirect();
        $data['title'] = display('holiday');
        $data['holiday'] = $this->Leave_model->viewholiday();
        $data['shifts'] = $this->db->select('id, name')->order_by('name', 'asc')->get('shift')->result_array();
        $data['departments'] = $this->db->select('dept_id, department_name')->where_in('dept_id',$dept_id)->get('department')->result_array();
        $data['module'] = "leave";
        $data['page'] = "holiday_form";
        echo Modules::run('template/layout', $data);
    }
    public function manage_holiday()
    {
        $this->permission->method('leave_application', 'read')->redirect();
        $data['title'] = display('selection');
        $data['holiday'] = $this->Leave_model->viewholiday();
        $data['module'] = "leave";
        $data['page'] = "holiday_view";
        echo Modules::run('template/layout', $data);
    }
    public function add_shift_holiday_view($id = null)
    {
        if (isset($id)) {
            $view_shift_holiday = $this->Leave_model->view_shift_holiday($id);
            $data['id'] = $view_shift_holiday[0]->id;
            $data['shift_id'] = $view_shift_holiday[0]->shift_id;
            $data['payrl_holi_id'] = $view_shift_holiday[0]->payrl_holi_id;
            $data['start_date'] = date('d-m-Y', strtotime($view_shift_holiday[0]->start_date));
            $data['end_date'] = date('d-m-Y', strtotime($view_shift_holiday[0]->end_date));
            $data['no_of_days'] = $view_shift_holiday[0]->no_of_days;
            echo json_encode($data);
        } else {
            $data['holiday'] = $this->Leave_model->viewholiday();
            $data['shift'] = $this->Department_model->shift_management_list();
            $this->permission->method('leave_application', 'read')->redirect();
            $data['title'] = display('selection');
            $data['shift_holidays'] = $this->Leave_model->view_shift_holiday();
            $data['module'] = "leave";
            $data['page'] = "add_shift_holiday_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function create_shift_holiday()
    {
        $data['title'] = display('ab');
        #-------------------------------#
        // $this->form_validation->set_rules('shift_id',display('shift_id'),'required');
        $this->form_validation->set_rules('payrl_holi_id', display('payrl_holi_id'), 'required');
        $this->form_validation->set_rules('start_date', display('start_date'), 'required');
        $this->form_validation->set_rules('end_date', display('end_date'), 'required');
        $this->form_validation->set_rules('no_of_days', display('no_of_days'), 'required');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $start = date("Y-m-d", strtotime($this->input->post('start_date', true)));
            $end = date("Y-m-d", strtotime($this->input->post('end_date', true)));
            $postData = [
                'payrl_holi_id' => $this->input->post('payrl_holi_id', true),
                'shift_id' => $this->input->post('shift_id', true),
                'start_date' => $start,
                'end_date' => $end,
                'no_of_days' => $this->input->post('no_of_days', true),
            ];
            if (!empty($this->input->post('id'))) {
                $postData['id'] = $this->input->post('id');
                $updated = $this->Leave_model->update_holiday($postData, 'payroll_holiday_shift_wise');
                $message = display('successfully_updated');
            } else {
                $updated = $this->Leave_model->holiday_create($postData, 'payroll_holiday_shift_wise');
                $message = display('successfully_saved');
            }
            if ($updated) {
                $this->session->set_flashdata('message', $message);
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("leave/Leave/add_shift_holiday_view");
        } else {
            $data['title'] = display('create');
            $data['module'] = "leave";
            $data['page'] = "";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_shift_holiday($id)
    {
        $this->permission->module('holiday', 'delete')->redirect();
        if ($this->Leave_model->holiday_delete($id, 'payroll_holiday_shift_wise')) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("leave/Leave/add_shift_holiday_view");
    }
    public function create_holiday()
    {

        // dd($this->input->post());
        #-------------------------------#
        $this->form_validation->set_rules('holiday_name', display('holiday_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('start_date', display('start_date'), 'required');
        $this->form_validation->set_rules('end_date', display('end_date'), 'required');
        $this->form_validation->set_rules('no_of_days', display('no_of_days'));

        // if (array_count_values($this->input->post('shifts[]')) == 0) {
        //     $this->form_validation->set_rules('departments[]', 'Departments', 'required');
        // }
        // if (array_count_values($this->input->post('departments[]')) == 0) {
        //     $this->form_validation->set_rules('shifts[]', 'Shifts', 'required');
        // }

        #-------------------------------#
        if ($this->form_validation->run() === true) {
            if ($this->Leave_model->holiday_create($this->input->post())) {
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
        } else {
            $this->session->set_flashdata('exception', validation_errors());
        }
        redirect("leave/Leave/holiday_view");
    }
    public function delete_holiday($id = null)
    {
        $this->permission->module('leave', 'delete')->redirect();
        if ($this->Leave_model->holiday_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("leave/Leave/holiday_view");
    }
    public function update_holiday_form($id = null)
    {
        // dd($this->input->post());

        if ($this->input->post()) {
            $this->form_validation->set_rules('payrl_holi_id', null, 'required|max_length[11]');
            $this->form_validation->set_rules('holiday_name', display('holiday_name'), 'required|max_length[30]');
            $this->form_validation->set_rules('start_date', display('start_date'), 'required');
            $this->form_validation->set_rules('end_date', display('end_date'), 'required');
            $this->form_validation->set_rules('no_of_days', display('no_of_days'), 'required');
            // if (array_count_values($this->input->post('shifts[]')) == 0 && $this->input->post('shifts[]')) {
            //     $this->form_validation->set_rules('departments[]', 'Departments', 'required');
            // }
            // if (array_count_values($this->input->post('departments[]')) == 0 && $this->input->post('departments[]')) {
            //     $this->form_validation->set_rules('shifts[]', 'Shifts', 'required');
            // }
            // if (array_count_values($this->input->post('emp_depts[]')) == 0 && $this->input->post('emp_depts[]')) {
            //     $this->form_validation->set_rules('emp_depts[]', 'Employees Department', 'required');
            // }
            // #-------------------------------#
            if ($this->form_validation->run() === true) {
                if ($this->Leave_model->update_holiday($this->input->post())) {
                    $this->session->set_flashdata('message', display('successfully_updated'));
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
                redirect("leave/Leave/holiday_view");
            } else {
                $this->session->set_flashdata('exception', validation_errors());
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $dept_id = [13,41,50,28,29];

            $data['title'] = display('update');
            $data['data'] = $this->Leave_model->holiday_updateForm($id);
            // dd($data['data']->employee_list);
            if (isset($data['data']->shifts)) {
                
                $data['departments'] = $this->db->select('dept_id, department_name')->where_in('dept_id',$dept_id)->get('department')->result_array();
                $data['shifts'] = $this->db->select('id, name')->order_by('name', 'asc')->get('shift')->result_array();
            }
            else {
                $data['departments'] = $this->db->select('dept_id, department_name')->get('department')->result_array();
                // $data['employeelist'] = $this->Csv_model->userlist();
            }
            // dd($data);
            $data['module'] = "leave";
            $data['page'] = "update_holiday_form"; //
            echo Modules::run('template/layout', $data);
        }
    }
    public function dept_wise_employees()
    {
        $dept_ids  = $this->input->post('dept_ids');
        $employee_ids  = $this->input->post('employee_ids');
        $employeelist = $this->Csv_model->userlist($dept_ids,$employee_ids);
        echo json_encode($employeelist);
    }
    public function application()
    {
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'leave_type_id',
                    'label' => display('leave_type'),
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'apply_strt_date',
                    'label' => display('apply_strt_date'),
                    'rules' => 'trim|required|callback_valid_date',
                ),
            );
            if ($this->input->post('leave_day_type') != 'half_day') {
                $rules_config[] = array(
                    'field' => 'apply_end_date',
                    'label' => display('apply_end_date'),
                    'rules' => 'trim|required|callback_valid_date|callback_date_is_after[apply_strt_date]',
                );
            }
            if ($this->session->userdata('isAdmin') == 1 || $this->session->userdata('supervisor') == 1 || $this->permission->full('leave')->access()) {
                $rules_config[] = array(
                    'field' => 'employee_id',
                    'label' => display('employee_name'),
                    'rules' => 'trim|required',
                );
            }
            // if ($this->session->userdata('isAdmin') == 1) {
            //     $rules_config[] = array(
            //         'field' => 'approved_by',
            //         'label' => display('approved_by'),
            //         'rules' => 'trim|required',
            //     );
            //     $rules_config[] = array(
            //         'field' => 'leave_aprv_strt_date',
            //         'label' => display('leave_aprv_strt_date'),
            //         'rules' => 'trim|required|callback_valid_date',
            //     );
            //     if ($this->input->post('leave_day_type') != 'half_day') {
            //         $rules_config[] = array(
            //             'field' => 'leave_aprv_end_date',
            //             'label' => display('leave_aprv_end_date'),
            //             'rules' => 'trim|required|callback_valid_date|callback_date_is_after[leave_aprv_strt_date]',
            //         );
            //     }
            // }
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                $errors = [];
                foreach ($rules_config as $rule) {
                    $has_error = form_error($rule['field']);
                    if ($has_error) {
                        $errors[] = [$rule['field'], $has_error];
                    }
                }
                sendJson(['errors' => $errors]);
            }
            $files = null;
            if (!isEmptyArray($_FILES['attachments']['name'])) {
                $this->load->library('multiupload');
                try {
                    $res = $this->multiupload->upload('attachments', [
                        'size' => 1024,
                        'type' => ['image', 'pdf'],
                        'path' => WRITEPATH . 'leave/files/',
                    ]);
                    if ($res['status'] == 'success') {
                        $files = $res['file'];
                    } else {
                        sendJson(['error' => $res['message']]);
                    }
                } catch (\Throwable $e) {
                    log_message('error', $e->getMessage());
                    sendJson(['error' => 'Unable to upload attachments, try again later']);
                }
            }
            if ($this->Leave_model->application_create($this->input->post(), $files)) {
                sendJson(['success' => display('leave_successfully_created')]);
            } else {
                sendJson(['error' => display('please_try_again')]);
            }
        }
        $data['title'] = display('leave');
        $data['module'] = "leave"; //
        $data['type'] = $this->Leave_model->get_leave_type();
        $data['dropdown'] = $this->Leave_model->dropdown();
        $data['supr'] = $this->Leave_model->supervisorList();

        $shifts = $this->db->select('employee_id, shift')->where_in('employee_id', array_keys($data['dropdown']))->get('employee_history')->result_array();
        $data['employee_shifts'] = [];
        foreach ($shifts as $shift_rec) {
            $data['employee_shifts'][$shift_rec['employee_id']] = $shift_rec['shift'];
        }
        $weekend_arr = $this->db->get('weekly_holiday')->result_array();
        $data['weekend_arr'] = [];
        foreach ($weekend_arr as $wk_ar) {
            $data['weekend_arr'][$wk_ar['shift_id']] = $wk_ar['dayname'];
        }
        $data['annual_holidays_arr'] = $this->Leave_model->get_annual_holidays(array_column($shifts, 'shift'));

        $data['page'] = "other_leave_application_form";
        echo Modules::run('template/layout', $data);
    }
    // add others leave type form
    public function add_leave_type()
    {
        $data['title'] = display('leave_type');
        #-------------------------------#
        $this->form_validation->set_rules('leave_type', display('leave_type_name'), 'required|max_length[100]');
        // $this->form_validation->set_rules('leave_days',display('number_of_leave_days'),'max_length[30]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'leave_type' => $this->input->post('leave_type', true),
                'leave_days' => $this->input->post('leave_days', true),
            ];
            if ($this->Leave_model->save_leave_type($postData)) {
                $this->session->set_flashdata('message', display('successfully_created'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("leave/Leave/add_leave_type");
        } else {
            $data['title'] = display('leave_type');
            $data['module'] = "leave";
            $data['type'] = $this->Leave_model->get_all_leave_type();
            $data['page'] = "leave_type_form";
            echo Modules::run('template/layout', $data);
        }
    }
    // update leave type
    public function update_leave_type($id = null)
    {
        $data['title'] = display('update');
        #-------------------------------#
        $this->form_validation->set_rules('leave_type', display('leave_type_name'), 'required|max_length[100]');
        // $this->form_validation->set_rules('leave_days',display('number_of_leave_days'),'max_length[30]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'leave_type_id' => $this->input->post('leave_type_id', true),
                'leave_type' => $this->input->post('leave_type', true),
            ];
            if ($this->Leave_model->save_update_leave_type($postData)) {
                $this->session->set_flashdata('message', display('successfully_created'));
            }
            // else {
            //     $this->session->set_flashdata('exception',  display('please_try_again'));
            // }
            redirect("leave/Leave/add_leave_type");
        } else {
            $data['title'] = display('update');
            $data['module'] = "leave";
            $data['data'] = $this->Leave_model->get_leave_type_by_id($id);
            $data['page'] = "update_leave_type_form";
            echo Modules::run('template/layout', $data);
        }
    }
    // delete leave type
    public function delete_leave_type($id = null)
    {
        $this->permission->module('leave', 'delete')->redirect();
        if ($this->Leave_model->delete_leave_type($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("leave/Leave/add_leave_type");
    }
    public function delete_application($id = null)
    {
        $this->permission->module('leave', 'delete')->redirect();
        if ($this->Leave_model->application_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        // redirect("leave/Leave/application_view");
        redirect("leave/application");
    }
    public function application_view()
    {
        $this->permission->method('leave_application', 'read')->redirect();
        if($_GET['status']) {
            $this->session->set_userdata('_leave_status', $_GET['status']);
        }
        if(isset($_GET['status']) && empty($_GET['status'])){
            $this->session->unset_userdata('_leave_status', $_GET['status']);
        }
        $data['title'] = display('selection');
        $data['module'] = "leave";
        $data['page'] = "application_view";
        echo Modules::run('template/layout', $data);
    }
    public function update_application_form($id = null)
    {        
        $subordinates = array_column($this->Leave_model->get_subordinates(false, true), 'employee_id');
        $leave_rec = $this->Leave_model->get_id($id);
        if (!$leave_rec) {
            show_404();
        }
        if($this->permission->method('leave_application', 'update')->access()) {
        } elseif ($subordinates && in_array($leave_rec['employee_id'], $subordinates)) {
        } elseif ($this->session->userdata('employee_id') == $leave_rec['employee_id']) {
        } else {
            show_404();
        }
        if ($this->input->post()) {
            if ($this->input->post('action') == 'reject') {
                $this->db->trans_start();
                $postData = [
                    'leave_appl_id' => $id,
                    'leave_aprv_strt_date' => null,
                    'leave_aprv_end_date' => null,
                    'num_aprv_day' => 0,
                    'approve_date' => null,
                    'approved_by' => 0,
                ];
                $emp_rec = getByWhere('employee_history', 'CONCAT_WS(\' \', first_name, last_name) as fullname, hrm_id, super_visor_id as direct_supervisor', ['employee_id' => $leave_rec['employee_id']]);
                if ($emp_rec) {
                    $emp_rec = $emp_rec[0];
                }
                if ($this->permission->method('leave_application', 'update')->access()) {
                    $postData['hr_status'] = 'denied';
                    $postData['hr_approver'] = $this->session->userdata('employee_id');
                    $this->notify
                        ->employee($leave_rec['supervisor_id'])
                        ->send(sprintf('HR rejected leave application #%s of %s', $id, $emp_rec->fullname), 'leave/Leave/update_application_form/' . $id);
                    $this->notify
                        ->employee($leave_rec['employee_id'])
                        // ->send(sprintf('HR rejected your leave application #%s', $id), 'leave/Leave/application_view');
                        ->send(sprintf('HR rejected your leave application #%s', $id), 'leave/application');
                    $this->activity
                        ->set_employee($leave_rec['employee_id'])
                        ->log([
                            'leave_denied',
                            $id,
                            'HR',
                        ]);
                } elseif (in_array($leave_rec['employee_id'], $subordinates)) {
                    $postData['supervisor_status'] = 'denied';
                    $this->notify
                        ->department('hr')
                        ->send(sprintf('Supervisor %s rejected leave application #%s of %s', $this->session->userdata('fullname'), $id, $emp_rec->fullname), 'leave/Leave/update_application_form/' . $id);
                    $this->notify
                        ->employee($leave_rec['employee_id'])
                        // ->send(sprintf('Supervisor %s rejected your leave application #%s', $this->session->userdata('fullname'), $id), 'leave/Leave/application_view');
                        ->send(sprintf('Supervisor %s rejected your leave application #%s', $this->session->userdata('fullname'), $id), 'leave/application');
                    $this->activity
                        ->set_employee($leave_rec['employee_id'])
                        ->log([
                            'leave_denied',
                            $id,
                            'supervisor',
                        ]);
                } else {
                    sendJson(['error' => display('please_try_again')]);
                }
                $this->Leave_model->reject_application($postData);
                $this->db->trans_complete();
                if ($this->db->trans_status()) {
                    if($postData['hr_status']) {
                        $this->Leave_model->send_email($leave_rec, 'rejected');
                    }
                    $this->session->set_flashdata('message', display('successfully_updated'));
                    // sendJson(['success' => display('successfully_updated'), 'redirect' => base_url('leave/application_view')]);
                    sendJson(['success' => display('successfully_updated'), 'redirect' => base_url('leave/application')]);
                }
                sendJson(['error' => display('please_try_again')]);
            } elseif ($this->input->post('action') == 'approve') {

                $rules_config = array(
                    array(
                        'field' => 'leave_aprv_strt_date',
                        'label' => display('leave_aprv_strt_date'),
                        'rules' => 'trim|required|callback_valid_date',
                    ),
                );
                if ($this->input->post('leave_day_type') != 'half_day') {
                    $rules_config[] = array(
                        'field' => 'leave_aprv_end_date',
                        'label' => display('leave_aprv_end_date'),
                        'rules' => 'trim|required|callback_valid_date|callback_date_is_after[leave_aprv_strt_date]',
                    );
                }
                if ($this->session->userdata('isAdmin') == 1) {
                    $rules_config[] = array(
                        'field' => 'approved_by',
                        'label' => display('approved_by'),
                        'rules' => 'trim|required|is_natural',
                    );
                }
                $this->form_validation->set_rules($rules_config);
                if ($this->form_validation->run() === false) {
                    $errors = [];
                    foreach ($rules_config as $rule) {
                        $has_error = form_error($rule['field']);
                        if ($has_error) {
                            $errors[] = [$rule['field'], $has_error];
                        }
                    }
                    sendJson(['errors' => $errors]);
                }
                $postData = [
                    'leave_appl_id' => $id,
                    'leave_aprv_strt_date' => sql_date($this->input->post('leave_aprv_strt_date')),
                    'leave_aprv_end_date' => sql_date($this->input->post('leave_day_type') == 'half_day' ? $this->input->post('leave_aprv_strt_date') : $this->input->post('leave_aprv_end_date')),
                    'num_aprv_day' => $this->input->post('leave_day_type') == 'half_day' ? '0.5' : (!empty($this->input->post('num_aprv_day', true)) ? $this->input->post('num_aprv_day', true) : 0),
                ];
                $emp_rec = getByWhere('employee_history', 'CONCAT_WS(\' \', first_name, last_name) as fullname, hrm_id, super_visor_id as direct_supervisor', ['employee_id' => $leave_rec['employee_id']]);
                if ($emp_rec) {
                    $emp_rec = $emp_rec[0];
                }
                if ($this->permission->method('leave_application', 'update')->access()) {
                    $postData['approve_date'] = date('Y-m-d');
                    $postData['approved_by'] = $this->session->userdata('isAdmin') == 1 ? $this->input->post('approved_by', true) : $this->session->userdata('employee_id');
                    $postData['hr_status'] = 'approved';
                    $postData['hr_approver'] = $this->session->userdata('employee_id');
                    $this->notify
                        ->employee($leave_rec['supervisor_id'])
                        ->send(sprintf('HR approved leave application #%s of %s', $id, $emp_rec->fullname), 'leave/Leave/update_application_form/' . $id);
                    $this->notify
                        ->employee($leave_rec['employee_id'])
                        // ->send(sprintf('HR approved your leave application #%s', $id), 'leave/Leave/application_view');
                        ->send(sprintf('HR approved your leave application #%s', $id), 'leave/application');
                    $this->activity
                        ->set_employee($leave_rec['employee_id'])
                        ->log([
                            'leave_approved',
                            $id,
                            'HR',
                        ]);
                } elseif (in_array($leave_rec['employee_id'], $subordinates)) {
                    $postData['approve_date'] = date('Y-m-d');
                    $postData['approved_by'] = $this->session->userdata('isAdmin') == 1 ? $this->input->post('approved_by', true) : $this->session->userdata('employee_id');
                    $postData['hr_status'] = 'approved';
                    $postData['hr_approver'] = 0;
                    $postData['supervisor_status'] = 'approved';
                    $this->notify
                        ->department('hr')
                        ->send(sprintf('Supervisor %s approved leave application #%s of %s', $this->session->userdata('fullname'), $id, $emp_rec->fullname), 'leave/Leave/update_application_form/' . $id);
                    $this->notify
                        ->employee($leave_rec['employee_id'])
                        // ->send(sprintf('Supervisor %s approved your leave application #%s', $this->session->userdata('fullname'), $id), 'leave/Leave/application_view');
                        ->send(sprintf('Supervisor %s approved your leave application #%s', $this->session->userdata('fullname'), $id), 'leave/application');
                    $this->activity
                        ->set_employee($leave_rec['employee_id'])
                        ->log([
                            'leave_approved',
                            $id,
                            'supervisor',
                        ]);
                } else {
                    log_message('error', 'Invalid role of user updating application. User ID: ' . $this->session->userdata('id'));
                    sendJson(['error' => display('please_try_again')]);
                }
                if ($this->Leave_model->update_application($postData, $_POST['leave_data']['approved'])) {
                    if($postData['hr_status']) {
                        $this->Leave_model->send_email($leave_rec, 'approved');
                    }
                    // sendJson(['success' => display('successfully_updated'), 'redirect' => base_url('leave/application_view')]);
                    sendJson(['success' => display('successfully_updated'), 'redirect' => base_url('leave/application')]);
                }
                // sendJson(['error' => display('please_try_again'), 'redirect' => base_url('leave/application_view')]);
                sendJson(['error' => display('please_try_again'), 'redirect' => base_url('leave/application')]);
            }
            log_message('error', 'Invalid action on update_application_form, neither approve nor deny');
            sendJson(['error' => display('please_try_again')]);
        }
        $data['title'] = display('update');
        $data['dropdown'] = $this->Leave_model->dropdown();
        $data['data'] = $leave_rec;
        $data['type'] = $this->Leave_model->get_leave_type();
        $data['subordinates'] = $subordinates;
        $data['supr'] = $this->Leave_model->supervisorList();
        $data['applied_days'] = $this->Leave_model->calculate_range($leave_rec['employee_id'], $leave_rec['apply_strt_date'], $leave_rec['apply_end_date'], false, true);
        $data['applied_details'] = $this->Leave_model->leave_detail($id, 1);
        if ($leave_rec['num_aprv_day']) {
            $data['approved_days'] = $this->Leave_model->calculate_range($leave_rec['employee_id'], $leave_rec['leave_aprv_strt_date'], $leave_rec['leave_aprv_end_date'], false, true);
            $data['approved_details'] = $this->Leave_model->leave_detail($id, 0, 1);
        }
        $data['leaves_stats'] = $this->Leave_model->available_leaves($leave_rec['employee_id'], $leave_rec['leave_type_id']);
        $data['module'] = "leave";
        $data['page'] = "update_application_form"; //
        echo Modules::run('template/layout', $data);
    }
    // Leave free for employee
    public function free_leave()
    {
        $data = [];
        if ($this->input->post('employee_id') && $this->input->post('leave_type')) {
            $employee_id = $this->input->post('employee_id');
            $type = $this->input->post('leave_type');
            $leaves = $this->Leave_model->available_leaves($employee_id, $type);
            $data = array(
                'enjoy' => $leaves['availed'],
                'due' => $leaves['quota'],
                'check_current_month_leave' => $leaves['check_current_month_leave'],
            );
        }
        sendJson($data);
    }
    public function getDatatable()
    {
        $where_arr = [];
        $search_arr = [];
        $search_columns = [
            'leave_apply.leave_appl_id',
            'CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name)',
            'employee_history.hrm_id',
            'leave_type.leave_type',
            'leave_apply.num_aprv_day',
            'leave_apply.apply_strt_date',
            'leave_apply.apply_end_date',
            'leave_apply.leave_aprv_strt_date',
            'leave_apply.leave_aprv_end_date',
            'leave_apply.apply_date',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            $originalSearchVal = $searchVal;
            foreach ($search_columns as $value) {
                if (convert_excel_date($searchVal)) {
                    $search_arr[] = [$value, convert_excel_date($searchVal)];
                } else {
                    $searchVal = preg_replace('@\s+@', '%', $searchVal);
                    $searchVal .= '%';
                    $search_arr[] = [$value, $searchVal];
                }
            }
            if (preg_match('#\bsupervisor\b#i', $originalSearchVal) === 1) {
                if (preg_match('#\bawaiting\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['leave_apply.supervisor_status', 'pending'];
                }
                if (preg_match('#\bapproved\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['leave_apply.supervisor_status', 'approved'];
                }
                if (preg_match('#\bdenied\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['leave_apply.supervisor_status', 'denied'];
                }
                $where_arr[] = ['leave_apply.hr_status', 'pending'];
                $search_arr = [];
            } elseif (preg_match('#\bhr\b#i', $originalSearchVal) === 1) {
                if (preg_match('#\bawaiting\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['leave_apply.hr_status', 'pending'];
                }
                if (preg_match('#\bapproved\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['leave_apply.hr_status', 'approved'];
                }
                if (preg_match('#\bdenied\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['leave_apply.hr_status', 'denied'];
                }
                $search_arr = [];
                $search_arr[] = ['leave_apply.supervisor_status', 'approved'];
                $search_arr[] = ['leave_apply.supervisor_status', 'denied'];
            } elseif (preg_match('#\bapproved\b#i', $originalSearchVal) === 1) {
                $where_arr[] = ['leave_apply.supervisor_status', 'approved'];
                $where_arr[] = ['leave_apply.hr_status', 'approved'];
                $search_arr = [];
            } elseif (preg_match('#\bawaiting\b#i', $originalSearchVal) === 1) {
                $where_arr[] = ['leave_apply.supervisor_status', 'pending'];
                $where_arr[] = ['leave_apply.hr_status', 'pending'];
                $search_arr = [];
            } elseif (preg_match('#\bdenied\b#i', $originalSearchVal) === 1) {
                $where_arr[] = ['leave_apply.supervisor_status', 'denied'];
                $where_arr[] = ['leave_apply.hr_status', 'denied'];
                $search_arr = [];
            }
        };
        $search_arr = array_filter($search_arr, function ($v) {
            return !empty(trim($v[1]));
        });
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $out_arr["recordsFiltered"] = $this->Leave_model->countDatatable($search_arr, $where_arr);
        $rows = $this->Leave_model->getDatatable($search_arr, $where_arr);

        $subordinates = array_column($this->Leave_model->get_subordinates(false, true), 'employee_id');
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                $shift = $this->Leave_model->get_weekend($rec['employee_id']);
                $shift_time = $this->db->select('end')->where('id',$shift->id)->get('shift')->row();
                $apply_date = $rec['apply_date'] .' '.$shift_time->end;
                $hours = $this->date_time_diff_bt_dates($apply_date);
                switch ($col['data']) {
                    case 'apply_strt_date':
                    case 'apply_end_date':
                    case 'leave_aprv_strt_date':
                    case 'leave_aprv_end_date':
                    case 'apply_date':{
                            $tdData = formatted_date($rec[$col['data']]);
                            break;
                        }
                    case 'leave_type':{
                        if ($rec['apply_leave_status'] == 0 && $rec['apply_leave_status'] != '') {
                            $tdData = 'ECL';
                        }
                        else {
                            $tdData = $rec['leave_type'];
                        }
                        break;
                    }
                    case 'num_aprv_day':{
                            $tdData = sprintf('%g / %g', $rec['num_aprv_day'] ?? 0, $rec['apply_day']);
                            break;
                        }
                    case 'hr_status':{
                            if (($rec['leave_type_id'] == 6 || $rec['leave_type_id'] == 7) && $rec['hr_status'] == 'pending') {
                                $leave_type = $rec['leave_type_id'] == 6 ? 'Bereavement Leave' : 'Marriage Leave';
                                $tdData = $leave_type.' can only be approved by the HR Manager';
                            } elseif ($rec['supervisor_id'] && $rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'pending' && $hours > 0) {
                                $timeStatus = $hours <= 0 ? '<p class="punch-time">0 Hours Left</p>' : '<p class="punch-time">'.$hours . ' Hours Left </p>';
                                $tdData = 'Awaiting Supervisor Response <br/> '.$timeStatus;
                            } elseif ($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'approved') {
                                $tdData = 'Approved By Supervisor';
                            } elseif ($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'denied') {
                                $tdData = 'Denied By Supervisor';
                            } elseif ($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'approved') {
                                $tdData = 'Approved By Supervisor';
                            } elseif (!$rec['supervisor_id'] && $rec['hr_status'] == 'pending' && $hours <= 0) {
                                $tdData = 'Awaiting HR Response';
                            } elseif ($rec['supervisor_status'] == 'approved' && $rec['hr_status'] == 'approved' && $rec['hr_approver'] == 0) {
                                $tdData = 'Approved By Supervisor';
                            } elseif ($rec['hr_status'] == 'approved') {
                                $tdData = 'Approved By HR';
                            } elseif ($rec['hr_status'] == 'denied') {
                                $tdData = 'Denied By HR';
                            }
                            break;
                        }
                    case 'action':{
                            if ($rec['hr_status'] == 'approved' || $rec['supervisor_status'] == 'approved') {
                                $tdData = '<span>' . display('approved') . '</span> <br>';
                                
                                if ($this->permission->method('leave_application', 'delete')->access()) {
                                    $tdData .= ' <a href="#" title="Delete Application" class="btn btn-xs btn-danger" onclick="return confirmdelete(\'' . display('are_you_sure') . '\', \'' . base_url("leave/Leave/delete_application/" . $rec['leave_appl_id']) . '\') "><i class="fa fa-trash"></i></a> ';
                                }
                                if ($this->permission->method('leave_application', 'update')->access() && $this->session->userdata('employee_id') != $rec['employee_id'] && ($this->session->userdata('is_hr') == 1 || $this->session->userdata('isAdmin') == 1) && $rec['hr_status'] == 'approved'){
                                    $tdData .= '<a href="' . base_url("leave/Leave/update_application_form/" . $rec['leave_appl_id']) . '" title="Denied" class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                                }
                                break;
                            }
                            if ($rec['employee_id'] == $this->session->userdata('employee_id')) {
                                break;
                            }
                            // in_array($rec['employee_id'], $subordinates) For Supervisor
                            if ($rec['hr_status'] == 'pending' && ($rec['leave_type_id'] == 6 || $rec['leave_type_id'] == 7) && $this->session->userdata('employee_id') != $rec['employee_id'] && $this->session->userdata('is_hr') == 1) {
                                $tdData = '<a href="' . base_url("leave/Leave/update_application_form/" . $rec['leave_appl_id']) . '" class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                            } elseif (($rec['leave_type_id'] == 6 || $rec['leave_type_id'] == 7) && $this->session->userdata('supervisor')){
                                break;
                            } elseif ($this->session->userdata('isAdmin') == 1 && $rec['hr_status'] == 'pending' && $hours <= 0) { 
                                $tdData = '<a href="' . base_url("leave/Leave/update_application_form/" . $rec['leave_appl_id']) . '" class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                            } elseif (($this->session->userdata('employee_id') == $rec['supervisor_id']) && $rec['supervisor_status'] == 'pending' && $rec['hr_status'] == 'pending' && $hours > 0) { 
                                $tdData = '<a href="' . base_url("leave/Leave/update_application_form/" . $rec['leave_appl_id']) . '" class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                            } elseif ($this->permission->method('leave_application', 'update')->access() && $rec['hr_status'] == 'pending' && $hours <= 0) {
                                $tdData = '<a href="' . base_url("leave/Leave/update_application_form/" . $rec['leave_appl_id']) . '" class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                            } elseif ($this->permission->method('leave_application', 'update')->access() && $rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'denied') {
                                $tdData = '<a href="' . base_url("leave/Leave/update_application_form/" . $rec['leave_appl_id']) . '" class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                            }
                            if ($this->permission->method('leave_application', 'delete')->access() && $hours <= 0) { 
                                $tdData .= '<a href="#" title="Delete Application" class="btn btn-xs btn-danger" onclick="return confirmdelete(\'' . display('are_you_sure') . '\', \'' . base_url("leave/Leave/delete_application/" . $rec['leave_appl_id']) . '\') "><i class="fa fa-trash"></i></a>';
                            }
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function valid_date($date)
    {
        return !!preg_match(get_default_date_format('regex-date'), $date);
    }
    public function date_is_after($date, $field)
    {
        if (!$date || !$_POST[$field]) {
            return false;
        }
        $format = get_default_date_format('date');
        $start = DateTime::createFromFormat($format, $_POST[$field]);
        $end = DateTime::createFromFormat($format, $date);
        return $start && $end && $start <= $end;
    }
    public function calculate()
    {
        if ($this->input->post()) {
            $employee_id = $this->session->userdata('employee_id');
            if ($this->permission->method('leave_application', 'update')->access() || $this->session->userdata('supervisor') == 1 || $this->permission->full('leave')->access()) {
                $employee_id = $this->input->post('employee_id');
            }
            $days_data = $this->Leave_model->calculate_range($employee_id, $this->input->post('start'), $this->input->post('end'), false, true);

            if ($days_data['status'] == 'error') {
                sendJson(['error' => $days_data['message']]);
            }
            $leave_data = $this->Leave_model->available_leaves($employee_id, $this->input->post('type'));
            if ($days_data['count'] > ceil($leave_data['quota'] - $leave_data['availed'])) {
                sendJson(['error' => sprintf('Leave selection cannot exceed available leave quota. Only %s leaves are available.', $leave_data['quota'] - $leave_data['availed'])]);
            }
            sendJson(['success' => [
                'days' => $days_data['days'],
                'count' => $days_data['count'],
                'leave_available' => $days_data['leave_available'],
                'calculate_hours' => $days_data['calc_hours'],
                'emp_id' => $employee_id
            ]]);
        }
        return show_404();
    }
    public function date_time_diff_bt_dates($dateTime)
    {
        $d = date('Y-m-d H:i:s');
        $punchout_time = date('Y-m-d H:i:s',strtotime($dateTime .'+48 hours'));
        $diff_in_seconds = strtotime($punchout_time) - strtotime($d);
        $hours = floor($diff_in_seconds / 3600);
        $minutes = floor(($diff_in_seconds % 3600) / 60);
        return $hours;
    }

    public function check_remaining_time()
    {
        $employee_id = $this->input->get('employee_id');
        $shift_id = $this->input->get('shift_id');
        $start = $this->input->get('full_day');
        $end = $start;
        $check_remaining_time = $this->Leave_model->calculate_hours_bw_ed_cd($start,$end,$shift_id,$employee_id);
        sendJson(['result' => $check_remaining_time]);
    }
}
