<?php
$font_styles_list = [
    [
        'aealarabiya' => 'AE Al Arabiya',
        'aefurat' => 'AE Furat',
    ],
    [
        'cid0cs' => 'Cid0 CS',
        'cid0ct' => 'Cid0 CT',
        'cid0jp' => 'Cid0 JP',
        'cid0kr' => 'Cid0 KR',
    ],
    [
        'courier' => 'Courier',
        'courierb' => 'Courier Bold',
        'courieri' => 'Courier Italic',
        'courierbi' => 'Courier Bold Italic',
    ],
    [
        'dejavusans' => 'DejaVu Sans',
        'dejavusansb' => 'DejaVu Sans Bold',
        'dejavusansi' => 'DejaVu Sans Italic',
        'dejavusansbi' => 'DejaVu Sans Bold Italic',
    ],
    [
        'dejavusansextralight' => 'DejaVu Sans Extra-Light',
    ],
    [
        'dejavusansmono' => 'DejaVu Sans Mono',
        'dejavusansmonob' => 'DejaVu Sans Mono Bold',
        'dejavusansmonoi' => 'DejaVu Sans Mono Italic',
        'dejavusansmonobi' => 'DejaVu Sans Mono Bold Italic',
    ],
    [
        'dejavusanscondensed' => 'DejaVu Sans Condensed',
        'dejavusanscondensedb' => 'DejaVu Sans Condensed Bold',
        'dejavusanscondensedi' => 'DejaVu Sans Condensed Italic',
        'dejavusanscondensedbi' => 'DejaVu Sans Condensed Bold Italic',
    ],
    [
        'dejavuserif' => 'DejaVu Serif',
        'dejavuserifb' => 'DejaVu Serif Bold',
        'dejavuserifi' => 'DejaVu Serif Italic',
        'dejavuserifbi' => 'DejaVu Serif Bold Italic',
    ],
    [
        'dejavuserifcondensed' => 'DejaVu Serif Condensed',
        'dejavuserifcondensedb' => 'DejaVu Serif Condensed Bold',
        'dejavuserifcondensedi' => 'DejaVu Serif Condensed Italic',
        'dejavuserifcondensedbi' => 'DejaVu Serif Condensed Bold Italic',
    ],
    [
        'freemono' => 'Free Mono',
        'freemonob' => 'Free Mono Bold',
        'freemonoi' => 'Free Mono Italic',
        'freemonobi' => 'Free Mono Bold Italic',
    ],
    [
        'freesans' => 'Free Sans',
        'freesansb' => 'Free Sans Bold',
        'freesansi' => 'Free Sans Italic',
        'freesansbi' => 'Free Sans Bold Italic',
    ],
    [
        'freeserif' => 'Free Serif',
        'freeserifb' => 'Free Serif Bold',
        'freeserifi' => 'Free Serif Italic',
        'freeserifbi' => 'Free Serif Bold Italic',
    ],
    [
        'helvetica' => 'Helvetica',
        'helveticab' => 'Helvetica Bold',
        'helveticai' => 'Helvetica Italic',
        'helveticabi' => 'Helvetica Bold Italic',
    ],
    [
        'hysmyeongjostdmedium' => 'Hys Myungjo Std Medium',
    ],
    [
        'kozgopromedium' => 'Kozgo Pro Medium',
        'kozminproregular' => 'Kozgo Pro Regular',
    ],
    [
        'msungstdlight' => 'M Sung Light'
    ],
    [
        'pdfacourier' => 'PDF Courier',
        'pdfacourierb' => 'PDF Courier Bold',
        'pdfacourieri' => 'PDF Courier Italic',
        'pdfacourierbi' => 'PDF Courier Bold Italic',
    ],
    [
        'pdfahelvetica' => 'PDF Helvetica',
        'pdfahelveticab' => 'PDF Helvetica Bold',
        'pdfahelveticai' => 'PDF Helvetica Italic',
        'pdfahelveticabi' => 'PDF Helvetica Bold Italic',
    ],
    [
        'pdfasymbol' => 'PDF Symbol',
        'symbol' => 'Symbol',
    ],
    [
        'pdfatimes' => 'PDF Times New Roman',
        'pdfatimesb' => 'PDF Times New Roman Bold',
        'pdfatimesi' => 'PDF Times New Roman Italic',
        'pdfatimesbi' => 'PDF Times New Roman Bold Italic',
    ],
    [
        'pdfazapfdingbats' => 'PDF Zapfdingbats',
        'zapfdingbats' => 'Zapfdingbats',
    ],
    [
        'stsongstdlight' => 'St Song Standard Light',
    ],
    [
        'times' => 'Times New Roman',
        'timesb' => 'Times New Roman Bold',
        'timesi' => 'Times New Roman Italic',
        'timesbi' => 'Times New Roman Bold Italic',
    ]
]; ?>
<div class="container-fluid">
    <form method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="selSize">Page Size</label>
                    <select class="form-control dont-select-me" name="<?= $type_prefix ?>_page_size" id="selSize">
                    <?php foreach ($page_sizes as $key => $value) :?>
                        <option value="<?= $key ?>" <?= $settings[$type_prefix . '_page_size'] == $key ? 'selected' : null ?>><?= sprintf('%s (%s X %s)', $key, $value[0], $value[1]) ?></option>
                    <?php endforeach?>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="selOrientation">Orientation</label>
                    <select class="form-control dont-select-me" name="<?= $type_prefix ?>_orientation" id="selOrientation">
                        <option value="P" <?= $settings[$type_prefix . '_orientation'] == 'P' ? 'selected' : null ?>>Portrait</option>
                        <option value="L" <?= $settings[$type_prefix . '_orientation'] == 'L' ? 'selected' : null ?>>Landscape</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="selFontFamily">Default Font Family</label>
                    <select class="form-control dont-select-me" name="<?= $type_prefix ?>_font_style" id="selFontFamily">
                        <?php foreach ($font_styles_list as $font_style) :
                            foreach ($font_style as $font_style_key => $font_style_value) :?>
                                <option value="<?= $font_style_key ?>" <?= $settings[$type_prefix . '_font_style'] == $font_style_key ? 'selected' : null ?>><?= $font_style_value ?></option>
                            <?php endforeach;
                         endforeach?>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="txtFontSize">Font Size</label>
                    <input type="number" class="form-control" name="<?= $type_prefix ?>_font_size" id="txtFontSize" min="1" max="72" value="<?= $settings[$type_prefix . '_font_size'] ?>">
                </div>
            </div>
        </div>
        <hr>
        <h3 class="text-center">Margin</h3><br>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="txtMT">Top (in)</label>
                    <input type="number" class="form-control" name="<?= $type_prefix ?>_margin_top" id="txtMT" min="0.00" step="0.01" value="<?= $settings[$type_prefix . '_margin_top'] ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="txtMB">Bottom (in)</label>
                    <input type="number" class="form-control" name="<?= $type_prefix ?>_margin_bottom" id="txtMB" min="0.00" step="0.01" value="<?= $settings[$type_prefix . '_margin_bottom'] ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="txtML">Left (in)</label>
                    <input type="number" class="form-control" name="<?= $type_prefix ?>_margin_left" id="txtML" min="0.00" step="0.01" value="<?= $settings[$type_prefix . '_margin_left'] ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="txtMR">Right (in)</label>
                    <input type="number" class="form-control" name="<?= $type_prefix ?>_margin_right" id="txtMR" min="0.00" step="0.01" value="<?= $settings[$type_prefix . '_margin_right'] ?>">
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <table class="table table-hover">
                <caption>Letterheads</caption>
                <thead>
                    <tr>
                        <th>Division</th>
                        <th>View</th>
                        <th>Update Image</th>
                        <th>Remove</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($divisions as $division): ?>
                    <?php
                        $image_location = isset($settings[$type_prefix . '_image_' . strtolower($division->id)]) ? array_to_path([$img_path, $settings[$type_prefix . '_image_' . strtolower($division->id)]]) : null;
                        $image_location_exists = ($image_location && file_exists(FCPATH . $image_location));
                    ?>
                    <tr>
                        <td><?= $division->name ?></td>
                        <td><?= $image_location_exists ? '<a class="btn btn-primary btn-showimage" href="#" data-url="'. base_url($image_location) .'" role="button"><i class="fa fa-eye" aria-hidden="true"> View</i></a>' : 'Not Selected' ?></td>
                        <td>
                          <input type="file" class="form-control-file" accept="image/*" name="<?= $type_prefix ?>_image_<?= strtolower($division->id) ?>">
                        </td>
                        <td>
                        <?php if($image_location_exists): ?>
                            <?php if(($type_prefix == 'hr' && $this->permission->method('pdf_settings', 'delete')->access()) || ($type_prefix == 'manager' && $this->permission->method('manager_pdf_settings', 'delete')->access())): ?>
                                <a class="btn btn-danger btn-sm" href="#" onclick="confirmdelete('Are you sure you want to remove background image of this template?', '<?= base_url('incident/Letter/removebg/' . $type_prefix . '_image_' . strtolower($division->id)) ?>'); return false" role="button"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            <?php endif ?>
                        <?php endif ?>
                        </td>
                    </tr>
                    <?php endforeach?>
                </tbody>
            </table>
        </div>
        <div class="row text-right">
            <button type="submit" class="btn btn-primary">Save</button>
        </div>
    </form>
</div>
<!-- Modal -->
<div class="modal fade" id="modelImageShow" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Letterhead Preview</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            <div class="modal-body">
                <img src="" class="img-responsive" alt="Image">
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        $("select").selectize({
            plugins: ["remove_button"]
        });
    });
    $('.btn-showimage').on('click', function(e){
        e.preventDefault();
        $modal = $('#modelImageShow');
        $modal.find('img').attr('src', $(this).data('url'))
        $modal.modal('show')
    })
    $('form').on('submit', function() {
        show_spinner()
        return true
    })
</script>