<div class="modal fade" id="questions-modal" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <form method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Required Questions</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('#questions-modal').on('hide.bs.modal', function (e) {
            tinymce.editors.forEach(editor => {
                if(!['txtReason', 'txtDescr'].includes(editor.getElement().id)) {
                    setTimeout(() => {
                        editor.remove()
                    }, 1);
                }
            });
        })
        $('form.letter-form').on('submit', function (e) {
            if (e.isTrigger) {
                show_spinner();
                return true;
            }
            var content = tinymce.editors[0].getContent({format: 'text'});
            if($.trim(content) == '')
            {
                alert('Reason is required');
                return false
            }
            e.preventDefault();
            var $form = $(this);
            var $qModal = $('#questions-modal');
            
            var data = {}
            data.letter_id = $('#selLetter').val()
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>incident/letter_details",
                data: data,
                success: function (res) {
                    if(res.fields){
                        $qModal.find('.modal-body').html(res.fields)
                        $qModal.modal('show');return
                    }
                    setTimeout(show_spinner, 100);
                    $form.trigger('submit')
                }
            });
        });
        $('form.incident-form').on('submit', function (e) {
            if (e.isTrigger) {
                show_spinner()
                return true;
            }
            var content = tinymce.editors[0].getContent({format: 'text'});
            if($.trim(content) == '')
            {
                alert('Incident details is required');
                return false
            }
            if($('[name=letter]:checked').val() == 'no'){
                show_spinner()
                return true;
            }
            e.preventDefault();
            var $form = $(this);
            var $qModal = $('#questions-modal');
            
            var data = {}
            data.letter_id = $('#selLetter').val()
            if($('[name=letter]:checked').val() == 'yes' && !data.letter_id){
                alert('Letter field is required')
                return
            }
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>incident/letter_details",
                data: data,
                success: function (res) {
                    if(res.fields){
                        $qModal.find('.modal-body').html(res.fields)
                        $qModal.modal('show');return
                    }
                    setTimeout(show_spinner, 100);
                    $form.trigger('submit')
                }
            });
        })
        $('#questions-modal').on('submit', 'form', function(e){
            e.preventDefault();
            var isErr = false
            tinymce.editors.forEach(editor => {
                var content = editor.getContent({format: 'text'});
                var editor = $(editor.getElement());
                if(!isErr && editor.data('required') && $.trim(content) == '')
                {
                    var label = editor.closest('div').find('label').text()
                    alert(label + ' is required')
                    isErr = true;
                }
            });
            $(this).find('input').each(function(){
                if(!isErr && $(this).attr('readonly') !== undefined && $(this).attr('required') !== undefined && !$(this).val()){
                    $(this).focus()
                    alert(`${$(this).siblings('label').text()} field is required`)
                    isErr = true
                }
            })
            if(isErr){
                return false
            }
            $('form.letter-form, form.incident-form').append(`<input type="hidden" name="inputs" value="${btoa($(this).serialize())}">`)
            $(this).trigger('reset')
            $('#questions-modal').modal('hide')
            $('.modal-backdrop').hide()
            $('form.letter-form, form.incident-form').trigger('submit')
        })
    });
</script>