<table class="table table-hover">
    <tbody>
        <tr>
            <th>#</th>
            <td><?= $incident->id ?></td>
            <th>Letter ID</th>
            <td><?= $incident->genID ?? 'N/A' ?></td>
        </tr>
        <tr>
            <th>Employee:</th>
            <td><?= empty($incident->employee_name) ? implode(' ', [$incident->employee_first_name, $incident->employee_last_name]) : $incident->employee_name ?></td>
            <th>Status:</th>
            <td><?= $this->incident_model->get_status_text($incident->status) ?></td>
        </tr>
        <tr>
            <th>Type</th>
            <td colspan="3"><?= $incident->type == 'letter' ? 'Letter Request' : 'Incident' ?></td>
        </tr>
        <tr>
            <th>Title:</th>
            <td colspan="3"><?= $incident->incident_type ?></td>
        </tr>
        <?php if($this->permission->method('incident_pending', 'update')->access() || $this->permission->method('incident_rejected', 'update')->access() || $this->permission->method('incident_approved', 'update')->access()): ?>
        <tr>
            <th>User Input:</th>
            <td colspan="3"><?php
            if($incident->inputs){
                parse_str($incident->inputs, $incident->inputs);
                foreach ($incident->inputs as $key => $value) {
                    echo sprintf('<b>%s:</b> %s<br>', slug_to_readable($key), $value);
                }
            }else{
                echo 'N/A';
            }?></td>
        </tr>
        <tr>
            <th>Email Sent:</th>
            <td colspan="3"><?= empty($incident->email_sent) ? 'No' : 'Yes'  ?></td>
        </tr>
        <tr>
            <th>Added By:</th>
            <td><?= sprintf('%s %s', $incident->adder_first_name ?? 'HR', $incident->adder_last_name ?? 'Admin')  ?></td>
            <th>Added At:</th>
            <td><?= formatted_date($incident->added_at, true)  ?></td>
        </tr>
        <tr>
            <th>Updated By:</th>
            <td><?= sprintf('%s %s', $incident->editor_first_name ?? 'HR', $incident->editor_last_name ?? 'Admin')  ?></td>
            <th>Updated At:</th>
            <td><?= formatted_date($incident->updated_at, true)  ?></td>
        </tr>
        <?php endif ?>
        <?php if($incident->letter_id && ($this->permission->method('incident_pending', 'update')->access() || $this->permission->method('incident_rejected', 'update')->access() || $this->permission->method('incident_approved', 'update')->access())): ?>
        <tr>
            <th>File:</th>
            <td colspan="3"><a target="_blank" href="<?= base_url('incident/view/') . $incident->id ?>"><?= $incident->incident_type ?>.pdf</a></td>
        </tr>
        <?php endif ?>
        <tr>
            <th><?= $incident->type == 'letter' ? 'Reason' : 'Details' ?>:</th>
            <?php if($incident->type == 'letter'): ?>
                <td colspan="3"><p><?= $incident->reason ?? 'N/A' ?></p></td>
            <?php else: ?>
                <td colspan="3"><p><?= $incident->description ?? 'N/A' ?></p></td>
            <?php endif ?>
        </tr>
    </tbody>
</table>