<div class="container-fluid">
    <form class="incident-form" method="post">
        <div class="row">
            <div class="col-md-2"></div>
            <div class="col-md-8">
                <div class="row">
                    <div class="form-group">
                        <label for="selIncidentType">Employee *</label>
                        <select class="form-control dont-select-me" name="employee_id" id="selEmployee" required>
                            <option value="">Select One</option>
                            <?php foreach ($employees as $employee) :?>
                            <option value="<?= $employee->employee_id ?>">
                                <?= sprintf('%s %s (%s)', $employee->first_name, $employee->last_name, $employee->hrm_id) ?>
                            </option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="selIncidentType">Incident Type *</label>
                        <select class="form-control dont-select-me" name="subject" id="selIncidentType" required>
                            <option value="">Select One</option>
                            <?php foreach ($incidents_types as $incidents_type) :?>
                                <option value="<?= $incidents_type->type ?>"><?= $incidents_type->type ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-6" style="padding-left: 0px;">Does the incident require a letter to be issued? *</label>
                        <label class="form-check-label col-sm-3">
                            <input type="radio" class="form-check-input" name="letter" value="yes">
                            Yes
                        </label>
                        <label class="form-check-label col-sm-3">
                            <input type="radio" class="form-check-input" name="letter" value="no" checked>
                            No
                        </label>
                    </div>
                    <div>&nbsp;</div>
                    <div class="form-group" style="display: none;">
                        <label for="selLetter">Select Letter *</label>
                        <select class="form-control dont-select-me" name="letter_id" id="selLetter" style="width: 100%;">
                            <option value="">Select One</option>
                            <?php foreach ($letters as $letter) :?>
                                <option value="<?= $letter->id ?>"><?= $letter->title ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="txtDescr">Incident Details *</label>
                        <textarea class="form-control" name="description" id="txtDescr" rows="5"
                            placeholder="Details of incident"></textarea>
                    </div>
                    <div class="text-right">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php
require_once(array_to_path([APPPATH, 'modules', 'incident', 'views', 'incident', 'scripts', 'letter_input.php']));
?>
<script src="<?= base_url() ?>assets/plugins/tinymce/tinymce.min.js"></script>
<script src="<?= base_url() ?>assets/plugins/tinymce/jquery.tinymce.min.js"></script>
<script>
    $(document).ready(function () {
        $("select").selectize({
            plugins: ["remove_button"]
        });
        tinymce.init({
            selector: 'textarea#txtDescr',
            menubar: false,
            statusbar: false,
            toolbar: false,
            height: 100,
            paste_remove_styles: true,
            plugins: 'paste',
            paste_as_text: true
        });
    });
    $('[name=letter]').on('change', function (e) {
        $('#selLetter')[0].selectize.clear();
        var letters = $('#selLetter').closest('div');
        letters.hide()
        if($(this).val() == 'yes'){
            letters.show()
        }
    })
</script>