<style>
    .label-success {
        color: white;
        background-color: #45c203;
        border: 2px solid #45c203;
    }
</style>
<div class="container-fluid">
    <table class="table table-hover">
        <thead>
            <tr>
                <th>#</th>
                <th>Letter ID</th>
                <th>Employee</th>
                <th>Type</th>
                <th>Title</th>
                <th>Details/Reason</th>
                <th>Requested By</th>
                <th>Updated</th>
                <?php if($this->permission->method('incident_approved', 'update')->access()): ?>
                <th>Letter</th>
                <?php endif?>
                <th class="hideexport">Action</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script src="<?php echo base_url(); ?>assets/js/ckeditor/ckeditor.js"></script>
<script src="<?php echo base_url(); ?>assets/js/ckeditor/adapters/jquery.js"></script>
<script>
    $(document).ready(function () {
        $("select").selectize({
            plugins: ["remove_button"]
        });
        window.dtable = $('table.table').DataTable($.extend({},
            window.default_datatable_opts, {
                responsive: false,
                processing: true,
                serverSide: true,
                ajax: {
                    method: 'post',
                    beforeSend: function(){},
                    complete: function(){
                        $('.readmore-block').readmore()
                    }
                },
                columns: [{
                        'data': 'id',
                    },{
                        'data': 'genID',
                    }, {
                        'data': 'employee_name',
                    }, {
                        'data': 'type',
                    }, {
                        'data': 'incident_type',
                    }, {
                        'data': 'details',
                    },
                    {
                        'data': 'adder',
                    }, {
                        'data': 'updated_at',
                    },
                    <?php if($this->permission->method('incident_approved', 'update')->access()): ?>
                    {
                        'data': 'file_path',
                    },
                    <?php endif ?>
                    {
                        'data': 'action',
                        'sortable': false
                    },
                ],
                order: [
                    [7, 'desc']
                ]
            }
        ))
        $('#modelcomposeemail').on('change', '[name=inOrg]', function(e){
            if(!this.checked){
                return
            }
            var $modal_email = $('#modelcomposeemail');
            $modal_email.find('[name=eto]').attr('readonly', 'readonly')
            $modal_email.find('[name=cc]').attr('readonly', 'readonly')
            $modal_email.find('[name=efrom]')[0].selectize.disable()
            if(this.value == 'no'){
                $modal_email.find('[name=eto]').removeAttr('readonly')
                $modal_email.find('[name=cc]').removeAttr('readonly')
                $modal_email.find('[name=efrom]')[0].selectize.enable()
            }else{
                if(window.email_pop_default){
                    $modal_email.find('[name=efrom]')[0].selectize.setValue(window.email_pop_default.division_id)
                    $modal_email.find('[name=eto]').val(window.email_pop_default.eto)
                    $modal_email.find('[name=cc]').val(window.email_pop_default.cc)
                }
            }
        })
        $('#modelcomposeemail').on('submit', 'form', function (e) {
            e.preventDefault()
            $form = $(this)
            if($form.find('[name=eto]').val() && !validateEmails($form.find('[name=eto]').val())){
                $form.find('[name=eto]').focus();
                alert('The \'To\' field must have valid emails');return
            }
            if($form.find('[name=cc]').val() && !validateEmails($form.find('[name=cc]').val())){
                $form.find('[name=cc]').focus();
                alert('The \'CC\' field must have valid emails');return
            }
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>incident/send_email",
                data: $(this).serialize(),
                beforeSend: function(){
                    show_spinner()
                    $form.find('span.error').remove()
                },
                success: function (res) {
                    if(res.success){
                        $('#modelcomposeemail').modal('hide')
                        window.dtable.ajax.reload()
                        toastr.success(res.success)
                    }else if(res.error){
                        alert(res.error)
                    }else if(res.errors){
                        res.errors.forEach(err => {
                            $form.find(`[name=${err[0]}]`).closest('div').append(`<span class="error" style="color:red">${err[1]}</span>`)
                        });
                    }
                }
            });
        })
        $('#modelcomposeemail').on('change', '#selEmTemp', function (e) {
            if (!this.value) {
                return
            }
            $sel = $(this)
            $modal = $('#modelcomposeemail')
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>incident/policies/get_email_template",
                data: {
                    id: this.value
                },
                beforeSend: function () {
                    $modal.find('.error').remove()
                },
                success: function (res) {
                    if (res.success) {
                        $modal.find('[name=subject]').val(res.success.subject)
                        $modal.find('[name=body]').val(res.success.body)
                    } else if (res.error) {
                        $sel.closest('div').append(
                            `<span class="error" style="color:red">${res.error}</span>`)
                    } else {
                        alert('Unable to get email template');
                        console.log(res);
                    }
                }
            });
        })
    });
    $('table.table').on('click', '.btn-sendemail', function(e){
        e.preventDefault()
        var id = $(this).data('id')
        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>incident/email_status/" + id,
            success: function (res) {
                if(res.sent && !confirm('Email is already sent for this letter. Are you sure you want to resend it?')){
                    return
                }
                $.ajax({
                    type: "GET",
                    url: "<?= base_url() ?>incident/get_email/" + id,
                    success: function (res) {
                        if(res.success){
                            var $modal_email = $('#modelcomposeemail');
                            
                            $modal_email.find('#inOrgYes').prop('checked', true)
                            $modal_email.find('#inOrgYes').trigger('change')
                            $modal_email.find('#selEmTemp').val('').trigger('change')
                            $modal_email.find('#txtBody').val('')

                            $modal_email.find('[name=id]').val(id)
                            window.email_pop_default = {
                                division_id: res.success.division_id,
                                eto: res.success.eto,
                                cc: res.success.cc,                                
                            }
                            $modal_email.find('[name=efrom]')[0].selectize.setValue(res.success.division_id)
                            $modal_email.find('[name=eto]').val(res.success.eto)
                            $modal_email.find('[name=cc]').val(res.success.cc)
                            $modal_email.find('[name=subject]').val(res.success.subject)
                            $modal_email.find('a.atment').attr('href', '<?= base_url() ?>incident/view/' + id)
                            $modal_email.find('a.atment').text(res.success.subject + '.pdf')
                            $modal_email.modal('show')
                            $( '[name=body]' ).ckeditor();
                        }else if(res.error){
                            alert(res.error)
                        }else{
                            console.log(res);
                            alert('Unknown error, try again')
                        }
                    }
                });
            }
        });
    })
</script>
<?php require_once(APPPATH . 'modules/incident/views/incident/scripts/save_print.php') ?>
<?php require_once(APPPATH . 'modules/incident/views/incident/scripts/logs.php') ?>
<div class="modal fade" id="modelcomposeemail" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Email Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            <form method="post">
                <div class="modal-body">
                    <div class="container-fluid">
                        <input type="hidden" name="id" class="form-control" value="">
                        <div class="row">
                            <div class="form-group col-sm-12">
                              <label for="txtFrom">From</label>
                              <select class="form-control dont-select-me" name="efrom" id="txtFrom" placeholder="Select from email" disabled="disabled" required="requried">
                                <?php foreach ($email_settings as $email_setting) :?>
                                    <option value="<?= $email_setting->division_id ?>"><?= $email_setting->email_from ?></option>
                                <?php endforeach?>
                              </select>
                            </div>
                            <div class="form-group col-sm-8">
                                <label for="txtTo">To <small>(Comma separated email addresses)</small></label>
                                <input type="text" class="form-control" name="eto" id="txtTo" required readonly>
                            </div>
                            <div class="col-sm-4">
                                <label for="">Send Inside Organization?</label>
                                <div class="form-check">
                                    <label class="form-check-label">
                                    <input type="radio" class="form-check-input" id="inOrgYes" name="inOrg" value="yes" checked>
                                    Yes
                                  </label>
                                </div>
                                <div class="form-check">
                                    <label class="form-check-label">
                                    <input type="radio" class="form-check-input" id="inOrgNo" name="inOrg" value="no">
                                    No
                                  </label>
                                </div>
                            </div>
                            <div class="form-group col-sm-12">
                                <label for="txtCC">CC <small>(Comma separated email addresses)</small></label>
                                <input type="text" class="form-control" name="cc" id="txtCC" required readonly>
                            </div>
                            <div class="form-group col-sm-12">
                                <label for="selEmTemp">Email Template</label>
                                <select class="form-control dont-select-me" name="email" id="selEmTemp" style="width: 100%;">
                                    <option value="">Select One</option>
                                    <?php foreach ($email_templates as $em_template) :?>
                                    <option value="<?= $em_template->id ?>"><?= $em_template->name ?></option>
                                    <?php endforeach?>
                                </select>
                            </div>
                            <div class="form-group col-sm-12">
                                <label for="txtSubject">Subject</label>
                                <input type="text" class="form-control" name="subject" id="txtSubject">
                            </div>
                            <div class="form-group col-sm-12">
                                <label for="txtBody">Body</label>
                                <textarea class="form-control" name="body" id="txtBody" rows="3"></textarea>
                            </div>
                            <div class="form-group col-sm-12">
                                <label for="">Attachment:</label>
                                <a href="" target="_blank" class="form-control atment" role="button"></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Send</button>
                </div>
            </form>
        </div>
    </div>
</div>