class Question {
    constructor(questions) {
        if (!questions) {
            questions = {}
        }
        this.__questions_list = questions;
    }
    get_by_id(id) {
        return this.__questions_list[id]
    }
    get(slug, exlude_id) {
        if (!exlude_id) {
            exlude_id = 0;
        }
        if (slug) {
            return Object.values(this.__questions_list).find((v) => {
                return v.name.toLowerCase() == slug.toLowerCase() && v.id != exlude_id
            });
        } else {
            return this.__questions_list
        }
    }
    set(id, question) {
        id = (id + '').substr(0) //deep copy
        question.id = id
        this.__questions_list[id] = question
    }
    update(id, question) {
        this.__questions_list[id] = question
    }
    delete(slug) {
        for (const key in this.__questions_list) {
            if (Object.hasOwnProperty.call(this.__questions_list, key) && this.__questions_list[key].name == slug.toLowerCase()) {
                delete this.__questions_list[key]
            }
        }
    }
}