<?php $this->load->view('dashboard/partials/angular') ?>
<script>
$('input.show_password').on('click', function() {
    if(!this.checked) {
        $(this).closest('div.form-group').children('input').attr('type', 'text')
    } else {
        $(this).closest('div.form-group').children('input').attr('type', 'password')
    }
});
hrmApp.controller('employee_updateCtrl', function($scope) {
    $scope.salary_increments = [];
    $scope.employee = {
        basic_salary: parseFloat('<?= $data->rate ?? 0 ?>'),
        gross_salary: parseFloat('<?= $data->current_salary ?? 0 ?>'),
        hired_salary: parseFloat('<?= $data->hired_salary ?? 0 ?>'),
        provident_fund: parseFloat('<?= @$deductions[1]['value'] ?? 0 ?>'),
        other_allowances: parseFloat('<?= @$additions[1]['value'] ?? 0 ?>'),
        provident_fund_check: <?= $data->provident_fund_check == 1 ? 'true' : 'false'  ?>,
        medflow_id: '<?= $data->medflow_id ?>',
        domain_name: '<?= $data->domain_name ?>',
        duty_type: '<?= $data->duty_type ?? 5 ?>',
    }
    $scope.clean_number = function(num) {
        if(typeof num != 'number') {
            return parseFloat(num.replace(/\,+/g, ''))
        }
        return num;
    }
    $scope.calculate_percentage = function(value, percentage) {
        return parseFloat((parseFloat(value) * (percentage / 100)).toFixed(2));
    }
    $scope.pf_calculate = function() {
        $scope.employee.provident_fund = $scope.calculate_percentage($scope.employee.basic_salary, 9.3)
    }
    $scope.calculate_gross_salary = function() {
        $scope.employee.basic_salary = $scope.calculate_percentage($scope.employee.gross_salary, 68);
        $scope.employee.other_allowances = $scope.calculate_percentage($scope.employee.gross_salary, 32);
        $scope.pf_calculate()
    }
    $scope.calculate_salary = function() {
        $scope.employee.gross_salary = parseFloat($scope.employee.hired_salary);
        $scope.employee.gross_salary += $scope.salary_increments.reduce(function(sum, increment) {
            if(new Date().getTime() >= moment(increment.date, 'DD-MM-YYYY').valueOf()) {
                return sum + parseFloat($scope.clean_number(increment.amount));
            }
            return sum;
        }, 0);
        $scope.calculate_gross_salary()
    }
    $scope.salary_check = function() {
        if (!$scope.employee.gross_salary) {
            return
        }
        let basic_correct = $scope.calculate_percentage($scope.employee.gross_salary, 68) == $scope.employee
            .basic_salary;
        if (!basic_correct) {
            if (confirm(
                    'Basic salary field is not set to 68% of gross salary, auto-calculate and correct it?'
                )) {
                $scope.employee.basic_salary = $scope.calculate_percentage($scope.employee.gross_salary,
                    68);
                $('ul.nav-tabs').find(`a[href="#menu2"]`).trigger('click')
            }
        }
        let other_allowances_correct = $scope.calculate_percentage($scope.employee.gross_salary, 32) ==
            $scope.employee.other_allowances;
        if (!other_allowances_correct) {
            if (confirm(
                    'Other allowances field is not set to 32% of gross salary, auto-calculate and correct it?'
                )) {
                $scope.employee.other_allowances = $scope.calculate_percentage($scope.employee.gross_salary,
                    32);
                $('ul.nav-tabs').find(`a[href="#menu2"]`).trigger('click')
            }
        }
        if (!$scope.employee.basic_salary) {
            return
        }
        let pf_correct = $scope.calculate_percentage($scope.employee.basic_salary, 9.3) == $scope.employee
            .provident_fund;
        if ('<?= $data->duty_type ?>' != 5 && !pf_correct) {
            if (confirm(
                    'Provident fund field is not set to 9.3% of basic salary, auto-calculate and correct it?'
                )) {
                $scope.employee.provident_fund = $scope.calculate_percentage($scope.employee.basic_salary,
                    9.3);
                $('ul.nav-tabs').find(`a[href="#menu2"]`).trigger('click')
            }
        }
    }
    $scope.add_salary_increment = function(amount = 0, date = null) {
        $scope.salary_increments.push({
            amount: amount,
            date: moment(date ?? new Date()).format("DD-MM-YYYY"),
        })
        $('#salary_raise .panel-body').one('mousemove', function() {
            $('#salary_raise .currency').inputmask({
                alias: 'numeric',
                groupSeparator: ',',
                digitsOptional: true,
                placeholder: '0',
                min: 0
            })
            $('#salary_raise .datepickr').flatpickr({
                dateFormat: 'd-m-Y',
                animate: false
            })
        })
    }
    $scope.delete_salary_increment = function(index) {
        if (confirm('Are you sure you want to delete this salary increment?')) {
            $scope.salary_increments.splice(index, 1)
        }
        $scope.calculate_salary()
    }
    $scope.format_ordinal = function(num) {
        return moment.localeData().ordinal(num);
    }

    <?php if(isset($salary_increments)): ?>
    <?php foreach($salary_increments as $salary_increment): ?>
    $scope.add_salary_increment(<?= $salary_increment['amount'] ?>, '<?= $salary_increment['date'] ?>')
    <?php endforeach ?>
    <?php endif ?>
    setTimeout(() => {
        $scope.calculate_salary()
    }, 500);
})
</script>