<style>
.tab-pane .form-group.text-right {
    text-align: right;
}

.nav.nav-tabs li:not(.active) a {
    pointer-events: all;
}
</style>
<div id="opts_body" class="container-fluid">
    <div class="row">
        <ul class="nav nav-tabs">
            <?php $first_opt = reset($types);
foreach ($types as $value): ?>
            <li class="<?=$first_opt == $value ? 'active' : null?>"><a data-toggle="tab" data-target="#<?=$value?>"
                    href="#<?=$value?>"><?=slug_to_readable($value)?></a></li>
            <?php endforeach?>
        </ul>
        <div class="tab-content">
            <?php foreach ($types as $value): ?>
            <div class="tab-pane fade <?=$first_opt == $value ? 'in active' : null?>" id="<?=$value?>" data-name="<?=slug_to_readable($value)?>" data-type="<?=$value?>">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <div class="form-group text-right">
                            <?php if ($this->permission->method('employee_form_options', 'create')->access()): ?>
                            <button type="button" class="btn btn-primary btn-add"><i
                                    class="fa fa-plus-circle" aria-hidden="true"></i> Add <?=slug_to_readable($value)?>
                                Option
                            </button>
                            <?php endif;?>
                        </div>
                        <table class="table table-hover" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th>Option</th>
                                    <?php if ($this->permission->method('employee_form_options', 'update')->access() || $this->permission->method('employee_form_options', 'delete')->access()): ?>
                                    <th class="hideexport">Action</th>
                                    <?php endif;?>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php endforeach?>
        </div>
    </div>
</div>
<div class="modal fade" id="model-opt" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false"
    aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="#" method="post">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="value"></label>
                        <input type="text" class="form-control" name="value" placeholder="Enter option value" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
var option = {
    id: null,
    type: null,
    value: null
}
function dt_opts(hash) {
    return $.extend({},
        window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                url: "<?=base_url('employee/form_options/table/')?>" + hash,
                beforeSend: function() {},
            },
            columns: [{
                    'data': 'value',
                },
                <?php if ($this->permission->method('employee_form_options', 'update')->access() || $this->permission->method('employee_form_options', 'delete')->access()): ?>
                {
                    'data': 'action',
                    'sortable': false
                },
                <?php endif ?>
            ],
            order: [
                [0, 'asc']
            ]
        }
    )
}
$('.nav-tabs a').on('shown.bs.tab', function(e) {
    window.dtable && window.dtable.destroy()
    delete window.dtable;
    var hash = e.target.href.split('#')[1];
    window.dtable = $(`#${hash} table`).DataTable(dt_opts(hash))
})
$(function() {
    window.useddTable = $('#modelUsed table').DataTable($.extend({}, window.default_datatable_opts, {
        searching: false,
        paging: false
    }))
    window.dtable = $('#<?=$first_opt?> table.table').DataTable(dt_opts('<?=$first_opt?>'))
    $('.tab-content').on('click', '.btn-delete', function(e) {
        e.preventDefault();
        var $btn = $(this)
        var $type = $(this).closest('.tab-pane').data('name');
        var $text = $btn.closest('tr').find('td').first().text();
        Swal.fire({
            title: 'Are you sure?',
            html: `Pressing yes will delete the <b>"${$text}"</b> option from <b>${$type}</b> dropdown.<br>You won't be able to revert this!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?=base_url('employee/form_options/delete')?>",
                    data: {
                        id: $btn.data('id')
                    },
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?=display('deleted')?>!',
                                res.success,
                                'success'
                            )
                            window.dtable.ajax.reload();
                        } else if (res.used) {
                            var $modalUsed = $('#modelUsed');
                            $modalUsed.find('.value_name').text($text);
                            $modalUsed.find('.type_name').text($type);

                            window.useddTable && window.useddTable.clear();
                            res.used.forEach(employee => {
                                window.useddTable.row.add([
                                    employee.hrm_id,
                                    `${employee.first_name} ${employee.last_name}`,
                                    `<a target="_blank" href="<?= base_url('employee/employees/update/') ?>${employee.employee_id}"><?= base_url('employee/employees/update/') ?>${employee.employee_id}</a>`
                                ])
                            });
                            window.useddTable && window.useddTable.draw();
                            $modalUsed.modal('show');
                        } else if (res.error) {
                            Swal.fire(
                                '<?=display('error')?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?=display('error')?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }

                    }
                });
            }
        })
    })
    $('.tab-content').on('click', '.btn-edit', function(e) {
        e.preventDefault();
        var $modal = $('#model-opt');
        var $btn = $(this);
        var $pane = $btn.closest('.tab-pane');
        myajax({
            type: "POST",
            url: "<?=base_url('employee/form_options/get')?>",
            data: {
                id: $(this).data('id')
            },
            success: function(res) {
                if (res.success) {
                    option.id = res.success.id
                    option.type = res.success.type
                    option.value = res.success.value

                    $modal.find('label').text($pane.data('name'))
                    $modal.find('.modal-title').text('Update ' + $pane.data('name') + ' Option')
                    $modal.find('input').val(res.success.value)
                    $modal.modal('show')
                } else {
                    alert(res.error)
                }
            }
        });
    });
    $('.tab-content').on('click', '.btn-add', function(e) {
        e.preventDefault();
        var $modal = $('#model-opt');
        var $btn = $(this);
        var $pane = $btn.closest('.tab-pane');
        option.type = $pane.data('type')
        $modal.find('label').text($pane.data('name'))
        $modal.find('.modal-title').text('Add ' + $pane.data('name') + ' Option')
        $modal.modal('show')
    });
});
$('#model-opt').on('hide.bs.modal', function (e) {
    $(this).find('form').trigger('reset');
    option = {
        id: null,
        type: null,
        value: null
    }
})
$('#model-opt form').on('submit', function(e) {
    e.preventDefault();
    option.value = $(this).find('input').val();
    myajax({
        type: "POST",
        url: "<?=base_url('employee/form_options/save')?>",
        data: option,
        success: function (res) {
            if(res.success) {
                Swal.fire(
                    '<?=display('success')?>!',
                    res.success,
                    'success'
                )
                $('#model-opt').modal('hide')
            } else if (res.error) {
                Swal.fire(
                    '<?=display('error')?>!',
                    res.error,
                    'error'
                )
            } else {
                Swal.fire(
                    '<?=display('error')?>!',
                    'Unknown server error, try again',
                    'error'
                )
            }
            window.dtable.ajax.reload();
        }
    });
})
</script>
<div class="modal fade" id="modelUsed" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Option is under use and cannot be deleted</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            <div class="modal-body">
                The option <b><span class="value_name"></span></b> from dropdown <b><span class="type_name"></span></b> is being used by following employees. Please update their profile and try deleting again.
                <br>
                <table class="table" style="width: 100%;">
                    <thead>
                        <tr>
                            <th>HRM ID</th>
                            <th>Name</th>
                            <th>Employee Form</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>